/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.NameMangler;
import hep.rootio.RootClass;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractRootObject
implements RootObjectRepresentation {
    private long expectedEnd = 0L;
    private int length;
    private Hashtable hash = new Hashtable();
    private Hashtable mangledHash = new Hashtable();
    private static final RootObjectRepresentation[] noSuperClasses = new RootObjectRepresentation[0];
    private RootClass rootClass;
    private RootObjectRepresentation[] superClasses = new RootObjectRepresentation[10];
    private static final NameMangler nameMangler = NameMangler.instance();

    public void init(RootClass rootClass) {
        this.rootClass = rootClass;
        this.superClasses = this.createSuperClasses();
    }

    private RootObjectRepresentation[] createSuperClasses() {
        RootClass[] superClasses = this.rootClass.getSuperClasses();
        if (superClasses.length == 0) {
            return noSuperClasses;
        }
        RootObjectRepresentation[] result = new RootObjectRepresentation[superClasses.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = superClasses[i].newInstance();
        }
        return result;
    }

    @Override
    public void read(RootInput in) throws IOException {
        try {
            int v = in.readVersion(this);
            RootObjectRepresentation[] superClasses = this.getSuperClasses();
            for (int i = 0; i < superClasses.length; ++i) {
                superClasses[i].read(in);
            }
            this.readMembers(in, v);
            in.checkLength(this);
        }
        catch (IOException x) {
            System.err.println("Error occured while reading " + this.getRootClass());
            this.dump();
            throw x;
        }
    }

    protected abstract void readMembers(RootInput var1, int var2) throws IOException;

    protected void put(String name, Object s) {
        if (s != null) {
            this.hash.put(name, s);
            this.mangledHash.put(nameMangler.mangleMember(name), s);
        }
    }

    @Override
    public Enumeration members() {
        return this.hash.keys();
    }

    @Override
    public int nMembers() {
        return this.hash.size();
    }

    @Override
    public Object get(String name) {
        Object result = this.hash.get(name);
        if (result != null) {
            return result;
        }
        RootObjectRepresentation[] superClasses = this.getSuperClasses();
        for (int i = superClasses.length - 1; i >= 0; --i) {
            result = superClasses[i].get(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Object getMangled(String name) {
        Object result = this.mangledHash.get(name);
        if (result != null) {
            return result;
        }
        RootObjectRepresentation[] superClasses = this.getSuperClasses();
        for (int i = superClasses.length - 1; i >= 0; --i) {
            result = superClasses[i].getMangled(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        out.println("Object Class " + this.getRootClass());
        Enumeration keys = this.hash.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = this.hash.get(key);
            out.println("  " + key + "=" + value);
        }
    }

    void setExpectedLength(long start, int len) {
        this.length = len;
        this.expectedEnd = start + (long)len;
    }

    void checkLength(long end) throws IOException {
        if (this.expectedEnd != 0L && this.expectedEnd != end) {
            throw new IOException("Error reading " + this.getRootClass().getClassName() + ": Unexpected length (expected " + this.length + " got " + (end - this.expectedEnd + (long)this.length) + ")");
        }
    }

    @Override
    public RootObjectRepresentation[] getSuperClasses() {
        return this.superClasses;
    }

    @Override
    public RootClass getRootClass() {
        return this.rootClass;
    }

    @Override
    public RootObjectRepresentation getSuperClass(String name) {
        if (this.rootClass.getClassName().equals(name)) {
            return this;
        }
        int i = this.superClasses.length;
        while (i-- > 0) {
            if (!this.superClasses[i].getRootClass().getClassName().equals(name)) continue;
            return this.superClasses[i];
        }
        return null;
    }

    @Override
    public abstract Object getProxy();
}

