/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.io.Serializable;

public class Range2D
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public double start;
    public double end;
    public double delta;

    public Range2D() {
        this(Double.NaN, Double.NaN, Double.NaN);
    }

    public Range2D(double ustart, double uend) {
        this(ustart, uend, Double.NaN);
    }

    public Range2D(double ustart, double uend, double udel) {
        this.start = ustart;
        this.end = uend;
        this.delta = udel;
    }

    public void add(Range2D range) {
        this.start = Math.min(this.start, range.start);
        this.end = Math.max(this.end, range.end);
    }

    public boolean equals(Range2D r) {
        if (!Double.isNaN(this.start) && !Double.isNaN(r.start)) {
            if (Double.isNaN(this.start) || Double.isNaN(r.start)) {
                return false;
            }
            if (this.start != r.start) {
                return false;
            }
        }
        if (!Double.isNaN(this.end) && !Double.isNaN(r.end)) {
            if (Double.isNaN(this.end) || Double.isNaN(r.end)) {
                return false;
            }
            if (this.end != r.end) {
                return false;
            }
        }
        if (!Double.isNaN(this.delta) && !Double.isNaN(r.delta)) {
            if (Double.isNaN(this.delta) || Double.isNaN(r.delta)) {
                return false;
            }
            if (this.delta != r.delta) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("[").append(this.start).append(";").append(this.end);
        if (Double.isNaN(this.delta)) {
            buf.append("]");
        } else {
            buf.append(";").append(this.delta).append("]");
        }
        return buf.toString();
    }

    public Range2D copy() {
        try {
            return (Range2D)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

