/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sgtplot.util.IllegalTimeValue;

public class GeoDate
extends Date
implements Serializable {
    private int[] max_day_ = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private boolean splitDone_;
    private int yearday_;
    private int dayofweek_;
    private int year_;
    private int month_;
    private int day_;
    private int hour_;
    private int minute_;
    private int second_;
    private int msec_;
    private int MSec_;
    private int JDay_;
    private boolean EPICTimeDone_;
    private boolean relativeTime_ = false;
    private static Calendar cal_ = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    public static final int DAYS = 1;
    public static final int MONTHS = 2;
    public static final int YEARS = 4;
    public static final int HOURS = 5;
    public static final int MINUTES = 6;
    public static final int SECONDS = 7;
    public static final int MSEC = 8;
    public static final long MSECS_IN_DAY = 86400000L;

    public GeoDate() {
    }

    public GeoDate(String time, String format) throws IllegalTimeValue {
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setCalendar(cal_);
        Date dte = ((DateFormat)df).parse(time, pos);
        if (dte == null) {
            throw new IllegalTimeValue("Parse error: " + time + ", " + format);
        }
        this.setTime(dte.getTime());
    }

    public GeoDate(GeoDate t) {
        super(t.getTime());
    }

    public GeoDate(int mon, int day, int year, int hour, int min, int sec, int msec) throws IllegalTimeValue {
        this.set(mon, day, year, hour, min, sec, msec);
    }

    public GeoDate(Date date) {
        this.setTime(date.getTime());
    }

    public GeoDate(int jday, int msec) {
        this.set(jday, msec);
    }

    public GeoDate(long date) {
        this.setTime(date);
    }

    public void setRelativeTime(boolean relative) {
        this.relativeTime_ = relative;
    }

    public boolean isRelativeTime() {
        return this.relativeTime_;
    }

    public void set(int jday, int msec) {
        int ja;
        if (jday > 2299161) {
            double jalpha = ((double)(jday - 1867216) - 0.25) / 36524.25;
            ja = jday + 1 + (int)jalpha - (int)(0.25 * jalpha);
        } else {
            ja = jday;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = (int)((double)(365 * jc) + 0.25 * (double)jc);
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        ja = msec / 1000;
        int hour = ja / 3600;
        int minute = (ja - hour * 3600) / 60;
        double second = (double)(msec - (hour * 3600 + minute * 60) * 1000) / 1000.0;
        int sec = (int)second;
        msec = (int)(second * 1000.0) % 1000;
        try {
            this.set(month, day, year, hour, minute, sec, msec);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
    }

    public void set(int mon, int day, int year, int hour, int min, int sec, int msec) throws IllegalTimeValue {
        int leap = year % 4 != 0 ? 0 : (year % 400 == 0 ? 1 : (year % 100 == 0 ? 0 : 1));
        this.max_day_[1] = 28 + leap;
        if (mon > 12 || mon < 1) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of month out of range");
        }
        if (day > this.max_day_[mon - 1] || day < 1) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of day out of range");
        }
        if (hour >= 24 || hour < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of hour out of range");
        }
        if (min >= 60 || min < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of minute out of range");
        }
        if (sec >= 60 || sec < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of second out of range");
        }
        if (msec >= 1000 || msec < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of msec out of range");
        }
        cal_.clear();
        cal_.set(year, mon - 1, day, hour, min, sec);
        this.setTime(cal_.getTime().getTime() + (long)msec);
        this.splitDone_ = false;
        this.EPICTimeDone_ = false;
    }

    public int getDaysInMonth() {
        int year = cal_.get(1);
        int leap = year % 4 != 0 ? 0 : (year % 400 == 0 ? 1 : (year % 100 == 0 ? 0 : 1));
        this.max_day_[1] = 28 + leap;
        return this.max_day_[this.month_ - 1];
    }

    public void now() {
        Date nw = new Date();
        this.setTime(nw.getTime());
    }

    public GeoDate add(GeoDate time) {
        GeoDate time2 = new GeoDate();
        long MSec = this.getTime() + time.getTime();
        time2.splitDone_ = false;
        time2.EPICTimeDone_ = false;
        time2.setTime(MSec);
        return time2;
    }

    public GeoDate subtract(GeoDate time2) {
        GeoDate delta = new GeoDate();
        long MSec = this.getTime() - time2.getTime();
        delta.splitDone_ = false;
        delta.EPICTimeDone_ = false;
        delta.setTime(MSec);
        delta.setRelativeTime(true);
        return delta;
    }

    public GeoDate divide(double val) {
        GeoDate result = new GeoDate();
        if (val == 0.0) {
            return null;
        }
        result.setTime((long)((double)this.getTime() / val));
        result.splitDone_ = false;
        result.EPICTimeDone_ = false;
        result.setRelativeTime(true);
        return result;
    }

    void splitTimeFormat() {
        if (this.splitDone_) {
            return;
        }
        cal_.setTime(this);
        this.day_ = cal_.get(5);
        this.month_ = cal_.get(2) + 1;
        this.year_ = cal_.get(1);
        this.hour_ = cal_.get(11);
        this.minute_ = cal_.get(12);
        this.second_ = cal_.get(13);
        this.msec_ = cal_.get(14);
        this.dayofweek_ = cal_.get(7) - 1;
        this.yearday_ = cal_.get(6);
        this.splitDone_ = true;
    }

    public GeoDate increment(float val, int tu) {
        return this.increment((double)val, tu);
    }

    public GeoDate increment(double val, int tu) {
        int ival = (int)val;
        double fract = val - (double)ival;
        long MSec = this.getTime();
        switch (tu) {
            case 8: {
                this.setTime(MSec += (long)val);
                break;
            }
            case 7: {
                this.setTime(MSec += (long)(val * 1000.0));
                break;
            }
            case 6: {
                this.setTime(MSec += (long)(val * 60000.0));
                break;
            }
            case 5: {
                this.setTime(MSec += (long)(val * 3600000.0));
                break;
            }
            case 1: {
                this.setTime(MSec += (long)(val * 8.64E7));
                break;
            }
            case 2: {
                this.splitTimeFormat();
                this.month_ += ival;
                this.year_ += (this.month_ - 1) / 12;
                this.month_ -= (this.month_ - 1) / 12 * 12;
                if (this.month_ == 0) {
                    this.month_ = 1;
                }
                int leap = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + leap;
                this.day_ += (int)(fract * (double)this.max_day_[this.month_ - 1]);
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ -= this.max_day_[this.month_ - 1];
                    ++this.month_;
                    this.year_ += (this.month_ - 1) / 12;
                    this.month_ -= (this.month_ - 1) / 12 * 12;
                    if (this.month_ == 0) {
                        this.month_ = 1;
                    }
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue e) {
                    System.err.println(e);
                }
                break;
            }
            case 4: {
                this.splitTimeFormat();
                this.year_ += ival;
                int leap = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + leap;
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ = this.max_day_[this.month_ - 1];
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue e) {
                    System.err.println(e);
                }
                this.setTime(this.getTime() + (long)(fract * 365.25) * 86400000L);
            }
        }
        this.splitDone_ = false;
        this.EPICTimeDone_ = false;
        return this;
    }

    public GeoDate decrement(float val, int tu) {
        return this.decrement((double)val, tu);
    }

    public GeoDate decrement(double val, int tu) {
        int ival = (int)val;
        double fract = val - (double)ival;
        long MSec = this.getTime();
        switch (tu) {
            case 8: {
                this.setTime(MSec -= (long)val);
                break;
            }
            case 7: {
                this.setTime(MSec -= (long)(val * 1000.0));
                break;
            }
            case 6: {
                this.setTime(MSec -= (long)(val * 60000.0));
                break;
            }
            case 5: {
                this.setTime(MSec -= (long)(val * 3600000.0));
                break;
            }
            case 1: {
                this.setTime(MSec -= (long)(val * 8.64E7));
                break;
            }
            case 2: {
                this.splitTimeFormat();
                this.month_ -= ival;
                if (this.month_ <= 0) {
                    this.year_ -= (this.month_ - 1) / 12 + 1;
                    this.month_ += (this.month_ - 1) / 12 * 12 + 12;
                }
                if (this.month_ == 0) {
                    this.month_ = 12;
                }
                int leap = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + leap;
                this.day_ -= (int)(fract * (double)this.max_day_[this.month_ - 1]);
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ -= this.max_day_[this.month_ - 1];
                    --this.month_;
                    if (this.month_ <= 0) {
                        this.year_ -= (this.month_ - 1) / 12 + 1;
                        this.month_ += (this.month_ - 1) / 12 * 12;
                    }
                    if (this.month_ == 0) {
                        this.month_ = 12;
                    }
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue e) {
                    System.err.println(e);
                }
                break;
            }
            case 4: {
                this.splitTimeFormat();
                this.year_ -= ival;
                int leap = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + leap;
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ = this.max_day_[this.month_ - 1];
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue e) {
                    System.err.println(e);
                }
                this.setTime(this.getTime() - (long)(fract * 365.25) * 86400000L);
            }
        }
        this.splitDone_ = false;
        this.EPICTimeDone_ = false;
        return this;
    }

    public double offset(GeoDate ref) {
        double val = (double)(this.getTime() - ref.getTime()) / 8.64E7;
        return val;
    }

    public void setYearYearDay(int year, int yearday) {
        try {
            this.set(1, 1, year, 0, 0, 0, 0);
        }
        catch (IllegalTimeValue e) {
            System.err.println(e);
        }
        this.setTime(this.getTime() + (long)(yearday - 1) * 86400000L);
    }

    public Calendar getCalendar() {
        cal_.setTime(this);
        return cal_;
    }

    public int getYearday() {
        this.splitTimeFormat();
        return this.yearday_;
    }

    @Override
    public int getYear() {
        this.splitTimeFormat();
        return this.year_;
    }

    public int getGMTYear() {
        this.splitTimeFormat();
        return this.year_;
    }

    @Override
    public int getMonth() {
        this.splitTimeFormat();
        return this.month_;
    }

    public int getGMTMonth() {
        this.splitTimeFormat();
        return this.month_;
    }

    @Override
    public int getDay() {
        this.splitTimeFormat();
        return this.day_;
    }

    public int getGMTDay() {
        this.splitTimeFormat();
        return this.day_;
    }

    @Override
    public int getHours() {
        this.splitTimeFormat();
        return this.hour_;
    }

    public int getGMTHours() {
        this.splitTimeFormat();
        return this.hour_;
    }

    @Override
    public int getMinutes() {
        this.splitTimeFormat();
        return this.minute_;
    }

    public int getGMTMinutes() {
        this.splitTimeFormat();
        return this.minute_;
    }

    public double getSecondss() {
        this.splitTimeFormat();
        return this.second_;
    }

    public double getGMTSeconds() {
        this.splitTimeFormat();
        return this.second_;
    }

    public int getJDay() {
        this.splitTimeFormat();
        this.computeEPICTime();
        return this.JDay_;
    }

    public int getMSec() {
        this.splitTimeFormat();
        this.computeEPICTime();
        return this.MSec_;
    }

    private void computeEPICTime() {
        int jm;
        int jy;
        boolean leap;
        if (this.EPICTimeDone_) {
            return;
        }
        int GREGORIAN__ = 588829;
        int year = this.year_;
        int mon = this.month_;
        int day = this.day_;
        int hour = this.hour_;
        int min = this.minute_;
        int sec = this.second_;
        int msec = this.msec_;
        boolean bl = year % 4 != 0 ? false : (year % 400 == 0 ? true : (leap = year % 100 != 0));
        if (year < 0) {
            ++year;
        }
        if (mon > 2) {
            jy = year;
            jm = mon + 1;
        } else {
            jy = year - 1;
            jm = mon + 13;
        }
        int jul = (int)(Math.floor(365.25 * (double)jy) + Math.floor(30.6001 * (double)jm) + (double)day + 1720995.0);
        if ((long)day + 31L * ((long)mon + 12L * (long)year) >= (long)GREGORIAN__) {
            int ja = (int)(0.01 * (double)jy);
            jul += 2 - ja + (int)(0.25 * (double)ja);
        }
        this.JDay_ = jul;
        this.MSec_ = (int)(((long)hour * 3600L + (long)min * 60L) * 1000L + (long)sec * 1000L + (long)msec);
        this.EPICTimeDone_ = true;
    }

    @Override
    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        df.setCalendar(cal_);
        return df.format(this);
    }

    public String toString(String format) {
        if (format.equals("decade")) {
            this.splitTimeFormat();
            return Integer.toString(this.year_ / 10 * 10);
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setCalendar(cal_);
        return df.format(this);
    }

    public boolean isMissing() {
        return this.getTime() == Long.MIN_VALUE;
    }

    @Override
    public int compareTo(GeoDate anotherDate) {
        if (this.getTime() < anotherDate.getTime()) {
            return -1;
        }
        if (this.getTime() == anotherDate.getTime()) {
            return 0;
        }
        return 1;
    }
}

