/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sgtplot.JPane;
import sgtplot.Logo;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.util.Point2D;

public class LogoDialog
extends JDialog
implements PropertyChangeListener {
    private Logo logo_;
    private JPane pane_ = null;
    private boolean ignoreEvent_ = false;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();
    JPanel positionPanel = new JPanel();
    JLabel JLabel1 = new JLabel();
    JTextField xPosTextField = new JTextField();
    JLabel JLabel2 = new JLabel();
    JTextField yPosTextField = new JTextField();
    JPanel alignPanel = new JPanel();
    JLabel JLabel3 = new JLabel();
    JComboBox horizComboBox = new JComboBox();
    JLabel JLabel4 = new JLabel();
    JComboBox vertComboBox = new JComboBox();
    JPanel optionPanel = new JPanel();
    JLabel JLabel7 = new JLabel();
    JCheckBox labelVisibleCheckBox = new JCheckBox();
    JLabel JLabel6 = new JLabel();
    JCheckBox labelSelectableCheckBox = new JCheckBox();
    TitledBorder alignBorder = new TitledBorder("Alignment");
    TitledBorder positionBorder = new TitledBorder("Position");
    DefaultComboBoxModel horizCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel vertCBModel = new DefaultComboBoxModel();
    TitledBorder optionBorder = new TitledBorder("Options");

    public LogoDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(457, 294);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.positionPanel.setBorder(this.positionBorder);
        this.positionPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.positionPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel1.setText("X Position:");
        this.positionPanel.add((Component)this.JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.xPosTextField.setColumns(20);
        this.positionPanel.add((Component)this.xPosTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel2.setText("Y Position:");
        this.positionPanel.add((Component)this.JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.yPosTextField.setColumns(20);
        this.positionPanel.add((Component)this.yPosTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.alignPanel.setBorder(this.alignBorder);
        this.alignPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.alignPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel3.setText("Horizontal:");
        this.alignPanel.add((Component)this.JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.horizComboBox.setModel(this.horizCBModel);
        this.alignPanel.add((Component)this.horizComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel4.setText("Vertical:");
        this.alignPanel.add((Component)this.JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.vertComboBox.setModel(this.vertCBModel);
        this.alignPanel.add((Component)this.vertComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.optionPanel.setBorder(this.optionBorder);
        this.optionPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.optionPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(5, 10, 5, 0), 20, 15));
        this.JLabel7.setText("Visible:");
        this.optionPanel.add((Component)this.JLabel7, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelVisibleCheckBox.setSelected(true);
        this.optionPanel.add((Component)this.labelVisibleCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.JLabel6.setText("Selectable:");
        this.optionPanel.add((Component)this.JLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelSelectableCheckBox.setSelected(true);
        this.optionPanel.add((Component)this.labelSelectableCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        String[] tempString = new String[]{"LEFT", "CENTER", "RIGHT"};
        for (i = 0; i < tempString.length; ++i) {
            this.horizCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"TOP", "MIDDLE", "BOTTOM"};
        for (i = 0; i < tempString.length; ++i) {
            this.vertCBModel.addElement(tempString[i]);
        }
        this.vertComboBox.setSelectedIndex(2);
        this.horizComboBox.setSelectedIndex(0);
        this.setTitle("SGLabel");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public LogoDialog(String title) {
        this();
        this.setTitle(title);
    }

    public LogoDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void FontDialog_WindowClosing(WindowEvent event) {
        this.finish();
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.finish();
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.finish();
        this.updateLogo();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateLogo();
    }

    public static void main(String[] args) {
        LogoDialog la = new LogoDialog();
        la.setTitle("Test Logo Dialog");
        la.setVisible(true);
    }

    public void setLogo(Logo logo, JPane pane) {
        this.setJPane(pane);
        this.setLogo(logo);
    }

    public void setLogo(Logo logo) {
        this.logo_ = logo;
        this.logo_.addPropertyChangeListener(this);
        this.ignoreEvent_ = false;
        this.setLogo();
    }

    public Logo getLogo() {
        return this.logo_;
    }

    public void setJPane(JPane pane) {
        this.pane_ = pane;
    }

    public JPane getJPane() {
        return this.pane_;
    }

    private void setLogo() {
        this.setTitle("Logo - " + this.logo_.getId());
        this.labelVisibleCheckBox.setSelected(this.logo_.isVisible());
        this.labelSelectableCheckBox.setSelected(this.logo_.isSelectable());
        Point2D.Double locp = this.logo_.getLocationP();
        this.xPosTextField.setText(String.valueOf(locp.x));
        this.yPosTextField.setText(String.valueOf(locp.y));
        this.horizComboBox.setSelectedIndex(this.logo_.getHAlign());
        this.vertComboBox.setSelectedIndex(this.logo_.getVAlign());
    }

    private void updateLogo() {
        this.ignoreEvent_ = true;
        if (this.pane_ != null) {
            this.pane_.setBatch(true, "LogoDialog");
        }
        this.logo_.setVisible(this.labelVisibleCheckBox.isSelected());
        this.logo_.setSelectable(this.labelSelectableCheckBox.isSelected());
        double x = Double.valueOf(this.xPosTextField.getText());
        double y = Double.valueOf(this.yPosTextField.getText());
        Point2D.Double locp = new Point2D.Double(x, y);
        this.logo_.setLocationP(locp);
        this.logo_.setHAlign(this.horizComboBox.getSelectedIndex());
        this.logo_.setVAlign(this.vertComboBox.getSelectedIndex());
        if (this.pane_ != null) {
            this.pane_.setBatch(false, "LogoDialog");
        }
        this.ignoreEvent_ = false;
    }

    private void finish() {
        this.logo_.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.ignoreEvent_) {
            return;
        }
        if (event.getPropertyName().equals("location")) {
            Point2D.Double locp = this.logo_.getLocationP();
            this.xPosTextField.setText(String.valueOf(locp.x));
            this.yPosTextField.setText(String.valueOf(locp.y));
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == LogoDialog.this) {
                LogoDialog.this.FontDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == LogoDialog.this.cancelButton) {
                LogoDialog.this.cancelButton_actionPerformed(event);
            } else if (object == LogoDialog.this.okButton) {
                LogoDialog.this.okButton_actionPerformed(event);
            }
            if (object == LogoDialog.this.applyButton) {
                LogoDialog.this.applyButton_actionPerformed(event);
            }
        }
    }
}

