/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import sgtplot.ColorMap;
import sgtplot.ContourLevelNotFoundException;
import sgtplot.ContourLevels;
import sgtplot.ContourLineAttribute;
import sgtplot.DefaultContourLineAttribute;
import sgtplot.GridAttribute;
import sgtplot.GridCartesianRenderer;
import sgtplot.IndexedColor;
import sgtplot.IndexedColorMap;
import sgtplot.JPane;
import sgtplot.LinearTransform;
import sgtplot.dm.SGTGrid;
import sgtplot.swing.ColorSwatchIcon;
import sgtplot.swing.prop.ContourLineAttributeDialog;
import sgtplot.swing.prop.DefaultContourLineAttributeDialog;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.swing.prop.NewLevelsDialog;
import sgtplot.util.Range2D;

public class GridAttributeDialog
extends JDialog {
    private GridAttribute attr_;
    private ContourLevels conLevels_;
    private ColorMap colorMap_;
    private JPane[] paneList_ = null;
    private int contourLevelIndex_ = 0;
    private int colorMapIndex_ = 1;
    private JTable conLevelTable_;
    private ConLevelTableModel conLevelModel_;
    private SGTGrid grid_ = null;
    private JToggleButton[] colorButtons_ = new JToggleButton[256];
    boolean fComponentsAdjusted = false;
    JTabbedPane TabbedPane = new JTabbedPane();
    JPanel ContourLevelsPanel = new JPanel();
    JScrollPane gridScrollPane = new JScrollPane();
    JPanel controlPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JButton editButton = new JButton();
    JButton aboveButton = new JButton();
    JButton belowButton = new JButton();
    JButton deleteButton = new JButton();
    JPanel JPanel4 = new JPanel();
    JButton defaultButton = new JButton();
    JButton sortButton = new JButton();
    JButton newConLevelButton = new JButton();
    JPanel ColorMapPanel = new JPanel();
    JPanel colorControlPanel = new JPanel();
    JPanel colorMapPanel = new JPanel();
    JButton newColorMapButton = new JButton();
    JButton loadColorMapButton = new JButton();
    JButton saveColorMapButton = new JButton();
    JPanel colorPanel = new JPanel();
    JPanel CLIndexedPanel = new JPanel();
    JPanel CLTransformPanel = new JPanel();
    JPanel IndexedPanel = new JPanel();
    JPanel colorButtonsPanel = new JPanel();
    JPanel TransformPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel mainPanel = new JPanel();
    JLabel JLabel5 = new JLabel();
    JComboBox gridStyleComboBox = new JComboBox();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    DefaultComboBoxModel stringComboBoxModel1 = new DefaultComboBoxModel();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    TitledBorder titledBorder1 = new TitledBorder("Contour Level");
    EmptyBorder emptyBorder1 = new EmptyBorder(5, 0, 0, 0);
    TitledBorder titledBorder4 = new TitledBorder("Default Attributes");
    TitledBorder titledBorder2 = new TitledBorder("Color Map");

    public GridAttributeDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(516, 374);
        this.setVisible(false);
        this.mainPanel.setPreferredSize(new Dimension(516, 36));
        this.getContentPane().add((Component)this.TabbedPane, "Center");
        this.ContourLevelsPanel.setLayout(new BorderLayout(0, 0));
        this.TabbedPane.add((Component)this.ContourLevelsPanel, "ContourLevelsPanel");
        this.ContourLevelsPanel.setBounds(2, 27, 511, 271);
        this.ContourLevelsPanel.setVisible(false);
        this.ContourLevelsPanel.add((Component)this.gridScrollPane, "Center");
        this.controlPanel.setLayout(new GridBagLayout());
        this.ContourLevelsPanel.add((Component)this.controlPanel, "East");
        this.JPanel1.setBorder(this.titledBorder1);
        this.JPanel1.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.editButton.setToolTipText("Edit attribute of selected level.");
        this.editButton.setText("Edit Attribute");
        this.editButton.setActionCommand("Change Value");
        this.JPanel1.add((Component)this.editButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.aboveButton.setToolTipText("Insert level above selected level.");
        this.aboveButton.setText("Insert Level Above");
        this.aboveButton.setActionCommand("Before Item");
        this.JPanel1.add((Component)this.aboveButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
        this.belowButton.setToolTipText("Insert level below selected level.");
        this.belowButton.setText("Insert Level Below");
        this.belowButton.setActionCommand("After Item");
        this.JPanel1.add((Component)this.belowButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
        this.deleteButton.setToolTipText("Delete the selected level.");
        this.deleteButton.setText("Delete Level");
        this.deleteButton.setActionCommand("Delete Item");
        this.JPanel1.add((Component)this.deleteButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.JPanel4.setBorder(this.titledBorder4);
        this.JPanel4.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.defaultButton.setToolTipText("Edit default attributes.");
        this.defaultButton.setText("Edit Default Attributes");
        this.defaultButton.setActionCommand("Edit Default Attributes");
        this.JPanel4.add((Component)this.defaultButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.sortButton.setToolTipText("Sort levels by value.");
        this.sortButton.setText("Sort Levels");
        this.sortButton.setActionCommand("Sort");
        this.controlPanel.add((Component)this.sortButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newConLevelButton.setToolTipText("Create new contour level set.");
        this.newConLevelButton.setText("New...");
        this.newConLevelButton.setActionCommand("New...");
        this.controlPanel.add((Component)this.newConLevelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.ColorMapPanel.setLayout(new BorderLayout(0, 0));
        this.TabbedPane.add((Component)this.ColorMapPanel, "ColorMapPanel");
        this.ColorMapPanel.setBounds(2, 27, 511, 271);
        this.ColorMapPanel.setVisible(false);
        this.colorControlPanel.setLayout(new GridBagLayout());
        this.ColorMapPanel.add((Component)this.colorControlPanel, "East");
        this.colorMapPanel.setBorder(this.titledBorder2);
        this.colorMapPanel.setLayout(new GridBagLayout());
        this.colorControlPanel.add((Component)this.colorMapPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.newColorMapButton.setToolTipText("Create new color map.");
        this.newColorMapButton.setText("New...");
        this.newColorMapButton.setActionCommand("New...");
        this.colorMapPanel.add((Component)this.newColorMapButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.loadColorMapButton.setToolTipText("Load color map from disk.");
        this.loadColorMapButton.setText("Load...");
        this.loadColorMapButton.setActionCommand("Load...");
        this.colorMapPanel.add((Component)this.loadColorMapButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.saveColorMapButton.setToolTipText("Save color map to disk.");
        this.saveColorMapButton.setText("Save...");
        this.saveColorMapButton.setActionCommand("Save...");
        this.colorMapPanel.add((Component)this.saveColorMapButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.colorPanel.setLayout(new CardLayout(0, 0));
        this.ColorMapPanel.add((Component)this.colorPanel, "Center");
        this.CLIndexedPanel.setLayout(new FlowLayout(1, 5, 5));
        this.colorPanel.add("CLIndexed", this.CLIndexedPanel);
        this.CLTransformPanel.setLayout(new FlowLayout(1, 5, 5));
        this.colorPanel.add("CLTransform", this.CLTransformPanel);
        this.CLTransformPanel.setVisible(false);
        this.IndexedPanel.setLayout(new GridBagLayout());
        this.colorPanel.add("Indexed", this.IndexedPanel);
        this.IndexedPanel.setVisible(false);
        this.colorButtonsPanel.setLayout(new GridLayout(16, 16, 1, 1));
        this.IndexedPanel.add((Component)this.colorButtonsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.TransformPanel.setLayout(new FlowLayout(1, 5, 5));
        this.colorPanel.add("Transform", this.TransformPanel);
        this.TransformPanel.setVisible(false);
        this.TabbedPane.setSelectedComponent(this.ContourLevelsPanel);
        this.TabbedPane.setSelectedIndex(0);
        this.TabbedPane.setTitleAt(0, "Contour Levels");
        this.TabbedPane.setTitleAt(1, "Color Map");
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "North");
        this.JLabel5.setText("Grid Style:");
        this.mainPanel.add((Component)this.JLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.gridStyleComboBox.setModel(this.stringComboBoxModel1);
        this.mainPanel.add((Component)this.gridStyleComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        String[] tempString = new String[]{"RASTER", "AREA_FILL", "CONTOUR", "RASTER_CONTOUR", "AREA_FILL_CONTOUR"};
        for (int i = 0; i < tempString.length; ++i) {
            this.stringComboBoxModel1.addElement(tempString[i]);
        }
        this.gridStyleComboBox.setSelectedIndex(0);
        this.setTitle("GridAttribute Properties");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
        this.gridStyleComboBox.addActionListener(lSymAction);
        this.newConLevelButton.addActionListener(lSymAction);
        this.newColorMapButton.addActionListener(lSymAction);
        this.loadColorMapButton.addActionListener(lSymAction);
        this.editButton.addActionListener(lSymAction);
        this.aboveButton.addActionListener(lSymAction);
        this.belowButton.addActionListener(lSymAction);
        this.deleteButton.addActionListener(lSymAction);
        this.sortButton.addActionListener(lSymAction);
        this.saveColorMapButton.addActionListener(lSymAction);
        this.defaultButton.addActionListener(lSymAction);
        this.makeColorToggleButtons();
    }

    private void makeColorToggleButtons() {
        Insets insets = new Insets(0, 0, 0, 0);
        ButtonGroup bg = new ButtonGroup();
        ColorSwatchIcon csi = null;
        for (int i = 0; i < 256; ++i) {
            JToggleButton tb = new JToggleButton("");
            if (System.getProperty("mrj.version") == null || !UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName())) {
                tb.setMargin(insets);
            }
            csi = new ColorSwatchIcon(Color.white, 8, 8);
            tb.setIcon(csi);
            this.colorButtons_[i] = tb;
            this.colorButtonsPanel.add(tb);
            bg.add(tb);
        }
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public GridAttributeDialog(String title) {
        this();
        this.setTitle(title);
    }

    public GridAttributeDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void GridAttributeDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.updateGridAttribute();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateGridAttribute();
    }

    public void setJPane(JPane pane) {
        this.paneList_ = new JPane[1];
        this.paneList_[0] = pane;
    }

    public JPane getJPane() {
        if (this.paneList_ != null) {
            return this.paneList_[0];
        }
        return null;
    }

    public void setJPaneList(JPane[] list) {
        this.paneList_ = list;
    }

    public JPane[] getJPaneList() {
        return this.paneList_;
    }

    public void setGridCartesianRenderer(GridCartesianRenderer render) {
        this.grid_ = render.getGrid();
        this.setGridAttribute((GridAttribute)render.getAttribute());
    }

    public void setGridAttribute(GridAttribute attr) {
        this.attr_ = attr;
        this.colorMap_ = attr.getColorMap();
        this.conLevels_ = attr.getContourLevels();
        int style = this.attr_.getStyle();
        this.gridStyleComboBox.setSelectedIndex(style);
        this.enableContourLevels(style);
        this.initContourLevels();
        this.enableColorMap(style);
        this.initColorMap();
        this.setCurrentTab();
    }

    private void enableContourLevels(int style) {
        boolean isContour = style == 2 || style == 3 || style == 4;
        this.TabbedPane.setEnabledAt(this.contourLevelIndex_, isContour);
        Component[] list = this.ContourLevelsPanel.getComponents();
        boolean clExists = this.conLevels_ != null;
        for (int i = 0; i < list.length; ++i) {
            list[i].setEnabled(clExists);
        }
        this.newConLevelButton.setEnabled(true);
    }

    private void enableColorMap(int style) {
        boolean isRaster = style != 2;
        this.TabbedPane.setEnabledAt(this.colorMapIndex_, isRaster);
        Component[] list = this.ColorMapPanel.getComponents();
        boolean cmExists = this.colorMap_ != null;
        for (int i = 0; i < list.length; ++i) {
            list[i].setEnabled(cmExists);
        }
        this.newColorMapButton.setEnabled(true);
    }

    private void setCurrentTab() {
        if (!this.TabbedPane.isEnabledAt(this.TabbedPane.getSelectedIndex())) {
            if (this.TabbedPane.getSelectedIndex() == this.colorMapIndex_) {
                this.TabbedPane.setSelectedIndex(this.contourLevelIndex_);
            } else {
                this.TabbedPane.setSelectedIndex(this.colorMapIndex_);
            }
        }
    }

    private void initContourLevels() {
        this.createConLevelTable();
    }

    private void initColorMap() {
        if (this.colorMap_ instanceof IndexedColor) {
            ColorSwatchIcon csi;
            int i;
            int maxindx = ((IndexedColor)((Object)this.colorMap_)).getMaximumIndex();
            for (i = 0; i <= maxindx; ++i) {
                csi = new ColorSwatchIcon((IndexedColor)((Object)this.colorMap_), i, 8);
                this.colorButtons_[i].setIcon(csi);
                this.colorButtons_[i].setEnabled(true);
            }
            for (i = maxindx + 1; i < 256; ++i) {
                csi = new ColorSwatchIcon(Color.white, 8, 8);
                this.colorButtons_[i].setIcon(csi);
                this.colorButtons_[i].setEnabled(false);
            }
            ((CardLayout)this.colorPanel.getLayout()).show(this.colorPanel, "Indexed");
        }
    }

    void updateGridAttribute() {
        int i;
        if (this.paneList_ != null) {
            for (i = 0; i < this.paneList_.length; ++i) {
                this.paneList_[i].setBatch(true, "GridAttributeDialog");
            }
        }
        this.updateConLevels();
        this.attr_.setContourLevels(this.conLevels_);
        this.attr_.setColorMap(this.colorMap_);
        this.attr_.setStyle(this.gridStyleComboBox.getSelectedIndex());
        if (this.paneList_ != null) {
            for (i = 0; i < this.paneList_.length; ++i) {
                this.paneList_[i].setBatch(false, "GridAttributeDialog");
            }
        }
    }

    public static void main(String[] args) {
        Range2D range = new Range2D(-20.0, 45.0, 5.0);
        ContourLevels clevels = ContourLevels.getDefault(range);
        GridAttribute attr = new GridAttribute(clevels);
        GridAttributeDialog la = new GridAttributeDialog();
        la.setGridAttribute(attr);
        la.setTitle("Test GridAttribute Dialog");
        la.setVisible(true);
    }

    void gridStyleComboBox_actionPerformed(ActionEvent event) {
        int style = this.gridStyleComboBox.getSelectedIndex();
        this.enableContourLevels(style);
        this.enableColorMap(style);
        this.setCurrentTab();
    }

    void newConLevelButton_actionPerformed(ActionEvent event) {
        NewLevelsDialog nld = new NewLevelsDialog();
        int result = nld.showDialog(this.grid_);
        if (result == NewLevelsDialog.OK_RESPONSE) {
            Range2D range = nld.getRange();
            this.conLevels_ = ContourLevels.getDefault(range);
            this.initContourLevels();
        }
    }

    void newColorMapButton_actionPerformed(ActionEvent event) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.colorMap_ = new IndexedColorMap(red, green, blue);
        ((IndexedColorMap)this.colorMap_).setTransform(new LinearTransform(0.0, (double)red.length, 0.0, 1.0));
        this.initColorMap();
    }

    void loadColorMapButton_actionPerformed(ActionEvent event) {
        int[] r = new int[256];
        int[] g = new int[256];
        int[] b = new int[256];
        int lastindx = -1;
        File file = null;
        StreamTokenizer st = null;
        JFileChooser chooser = new JFileChooser("C:/local/pal");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            try {
                BufferedReader rdr = new BufferedReader(new FileReader(file));
                st = new StreamTokenizer(rdr);
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
                return;
            }
            try {
                st.nextToken();
                while (st.ttype != -1) {
                    ++lastindx;
                    if (st.ttype == -2) {
                        r[lastindx] = (int)st.nval;
                        st.nextToken();
                        g[lastindx] = (int)st.nval;
                        st.nextToken();
                        b[lastindx] = (int)st.nval;
                    }
                    if (st.nextToken() != 10) continue;
                    st.nextToken();
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
            int[] red = new int[lastindx + 1];
            int[] green = new int[lastindx + 1];
            int[] blue = new int[lastindx + 1];
            for (int i = 0; i <= lastindx; ++i) {
                red[i] = r[i];
                green[i] = g[i];
                blue[i] = b[i];
            }
            this.colorMap_ = new IndexedColorMap(red, green, blue);
            ((IndexedColorMap)this.colorMap_).setTransform(new LinearTransform(0.0, (double)red.length, 0.0, 1.0));
            this.initColorMap();
        }
    }

    void editButton_actionPerformed(ActionEvent event) {
        int index = this.conLevelTable_.getSelectedRow();
        if (index < 0) {
            return;
        }
        ContourLineAttributeDialog clad = new ContourLineAttributeDialog();
        ContourLineAttribute attr = (ContourLineAttribute)((ContourLineAttribute)this.conLevelModel_.getValueAt(index, 1)).copy();
        int result = clad.showDialog(attr);
        if (result == ContourLineAttributeDialog.OK_RESPONSE) {
            attr = clad.getContourLineAttribute();
            this.conLevelModel_.setValueAt(attr, index, 1);
        }
    }

    void aboveButton_actionPerformed(ActionEvent event) {
        int index = this.conLevelTable_.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.conLevelModel_.insert(index, new Double(0.0), new ContourLineAttribute(0));
    }

    void belowButton_actionPerformed(ActionEvent event) {
        int index = this.conLevelTable_.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.conLevelModel_.insert(index + 1, new Double(0.0), new ContourLineAttribute(0));
    }

    void deleteButton_actionPerformed(ActionEvent event) {
        int index = this.conLevelTable_.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.conLevelModel_.remove(index);
    }

    void sortButton_actionPerformed(ActionEvent event) {
        this.conLevelModel_.sort();
    }

    void defaultButton_actionPerformed(ActionEvent event) {
        DefaultContourLineAttributeDialog dclad = new DefaultContourLineAttributeDialog();
        DefaultContourLineAttribute attr = this.conLevels_.getDefaultContourLineAttribute();
        int result = dclad.showDialog((DefaultContourLineAttribute)attr.copy());
        if (result == DefaultContourLineAttributeDialog.OK_RESPONSE) {
            attr = dclad.getDefaultContourLineAttribute();
            this.conLevels_.setDefaultContourLineAttribute(attr);
        }
    }

    void saveColorMapButton_actionPerformed(ActionEvent event) {
    }

    void createConLevelTable() {
        this.conLevelModel_ = new ConLevelTableModel();
        this.conLevelTable_ = new JTable(this.conLevelModel_);
        this.conLevelTable_.setSize(1000, 1000);
        ListSelectionModel lsm = this.conLevelTable_.getSelectionModel();
        lsm.setSelectionMode(0);
        TableColumn tc = this.conLevelTable_.getColumnModel().getColumn(0);
        tc.setPreferredWidth(250);
        tc = this.conLevelTable_.getColumnModel().getColumn(1);
        tc.setPreferredWidth(750);
        this.gridScrollPane.getViewport().add(this.conLevelTable_);
        if (this.conLevels_ == null) {
            return;
        }
        int size = this.conLevels_.size();
        for (int i = 0; i < size; ++i) {
            try {
                Double val = new Double(this.conLevels_.getLevel(i));
                ContourLineAttribute attr = this.conLevels_.getContourLineAttribute(i);
                this.conLevelModel_.add(val, attr);
                continue;
            }
            catch (ContourLevelNotFoundException e) {
                System.out.println(e);
            }
        }
    }

    private void updateConLevels() {
        if (this.conLevels_ == null) {
            return;
        }
        ContourLevels cl = new ContourLevels();
        this.conLevelModel_.sort();
        int size = this.conLevelModel_.getRowCount();
        for (int i = 0; i < size; ++i) {
            Double val = (Double)this.conLevelModel_.getValueAt(i, 0);
            ContourLineAttribute attr = (ContourLineAttribute)this.conLevelModel_.getValueAt(i, 1);
            cl.addLevel(val, attr);
        }
        cl.setDefaultContourLineAttribute(this.conLevels_.getDefaultContourLineAttribute());
        this.conLevels_ = cl;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == GridAttributeDialog.this) {
                GridAttributeDialog.this.GridAttributeDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == GridAttributeDialog.this.cancelButton) {
                GridAttributeDialog.this.cancelButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.okButton) {
                GridAttributeDialog.this.okButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.applyButton) {
                GridAttributeDialog.this.applyButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.gridStyleComboBox) {
                GridAttributeDialog.this.gridStyleComboBox_actionPerformed(event);
            }
            if (object == GridAttributeDialog.this.newConLevelButton) {
                GridAttributeDialog.this.newConLevelButton_actionPerformed(event);
            }
            if (object == GridAttributeDialog.this.newColorMapButton) {
                GridAttributeDialog.this.newColorMapButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.loadColorMapButton) {
                GridAttributeDialog.this.loadColorMapButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.editButton) {
                GridAttributeDialog.this.editButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.aboveButton) {
                GridAttributeDialog.this.aboveButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.belowButton) {
                GridAttributeDialog.this.belowButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.deleteButton) {
                GridAttributeDialog.this.deleteButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.sortButton) {
                GridAttributeDialog.this.sortButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.saveColorMapButton) {
                GridAttributeDialog.this.saveColorMapButton_actionPerformed(event);
            } else if (object == GridAttributeDialog.this.defaultButton) {
                GridAttributeDialog.this.defaultButton_actionPerformed(event);
            }
        }
    }

    class ConLevelTableModel
    extends AbstractTableModel {
        Vector values = new Vector();
        Vector attr = new Vector();
        String[] titles = new String[]{"Value", "Attribute"};

        ConLevelTableModel() {
        }

        public void add(Double val, ContourLineAttribute cla) {
            this.values.addElement(val);
            this.attr.addElement(cla);
        }

        public void insert(int row, Double val, ContourLineAttribute cla) {
            this.values.insertElementAt(val, row);
            this.attr.insertElementAt(cla, row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        }

        public void remove(int row) {
            this.values.removeElementAt(row);
            this.attr.removeElementAt(row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }

        public void sort() {
            int i;
            int size = this.values.size();
            int[] index = new int[size];
            boolean flipped = true;
            for (i = 0; i < size; ++i) {
                index[i] = i;
            }
            while (flipped) {
                flipped = false;
                for (i = 0; i < size - 1; ++i) {
                    Double a = (Double)this.values.elementAt(index[i]);
                    Double b = (Double)this.values.elementAt(index[i + 1]);
                    if (!(a > b)) continue;
                    int temp = index[i];
                    index[i] = index[i + 1];
                    index[i + 1] = temp;
                    flipped = true;
                }
            }
            Vector oldValues = this.values;
            Vector oldAttr = this.attr;
            this.values = new Vector(size);
            this.attr = new Vector(size);
            for (i = 0; i < size; ++i) {
                this.values.addElement(oldValues.elementAt(index[i]));
                this.attr.addElement(oldAttr.elementAt(index[i]));
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.values.elementAt(row);
            }
            return this.attr.elementAt(row);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (col == 0) {
                if (obj instanceof Double) {
                    this.values.setElementAt(obj, row);
                } else if (obj instanceof String) {
                    this.values.setElementAt(new Double((String)obj), row);
                }
            } else {
                this.attr.setElementAt(obj, row);
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            return this.titles[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }
}

