/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.dm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import sgtplot.SGLabel;
import sgtplot.dm.Cartesian;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTGrid;
import sgtplot.dm.SGTMetaData;
import sgtplot.util.GeoDate;
import sgtplot.util.GeoDateArray;
import sgtplot.util.Range2D;
import sgtplot.util.SoTRange;

public class SimpleGrid
implements SGTGrid,
Cartesian,
Cloneable,
Serializable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected GeoDateArray tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected GeoDateArray tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected String title_;
    protected SGLabel keyTitle_ = null;
    protected String id_ = null;
    protected boolean xTime_;
    protected boolean yTime_;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTMetaData zMetaData_ = null;
    protected SGTGrid associatedData_;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private SoTRange xEdgesRange_ = null;
    private SoTRange yEdgesRange_ = null;
    private Range2D zRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public SimpleGrid() {
        this(null, (double[])null, (double[])null, "");
    }

    public SimpleGrid(double[] grid, double[] xloc, double[] yloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid(double[] grid, GeoDate[] tloc, double[] yloc, String title) {
        this.grid_ = grid;
        this.tloc_ = new GeoDateArray(tloc);
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid(double[] grid, double[] xloc, GeoDate[] tloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.tloc_ = new GeoDateArray(tloc);
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
        this.zRange_ = this.computeRange2D(grid);
    }

    @Override
    public SGTData copy() {
        SGTGrid newGrid;
        try {
            newGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid();
        }
        return newGrid;
    }

    @Override
    public double[] getXArray() {
        return this.xloc_;
    }

    @Override
    public int getXSize() {
        return this.xloc_.length;
    }

    @Override
    public double[] getYArray() {
        return this.yloc_;
    }

    @Override
    public int getYSize() {
        return this.yloc_.length;
    }

    @Override
    public double[] getZArray() {
        return this.grid_;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    @Override
    public int getTSize() {
        return this.tloc_.getLength();
    }

    @Override
    public boolean isXTime() {
        return this.xTime_;
    }

    @Override
    public boolean isYTime() {
        return this.yTime_;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    @Override
    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    public void setAssociatedData(SGTGrid assoc) {
        this.associatedData_ = assoc;
        this.changes_.firePropertyChange("associatedDataModified", null, assoc);
    }

    @Override
    public SGTGrid getAssociatedData() {
        return this.associatedData_;
    }

    @Override
    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    @Override
    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    @Override
    public double[] getXEdges() {
        return this.xEdges_;
    }

    public void setXEdges(double[] edge) {
        this.xEdges_ = edge;
        this.hasXEdges_ = true;
        this.xEdgesRange_ = this.computeSoTRange(edge);
    }

    @Override
    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    @Override
    public double[] getYEdges() {
        return this.yEdges_;
    }

    public void setYEdges(double[] edge) {
        this.yEdges_ = edge;
        this.hasYEdges_ = true;
        this.yEdgesRange_ = this.computeSoTRange(edge);
    }

    @Override
    public GeoDate[] getTimeEdges() {
        return this.tEdges_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArrayEdges() {
        return this.tEdges_;
    }

    public void setTimeEdges(GeoDate[] edge) {
        this.setTimeEdges(new GeoDateArray(edge));
    }

    public void setTimeEdges(GeoDateArray tarray) {
        this.tEdges_ = tarray;
        if (this.xTime_) {
            this.hasXEdges_ = true;
            this.xEdgesRange_ = this.computeSoTRange(tarray);
        } else if (this.yTime_) {
            this.hasYEdges_ = true;
            this.yEdgesRange_ = this.computeSoTRange(tarray);
        }
    }

    public void setXMetaData(SGTMetaData md) {
        this.xMetaData_ = md;
    }

    public void setYMetaData(SGTMetaData md) {
        this.yMetaData_ = md;
    }

    public void setZMetaData(SGTMetaData md) {
        this.zMetaData_ = md;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    @Override
    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel title) {
        this.keyTitle_ = title;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    public void setId(String ident) {
        this.id_ = ident;
    }

    public void setXArray(double[] xloc) {
        this.xloc_ = xloc;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(xloc.length));
    }

    public void setYArray(double[] yloc) {
        this.yloc_ = yloc;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(yloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(yloc.length));
    }

    public void setZArray(double[] grid) {
        this.grid_ = grid;
        this.zRange_ = this.computeRange2D(grid);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(grid.length));
    }

    public void setTimeArray(GeoDate[] tloc) {
        this.setTimeArray(new GeoDateArray(tloc));
    }

    public void setTimeArray(GeoDateArray tarray) {
        this.tloc_ = tarray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(tarray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(tarray);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(tarray.getLength()));
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    @Override
    public Range2D getZRange() {
        return this.zRange_;
    }

    @Override
    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    @Override
    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    private SoTRange computeSoTRange(double[] array) {
        Range2D range = this.computeRange2D(array);
        return new SoTRange.Double(range.start, range.end);
    }

    private SoTRange computeSoTRange(GeoDateArray tarray) {
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        long[] tar = tarray.getTime();
        int count = 0;
        for (int i = 0; i < tar.length; ++i) {
            if (tar[i] == Long.MAX_VALUE) continue;
            start = Math.min(start, tar[i]);
            end = Math.max(end, tar[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(start, end);
    }

    private Range2D computeRange2D(double[] array) {
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            start = Math.min(start, array[i]);
            end = Math.max(end, array[i]);
            ++count;
        }
        if (count == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(start, end);
    }
}

