/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.dm;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import sgtplot.LineAttribute;
import sgtplot.PointAttribute;
import sgtplot.SGException;
import sgtplot.SGLabel;
import sgtplot.dm.Annote;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTLine;
import sgtplot.dm.SGTMetaData;
import sgtplot.dm.SGTPoint;
import sgtplot.util.SoTPoint;
import sgtplot.util.SoTRange;

public class Annotation
implements SGTData,
PropertyChangeListener {
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private String title_ = null;
    private String id_ = null;
    private SGTMetaData xMeta_ = null;
    private SGTMetaData yMeta_ = null;
    private List text_ = new Vector();
    private List line_ = new Vector();
    private List point_ = new Vector();
    private List oval_ = new Vector();
    private List rect_ = new Vector();
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private boolean xTime_ = false;
    private boolean yTime_ = false;

    public Annotation() {
        this(null, false, false);
    }

    public Annotation(String title) {
        this(title, false, false);
    }

    public Annotation(String title, boolean xTime, boolean yTime) {
        this.title_ = title;
        this.xTime_ = xTime;
        this.yTime_ = yTime;
    }

    public boolean remove(String id) {
        Annote ann = this.findAnnote(id);
        if (ann == null) {
            return false;
        }
        return this.remove(ann);
    }

    public boolean remove(Annote ann) {
        if (ann instanceof Annote.Line) {
            return this.removeLine(ann);
        }
        if (ann instanceof Annote.Oval) {
            return this.removeOval(ann);
        }
        if (ann instanceof Annote.Point) {
            return this.removePoint(ann);
        }
        if (ann instanceof Annote.Rect) {
            return this.removeRect(ann);
        }
        if (ann instanceof Annote.Text) {
            return this.removeText(ann);
        }
        return false;
    }

    public void add(Annote ann) throws SGException {
        if (ann instanceof Annote.Line) {
            SGTLine line = ((Annote.Line)ann).getLine();
            if (this.xTime_ != line.isXTime() || this.yTime_ != line.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            ann.addPropertyChangeListener(this);
            this.line_.add(ann);
            this.changes_.firePropertyChange("lineAdded", true, false);
        } else if (ann instanceof Annote.Oval) {
            SoTPoint pt1 = ((Annote.Oval)ann).getUpperLeft();
            if (this.xTime_ != pt1.isXTime() || this.yTime_ != pt1.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            ann.addPropertyChangeListener(this);
            this.oval_.add(ann);
            this.changes_.firePropertyChange("ovalAdded", true, false);
        } else if (ann instanceof Annote.Point) {
            SGTPoint point = ((Annote.Point)ann).getPoint();
            if (this.xTime_ != point.isXTime() || this.yTime_ != point.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            ann.addPropertyChangeListener(this);
            this.point_.add(ann);
            this.changes_.firePropertyChange("pointAdded", true, false);
        } else if (ann instanceof Annote.Rect) {
            SoTPoint pt1 = ((Annote.Rect)ann).getUpperLeft();
            if (this.xTime_ != pt1.isXTime() || this.yTime_ != pt1.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            ann.addPropertyChangeListener(this);
            this.rect_.add(ann);
            this.changes_.firePropertyChange("rectAdded", true, false);
        } else if (ann instanceof Annote.Text) {
            SoTPoint loc = ((Annote.Text)ann).getLocation();
            if (this.xTime_ != loc.isXTime() || this.yTime_ != loc.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            ann.addPropertyChangeListener(this);
            this.text_.add(ann);
            this.changes_.firePropertyChange("textAdded", true, false);
        }
    }

    public Annote addLine(String id, SGTLine line, LineAttribute attr) throws SGException {
        if (this.xTime_ != line.isXTime() || this.yTime_ != line.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Line aLine = new Annote.Line(id, line, attr);
        aLine.addPropertyChangeListener(this);
        this.line_.add(aLine);
        this.changes_.firePropertyChange("lineAdded", true, false);
        return aLine;
    }

    private boolean removeLine(Annote line) {
        boolean result = false;
        if (line instanceof Annote.Line) {
            line.removePropertyChangeListener(this);
            result = this.line_.remove(line);
            if (result) {
                this.changes_.firePropertyChange("lineRemoved", true, false);
            }
        }
        return result;
    }

    public Iterator getLineIterator() {
        return this.line_.iterator();
    }

    public boolean hasLine() {
        return !this.line_.isEmpty();
    }

    public Annote addPoint(String id, SGTPoint point, PointAttribute attr) throws SGException {
        if (this.xTime_ != point.isXTime() || this.yTime_ != point.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Point aPoint = new Annote.Point(id, point, attr);
        aPoint.addPropertyChangeListener(this);
        this.point_.add(aPoint);
        this.changes_.firePropertyChange("pointAdded", true, false);
        return aPoint;
    }

    private boolean removePoint(Annote point) {
        boolean result = false;
        if (point instanceof Annote.Point) {
            point.removePropertyChangeListener(this);
            result = this.point_.remove(point);
            if (result) {
                this.changes_.firePropertyChange("pointRemoved", true, false);
            }
        }
        return result;
    }

    public Iterator getPointIterator() {
        return this.point_.iterator();
    }

    public boolean hasPoint() {
        return !this.point_.isEmpty();
    }

    public Annote addText(String id, SoTPoint loc, SGLabel text) throws SGException {
        if (this.xTime_ != loc.isXTime() || this.yTime_ != loc.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Text aText = new Annote.Text(id, loc, text);
        aText.addPropertyChangeListener(this);
        this.text_.add(aText);
        this.changes_.firePropertyChange("textAdded", true, false);
        return aText;
    }

    private boolean removeText(Annote text) {
        boolean result = false;
        if (text instanceof Annote.Text) {
            text.removePropertyChangeListener(this);
            result = this.text_.remove(text);
            if (result) {
                this.changes_.firePropertyChange("textRemoved", true, false);
            }
        }
        return result;
    }

    public Iterator getTextIterator() {
        return this.text_.iterator();
    }

    public boolean hasText() {
        return !this.text_.isEmpty();
    }

    public Annote addOval(String id, SoTPoint pt1, SoTPoint pt2, LineAttribute attr, Color color) throws SGException {
        if (this.xTime_ != pt1.isXTime() || this.yTime_ != pt1.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Oval aOval = new Annote.Oval(id, pt1, pt2, attr, color);
        aOval.addPropertyChangeListener(this);
        this.oval_.add(aOval);
        this.changes_.firePropertyChange("ovalAdded", true, false);
        return aOval;
    }

    private boolean removeOval(Annote oval) {
        boolean result = false;
        if (oval instanceof Annote.Oval) {
            oval.removePropertyChangeListener(this);
            result = this.oval_.remove(oval);
            if (result) {
                this.changes_.firePropertyChange("ovalRemoved", true, false);
            }
        }
        return result;
    }

    public Iterator getOvalIterator() {
        return this.oval_.iterator();
    }

    public boolean hasOval() {
        return !this.oval_.isEmpty();
    }

    public Annote addRect(String id, SoTPoint pt1, SoTPoint pt2, LineAttribute attr, Color color) throws SGException {
        if (this.xTime_ != pt1.isXTime() || this.yTime_ != pt1.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Rect aRect = new Annote.Rect(id, pt1, pt2, attr, color);
        aRect.addPropertyChangeListener(this);
        this.rect_.add(aRect);
        this.changes_.firePropertyChange("rectAdded", true, false);
        return aRect;
    }

    private boolean removeRect(Annote rect) {
        boolean result = false;
        if (rect instanceof Annote.Rect) {
            rect.removePropertyChangeListener(this);
            result = this.rect_.remove(rect);
            if (result) {
                this.changes_.firePropertyChange("rectRemoved", true, false);
            }
        }
        return result;
    }

    public Iterator getRectIterator() {
        return this.rect_.iterator();
    }

    public boolean hasRect() {
        return !this.rect_.isEmpty();
    }

    public Annote findAnnote(String id) {
        Annote tmp2 = null;
        if (!this.line_.isEmpty()) {
            for (Annote tmp2 : this.line_) {
                if (!tmp2.getAnnoteId().equals(id)) continue;
                return tmp2;
            }
        }
        if (!this.point_.isEmpty()) {
            for (Annote tmp2 : this.point_) {
                if (!tmp2.getAnnoteId().equals(id)) continue;
                return tmp2;
            }
        }
        if (!this.oval_.isEmpty()) {
            for (Annote tmp2 : this.oval_) {
                if (!tmp2.getAnnoteId().equals(id)) continue;
                return tmp2;
            }
        }
        if (!this.rect_.isEmpty()) {
            for (Annote tmp2 : this.rect_) {
                if (!tmp2.getAnnoteId().equals(id)) continue;
                return tmp2;
            }
        }
        if (!this.text_.isEmpty()) {
            for (Annote tmp2 : this.text_) {
                if (!tmp2.getAnnoteId().equals(id)) continue;
                return tmp2;
            }
        }
        return null;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public SGLabel getKeyTitle() {
        return null;
    }

    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public SGTData copy() {
        throw new UnsupportedOperationException("Method copy() not yet implemented.");
    }

    @Override
    public boolean isXTime() {
        return this.xTime_;
    }

    @Override
    public boolean isYTime() {
        return this.yTime_;
    }

    public void setXMetaData(SGTMetaData meta) {
        this.xMeta_ = meta;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMeta_;
    }

    public void setYMetaData(SGTMetaData meta) {
        this.yMeta_ = meta;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMeta_;
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_;
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.changes_.firePropertyChange(evt);
    }
}

