/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.contour;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.CartesianGraph;
import sgtplot.ContourLevelNotFoundException;
import sgtplot.ContourLevels;
import sgtplot.DefaultContourLineAttribute;
import sgtplot.SGLabel;
import sgtplot.contour.ContourLine;
import sgtplot.contour.GridFlag;
import sgtplot.contour.Sides;
import sgtplot.dm.SGTGrid;
import sgtplot.util.GeoDate;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;

public class Contour
implements PropertyChangeListener {
    private SGTGrid grid_;
    private SGTGrid mask_;
    private CartesianGraph cg_;
    private ContourLevels contourLevels_;
    private double zmin_;
    private double zmax_;
    private boolean upToDate_;
    private GeoDate tref_ = null;
    private boolean xTime_ = false;
    private boolean yTime_ = false;
    private double[] px_;
    private double[] py_;
    private double[] z_;
    private double[] xx_;
    private double[] yy_;
    private double[] zz_;
    private boolean[] used_;
    private int[] kabov_;
    private int[] isin_ = new int[]{0, 1, 0, -1};
    private double weezee_;
    private int nx_;
    private int ny_;
    private Vector contourLines_;
    private Sides sides_;
    private GridFlag gridFlag_;
    private static double DSLAB = 2.0;
    private static double SLAB1F = 0.4;

    public Contour(CartesianGraph cg, SGTGrid grid, Range2D range) {
        this.cg_ = cg;
        this.grid_ = grid;
        this.contourLevels_ = ContourLevels.getDefault(range);
        this.init();
        this.upToDate_ = false;
    }

    public Contour(CartesianGraph cg, SGTGrid grid, double[] levels) {
        this.cg_ = cg;
        this.grid_ = grid;
        this.contourLevels_ = ContourLevels.getDefault(levels);
        this.init();
        this.upToDate_ = false;
    }

    public Contour(CartesianGraph cg, SGTGrid grid, ContourLevels conLevels) {
        this.cg_ = cg;
        this.grid_ = grid;
        this.contourLevels_ = conLevels;
        this.contourLevels_.addPropertyChangeListener(this);
        this.init();
        this.upToDate_ = false;
    }

    public ContourLevels getContourLevels() {
        return this.contourLevels_;
    }

    public void setMask(SGTGrid mask) {
        if (this.mask_ == null || !this.mask_.equals(mask)) {
            this.upToDate_ = false;
        }
        this.mask_ = mask;
    }

    public SGTGrid getMask() {
        return this.mask_;
    }

    public Enumeration elements() {
        if (!this.upToDate_) {
            this.generateContourLines();
        }
        return this.contourLines_.elements();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    private void init() {
        GeoDate[] ttemp;
        if (this.grid_.isXTime()) {
            this.xTime_ = true;
            ttemp = this.grid_.getTimeArray();
            this.tref_ = ttemp[0];
            this.px_ = this.getTimeOffsetArray(ttemp, this.tref_);
            this.nx_ = this.grid_.getTSize();
        } else {
            this.px_ = this.grid_.getXArray();
            this.nx_ = this.grid_.getXSize();
        }
        if (this.grid_.isYTime()) {
            this.yTime_ = true;
            ttemp = this.grid_.getTimeArray();
            this.tref_ = ttemp[0];
            this.py_ = this.getTimeOffsetArray(ttemp, this.tref_);
            this.ny_ = this.grid_.getTSize();
        } else {
            this.py_ = this.grid_.getYArray();
            this.ny_ = this.grid_.getYSize();
        }
        this.sides_ = new Sides(this.nx_, this.ny_);
        this.xx_ = new double[4];
        this.yy_ = new double[4];
        this.zz_ = new double[4];
        this.used_ = new boolean[4];
        this.kabov_ = new int[4];
        this.z_ = this.grid_.getZArray();
    }

    private double[] getTimeOffsetArray(GeoDate[] tarray, GeoDate tref) {
        double[] array = new double[tarray.length];
        for (int i = 0; i < tarray.length; ++i) {
            array[i] = tarray[i].offset(tref);
        }
        return array;
    }

    private GeoDate[] getTimeArray(double[] array, GeoDate tref) {
        GeoDate[] tarray = new GeoDate[array.length];
        for (int i = 0; i < array.length; ++i) {
            tarray[i] = new GeoDate(tref);
            tarray[i].increment(array[i], 1);
        }
        return tarray;
    }

    public void generateContourLines() {
        int i = 0;
        int j = 0;
        if (this.upToDate_) {
            return;
        }
        this.contourLines_ = new Vector();
        this.upToDate_ = true;
        this.computeMinMax();
        double zrange = (this.zmax_ - this.zmin_) * 1.1;
        if (zrange <= 0.0) {
            return;
        }
        this.weezee_ = zrange * 2.0E-4;
        Enumeration lenum = this.contourLevels_.levelElements();
        while (lenum.hasMoreElements()) {
            double zc = (Double)lenum.nextElement();
            if (zc <= this.zmin_ || zc >= this.zmax_) continue;
            this.sides_.clear();
            this.gridFlag_ = this.mask_ != null ? new GridFlag(this.grid_, this.mask_, zc) : new GridFlag(this.grid_, zc);
            for (int ii = 0; ii < this.nx_; ++ii) {
                block4: for (int jj = 0; jj < this.ny_; ++jj) {
                    i = ii;
                    j = jj;
                    int kabij = this.gridFlag_.getValue(i, j);
                    int kabip1 = i < this.nx_ - 1 ? this.gridFlag_.getValue(i + 1, j) : 10;
                    int kabjp1 = j < this.ny_ - 1 ? this.gridFlag_.getValue(i, j + 1) : 10;
                    int used0 = this.sides_.getSide(i, j, 0);
                    int used3 = this.sides_.getSide(i, j, 3);
                    int ll = 0;
                    if (kabij + kabip1 + used0 == 0) {
                        this.computeCorners(i, j, zc);
                    } else {
                        if (kabij + kabjp1 + used3 != 0) continue;
                        ll = 3;
                        this.computeCorners(i, j, zc);
                    }
                    int lin = ll;
                    int k = 0;
                    int nseg = 1;
                    boolean reversed = false;
                    ContourLine cl = new ContourLine();
                    try {
                        cl.setAttributes(this.contourLevels_.getDefaultContourLineAttribute(), this.contourLevels_.getContourLineAttribute(zc));
                    }
                    catch (ContourLevelNotFoundException e) {
                        System.out.println(e);
                    }
                    cl.setLevel(zc);
                    cl.setCartesianGraph(this.cg_);
                    cl.setTime(this.tref_, this.xTime_, this.yTime_);
                    this.contourLines_.addElement(cl);
                    cl.addPoint(0.0, 0.0);
                    while (true) {
                        int kmax;
                        int exit;
                        block19: {
                            double yt;
                            double xt;
                            double frac;
                            int lm1;
                            int lp2;
                            int lp1;
                            block18: {
                                lp1 = lin + 1 - (lin + 1) / 4 * 4;
                                lp2 = lp1 + 1 - (lp1 + 1) / 4 * 4;
                                lm1 = lp2 + 1 - (lp2 + 1) / 4 * 4;
                                if (!reversed) {
                                    ++k;
                                    frac = (zc - this.zz_[lin]) / (this.zz_[lp1] - this.zz_[lin]);
                                    xt = this.xx_[lin] + (this.xx_[lp1] - this.xx_[lin]) * frac;
                                    yt = this.yy_[lin] + (this.yy_[lp1] - this.yy_[lin]) * frac;
                                    cl.addPoint(xt, yt);
                                    this.sides_.setSideUsed(i, j, lin, true);
                                }
                                reversed = false;
                                exit = lm1;
                                if (this.kabov_[lin] + this.kabov_[lm1] != 0) break block18;
                                if (this.kabov_[lp1] + this.kabov_[lp2] != 0) break block19;
                                double flm1 = (zc - this.zz_[lin]) / (this.zz_[lm1] - zc);
                                double flp1 = (zc - this.zz_[lp1]) / (this.zz_[lp2] - zc);
                                if (this.used_[lp1] || flm1 <= flp1 && !this.used_[lm1]) break block19;
                                exit = lp1;
                                break block19;
                            }
                            if (this.kabov_[lp1] + this.kabov_[lp2] == 0) {
                                exit = lp1;
                            } else {
                                exit = lp2;
                                if (this.kabov_[lp2] + this.kabov_[lm1] != 0) {
                                    if (this.kabov_[lp2] + this.kabov_[lm1] <= 15) {
                                        int kda = lin;
                                        int kdb = lp2;
                                        if (this.kabov_[lp2] > 5) {
                                            kda = lm1;
                                            kdb = lp1;
                                        }
                                        ++k;
                                        frac = (zc - this.zz_[kda]) / (this.zz_[kdb] - this.zz_[kda]);
                                        xt = this.xx_[kda] + (this.xx_[kdb] - this.xx_[kda]) * frac;
                                        yt = this.yy_[kda] + (this.yy_[kdb] - this.yy_[kda]) * frac;
                                        cl.addPoint(xt, yt);
                                    }
                                    if (nseg > 1) {
                                        kmax = k;
                                        cl.setElementAt((Point2D.Double)cl.elementAt(1), 0);
                                        cl.addPoint((Point2D.Double)cl.elementAt(k));
                                        cl.setClosed(false);
                                        cl.setKmax(kmax);
                                        continue block4;
                                    }
                                    reversed = true;
                                    nseg = 2;
                                    cl.reverseElements(k);
                                    i = ii;
                                    j = jj;
                                    exit = ll;
                                    lin = exit + 2 - (exit + 2) / 4 * 4;
                                    this.computeCorners(i += this.isin_[exit], j += this.isin_[3 - exit], zc);
                                    continue;
                                }
                            }
                        }
                        if (this.used_[exit]) {
                            kmax = k + 1;
                            cl.addPoint((Point2D.Double)cl.elementAt(1));
                            cl.setElementAt((Point2D.Double)cl.elementAt(k), 0);
                            cl.addPoint((Point2D.Double)cl.elementAt(2));
                            cl.setClosed(true);
                            cl.setKmax(kmax);
                            continue block4;
                        }
                        lin = exit + 2 - (exit + 2) / 4 * 4;
                        this.computeCorners(i += this.isin_[exit], j += this.isin_[3 - exit], zc);
                    }
                }
            }
        }
    }

    private void computeCorners(int i, int j, double zc) {
        boolean[] used = new boolean[]{false, false, false, false};
        for (int lcorner = 0; lcorner < 4; ++lcorner) {
            int jl = j + lcorner / 2;
            int lp1 = lcorner + 1 - (lcorner + 1) / 4 * 4;
            int il = i + lp1 / 2;
            this.zz_[lcorner] = Double.NaN;
            this.kabov_[lcorner] = 10;
            if ((il + 1) * (this.nx_ - il) > 0 && (jl + 1) * (this.ny_ - jl) > 0 && !this.gridFlag_.isMissing(il, jl)) {
                used[lcorner] = this.sides_.isSideUsed(i, j, lcorner);
                this.zz_[lcorner] = this.setZ(this.z(il, jl), zc);
                this.kabov_[lcorner] = this.zz_[lcorner] < zc ? -1 : 1;
            }
            this.xx_[lcorner] = this.px_[Math.max(0, Math.min(il, this.nx_ - 1))];
            this.yy_[lcorner] = this.py_[Math.max(0, Math.min(jl, this.ny_ - 1))];
        }
        this.used_[0] = used[0];
        this.used_[1] = used[1];
        this.used_[2] = used[2];
        this.used_[3] = used[3];
    }

    private double z(int i, int j) {
        return this.z_[j + i * this.ny_];
    }

    private double setZ(double z, double zc) {
        double diff = z - zc;
        if (Math.abs(diff) < this.weezee_) {
            return zc + this.weezee_ * (diff > 0.0 ? 1.0 : -1.0);
        }
        return z;
    }

    private void computeMinMax() {
        boolean haveMask;
        double[] grid = this.grid_.getZArray();
        double[] mask = null;
        boolean bl = haveMask = this.mask_ != null;
        if (haveMask) {
            mask = this.mask_.getZArray();
        }
        this.zmin_ = Double.POSITIVE_INFINITY;
        this.zmax_ = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < grid.length; ++i) {
            if (Double.isNaN(grid[i]) || haveMask && mask[i] == 0.0) continue;
            this.zmin_ = Math.min(this.zmin_, grid[i]);
            this.zmax_ = Math.max(this.zmax_, grid[i]);
        }
    }

    public void generateContourLabels(VectorGraphics g) {
        GeoDate tref = null;
        double space = 0.0;
        double ark = 1.0;
        Enumeration elem = this.contourLines_.elements();
        while (elem.hasMoreElements()) {
            double dyy;
            double dxx;
            int k;
            ContourLine cl = (ContourLine)elem.nextElement();
            int kmax = cl.getKmax();
            int lev = this.contourLevels_.getIndex(cl.getLevel());
            DefaultContourLineAttribute cattr = cl.getDefaultContourLineAttribute();
            cattr.setContourLineAttribute(cl.getContourLineAttribute());
            if (kmax <= 1 || !cattr.isLabelEnabled()) continue;
            SGLabel label = new SGLabel("CLevel", cattr.getLabelText(), cattr.getLabelHeightP(), new Point2D.Double(0.0, 0.0), 2, 0);
            if (cattr.getLabelFont() != null) {
                label.setFont(cattr.getLabelFont());
            }
            label.setColor(cattr.getLabelColor());
            label.setLayer(this.cg_.getLayer());
            int swidth = (int)label.getStringWidth(g);
            int sheight = (int)label.getStringHeight(g);
            double width = this.cg_.getLayer().getXDtoP(swidth) - this.cg_.getLayer().getXDtoP(0);
            double hgt = this.cg_.getLayer().getYDtoP(0) - this.cg_.getLayer().getYDtoP(sheight);
            double hhgt = hgt * 0.5;
            width += hhgt;
            double[] px = this.xArrayP();
            double[] py = this.yArrayP();
            double[] z = this.grid_.getZArray();
            boolean xIncreasing = px[0] < px[1];
            boolean yIncreasing = py[0] < py[1];
            int nx = px.length;
            int ny = py.length;
            double[] x = new double[kmax + 1];
            double[] y = new double[kmax + 1];
            double[] s = new double[kmax + 1];
            if (cl.isXTime() || cl.isYTime()) {
                tref = cl.getReferenceTime();
            }
            s[1] = 0.0;
            x = cl.getXArrayP();
            y = cl.getYArrayP();
            for (k = 2; k <= kmax; ++k) {
                dxx = x[k] - x[k - 1];
                dyy = y[k] - y[k - 1];
                s[k] = s[k - 1] + Math.sqrt(dxx * dxx + dyy * dyy);
            }
            double smax = s[kmax];
            double slab1 = smax * SLAB1F;
            double stest = Math.max(0.0, DSLAB - slab1);
            k = 1;
            while (k < kmax) {
                int kk;
                int km1 = Math.max(k - 1, 1);
                if ((stest = stest + s[k] - s[km1]) < DSLAB || smax - s[k] <= 2.0 * width) {
                    ++k;
                    continue;
                }
                int kp1 = k + 1;
                if (lev != 0) {
                    try {
                        double cspace;
                        int j;
                        int i;
                        double dlev = Math.abs(this.contourLevels_.getLevel(lev) - this.contourLevels_.getLevel(lev - 1));
                        if (xIncreasing) {
                            for (i = 0; !(i >= nx - 1 || x[k] >= px[i] && x[k] <= px[i + 1]); ++i) {
                            }
                        } else {
                            for (i = 0; !(i >= nx - 1 || x[k] <= px[i] && x[k] >= px[i + 1]); ++i) {
                            }
                        }
                        if (yIncreasing) {
                            for (j = 0; !(j >= ny - 1 || y[k] >= py[j] && y[k] <= py[j + 1]); ++j) {
                            }
                        } else {
                            for (j = 0; !(j >= ny - 1 || y[k] <= py[j] && y[k] >= py[j + 1]); ++j) {
                            }
                        }
                        i = Math.min(i, nx - 2);
                        j = Math.min(j, ny - 2);
                        double dx = px[i + 1] - px[i];
                        double dy = py[j + 1] - py[j];
                        double dzdx = Double.isNaN(z[j + (i + 1) * ny]) ? 0.0 : (z[j + (i + 1) * ny] - z[j + i * ny]) / dx;
                        double dzdy = Double.isNaN(z[j + 1 + i * ny]) ? 0.0 : (z[j + 1 + i * ny] - z[j + i * ny]) / dy;
                        double dzdg = Math.abs(dzdx) + Math.abs(dzdy);
                        if (dzdg != 0.0 && (cspace = dlev / dzdg) < hgt * 1.0) {
                            ++k;
                            continue;
                        }
                    }
                    catch (ContourLevelNotFoundException e) {
                        System.out.println(e);
                    }
                }
                boolean roomFound = false;
                for (kk = kp1; kk <= kmax; ++kk) {
                    dxx = x[kk] - x[k];
                    dyy = y[kk] - y[k];
                    space = Math.sqrt(dxx * dxx + dyy * dyy);
                    ark = s[kk] - s[k];
                    if (!(space >= width)) continue;
                    roomFound = true;
                    break;
                }
                if (space / ark < 0.8 || !roomFound) {
                    ++k;
                    continue;
                }
                cl.addLabel(k, (SGLabel)label.copy(), hgt, width);
                stest = 0.0;
                k = kk;
            }
        }
    }

    private void drawRotatedRectangle(Graphics g, double angle, double x0, double y0, double width, double height) {
        double sinthta = Math.sin(angle * Math.PI / 180.0);
        double costhta = Math.cos(angle * Math.PI / 180.0);
        double[] x = new double[4];
        double[] y = new double[4];
        int[] xd = new int[5];
        int[] yd = new int[5];
        double xorig = x0;
        double yorig = y0;
        x[0] = x0;
        y[0] = y0;
        x[1] = x[0] + width;
        y[1] = y[0];
        x[2] = x[1];
        y[2] = y[0] + height;
        x[3] = x[0];
        y[3] = y[2];
        for (int i = 0; i < 4; ++i) {
            double xp = (x[i] - xorig) * costhta - (y[i] - yorig) * sinthta + xorig;
            double yp = (y[i] - yorig) * costhta + (x[i] - xorig) * sinthta + yorig;
            xd[i] = this.cg_.getLayer().getXPtoD(xp);
            yd[i] = this.cg_.getLayer().getYPtoD(yp);
        }
        xd[4] = xd[0];
        yd[4] = yd[0];
        g.setColor(Color.blue);
        g.drawPolyline(xd, yd, 5);
        g.setColor(Color.black);
    }

    private double[] xArrayP() {
        double[] p;
        if (this.grid_.isXTime()) {
            GeoDate[] t = this.grid_.getTimeArray();
            p = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                p[i] = this.cg_.getXUtoP(t[i]);
            }
        } else {
            double[] x = this.grid_.getXArray();
            p = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                p[i] = this.cg_.getXUtoP(x[i]);
            }
        }
        return p;
    }

    private double[] yArrayP() {
        double[] p;
        if (this.grid_.isYTime()) {
            GeoDate[] t = this.grid_.getTimeArray();
            p = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                p[i] = this.cg_.getYUtoP(t[i]);
            }
        } else {
            double[] y = this.grid_.getYArray();
            p = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                p[i] = this.cg_.getYUtoP(y[i]);
            }
        }
        return p;
    }
}

