/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.Attribute;
import sgtplot.ChildNotFoundException;
import sgtplot.ColorKey;
import sgtplot.DataKey;
import sgtplot.JPane;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.LayerControl;
import sgtplot.LineKey;
import sgtplot.PaneNotFoundException;
import sgtplot.PointCollectionKey;
import sgtplot.Ruler;
import sgtplot.SGLabel;
import sgtplot.StackedLayout;
import sgtplot.VectorKey;
import sgtplot.beans.DataGroup;
import sgtplot.beans.DataGroupLayer;
import sgtplot.beans.DataTargetMismatchException;
import sgtplot.beans.Label;
import sgtplot.beans.Legend;
import sgtplot.beans.PanelHolder;
import sgtplot.dm.SGTData;
import sgtplot.util.Dimension2D;
import sgtplot.util.Point2D;
import sgtplot.util.Rectangle2D;

public class Panel
extends JComponent
implements LayerControl {
    private JPane pane_ = null;
    private PanelHolder pHolder_ = null;
    private Layer labelLayer_ = null;
    private Layer legendLayer_ = null;
    private Map dataGroupLayerList_ = new HashMap(2);

    public Panel(String name) {
        this.setName(name);
        this.setLayout(new StackedLayout());
    }

    public Panel(PanelHolder ph) {
        this(ph.getId());
        this.pHolder_ = ph;
        this.update();
    }

    public void setPanelHolder(PanelHolder ph) {
        this.pHolder_ = ph;
        this.setName(this.pHolder_.getId());
        this.update();
    }

    public void update() {
        float dpi = this.pHolder_.getPanelModel().getDpi();
        this.setBounds(this.pHolder_.getBounds());
        double width = (float)this.getBounds().width / dpi;
        double height = (float)this.getBounds().height / dpi;
        Dimension2D psize = new Dimension2D(width, height);
        if (this.pane_ != null) {
            boolean batch = this.pane_.isBatch();
            this.pane_.setBatch(true);
            if (this.labelLayer_ == null) {
                this.labelLayer_ = new Layer("Label Layer", psize);
                this.add(this.labelLayer_);
                this.labelLayer_.setPane(this.pane_);
            } else {
                this.labelLayer_.setSizeP(psize);
            }
            if (this.legendLayer_ == null) {
                this.legendLayer_ = new Layer("Legend Layer", psize);
                this.add(this.legendLayer_);
                this.legendLayer_.setPane(this.pane_);
            } else {
                this.legendLayer_.setSizeP(psize);
            }
            this.setBorder(this.pHolder_.getBorder());
            this.invalidate();
            try {
                this.updateLabels();
                this.updateLegends();
                this.updateDataGroups();
            }
            catch (ChildNotFoundException e) {
                e.printStackTrace();
            }
            this.pane_.setBatch(batch);
        }
    }

    private void updateLabels() throws ChildNotFoundException {
        Iterator lbIter = this.pHolder_.labelIterator();
        LayerChild[] children = this.labelLayer_.getChildren();
        for (int i = 0; i < children.length; ++i) {
            LayerChild child = children[i];
            if (this.pHolder_.hasLabel(child.getId())) continue;
            this.labelLayer_.removeChild(child);
        }
        while (lbIter.hasNext()) {
            double hgt;
            SGLabel sgl = null;
            Label label = (Label)lbIter.next();
            LayerChild child = this.labelLayer_.findChild(label.getId());
            Point2D.Double loc = label.getLocationP();
            Rectangle2D.Double bnds = label.getBoundsP();
            if (label.getOrientation() == 0) {
                hgt = label.getHeightP();
                switch (label.getJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        loc.x += bnds.getWidth() * 0.5;
                        break;
                    }
                    case 2: {
                        loc.x += bnds.getWidth();
                    }
                }
            } else {
                hgt = label.getWidthP();
                loc.x += bnds.getWidth();
                switch (label.getJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        loc.y += bnds.getHeight() * 0.5;
                        break;
                    }
                    case 2: {
                        loc.y += bnds.getHeight();
                    }
                }
            }
            if (child == null) {
                sgl = new SGLabel(label.getId(), label.getText(), hgt, loc, 2, label.getJustification());
                sgl.setVisible(label.isVisible());
                sgl.setSelectable(label.isSelectable());
                sgl.setOrientation(label.getOrientation());
                sgl.setColor(label.getColor());
                sgl.setFont(label.getFont());
                this.labelLayer_.addChild(sgl);
                label.setInstantiated(true);
                continue;
            }
            sgl = (SGLabel)child;
            sgl.setText(label.getText());
            sgl.setHeightP(hgt);
            sgl.setLocationP(loc);
            sgl.setHAlign(label.getJustification());
            sgl.setVisible(label.isVisible());
            sgl.setSelectable(label.isSelectable());
            sgl.setOrientation(label.getOrientation());
            sgl.setColor(label.getColor());
            sgl.setFont(label.getFont());
        }
    }

    private void updateLegends() {
        Iterator lgIter = this.pHolder_.legendIterator();
        while (lgIter.hasNext()) {
            DataKey key = null;
            Legend legend = (Legend)lgIter.next();
            LayerChild child = this.legendLayer_.findChild(legend.getId());
            Rectangle2D.Double boundsP = legend.getBoundsP();
            if (child == null) {
                switch (legend.getType()) {
                    case 0: {
                        key = new LineKey(legend.getLocationP(), 0, 0);
                        break;
                    }
                    case 1: {
                        key = new ColorKey(legend.getLocationP(), new Dimension2D(boundsP.width, boundsP.height), 0, 0);
                        break;
                    }
                    case 2: {
                        key = new VectorKey(legend.getLocationP(), 0, 0);
                        break;
                    }
                    case 3: {
                        key = new PointCollectionKey(legend.getLocationP(), 0, 0);
                    }
                }
                key.setId(legend.getId());
                this.legendLayer_.addChild(key);
                legend.setInstantiated(true);
            } else {
                key = (DataKey)child;
                key.setLocationP(legend.getLocationP());
            }
            if (legend.isColor()) {
                ColorKey ckey = (ColorKey)key;
                ckey.setSizeP(new Dimension2D(boundsP.width, boundsP.height));
                Ruler scale = ckey.getRuler();
                scale.setLabelColor(legend.getScaleColor());
                scale.setLineColor(legend.getScaleColor());
                scale.setLabelFont(legend.getScaleLabelFont());
                scale.setLabelHeightP(legend.getScaleLabelHeightP());
                scale.setLabelInterval(legend.getScaleLabelInterval());
                scale.setNumberSmallTics(legend.getScaleNumberSmallTics());
                scale.setLargeTicHeightP(legend.getScaleLargeTicHeightP());
                scale.setSmallTicHeightP(legend.getScaleSmallTicHeightP());
                scale.setSignificantDigits(legend.getScaleSignificantDigits());
                scale.setLabelFormat(legend.getScaleLabelFormat());
                scale.setVisible(legend.isScaleVisible());
                if (boundsP.width >= boundsP.height) {
                    ckey.setOrientation(1);
                } else {
                    ckey.setOrientation(2);
                }
            }
            key.setBorderStyle(legend.getBorderStyle());
            key.setColumns(legend.getColumns());
            key.setLineLengthP(legend.getLineLength());
            key.setVisible(legend.isVisible());
        }
    }

    private void updateDataGroups() {
        float dpi = this.pHolder_.getPanelModel().getDpi();
        this.setBounds(this.pHolder_.getBounds());
        double width = (float)this.getBounds().width / dpi;
        double height = (float)this.getBounds().height / dpi;
        Dimension2D psize = new Dimension2D(width, height);
        Iterator dgIter = this.pHolder_.dataGroupIterator();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Layer ly;
            if (!(comps[i] instanceof Layer) || (ly = (Layer)comps[i]) == this.labelLayer_ || ly == this.legendLayer_ || this.pHolder_.hasDataGroup(ly.getId())) continue;
            this.remove(ly);
        }
        while (dgIter.hasNext()) {
            DataGroup ag = (DataGroup)dgIter.next();
            DataGroupLayer dgl = this.findDataGroupLayer(ag.getId());
            if (dgl == null) {
                dgl = new DataGroupLayer(this, ag);
                this.add(dgl);
                dgl.setSizeP(psize);
                ag.setInstantiated(true);
                this.dataGroupLayerList_.put(dgl.getId(), dgl);
                continue;
            }
            dgl.update();
        }
    }

    public Object getObjectAt(int x, int y, boolean check) {
        Object obj = null;
        obj = this.labelLayer_.getObjectAt(x, y, check);
        if (obj != null) {
            return obj;
        }
        obj = this.legendLayer_.getObjectAt(x, y, check);
        if (obj != null) {
            return obj;
        }
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            obj = ((DataGroupLayer)iter.next()).getObjectAt(x, y, check);
            if (obj == null) continue;
            return obj;
        }
        return obj;
    }

    void zoomTo(Point start, Rectangle rect) {
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            ((DataGroupLayer)iter.next()).zoomTo(start, rect);
        }
    }

    void resetZoom(int x, int y) {
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            ((DataGroupLayer)iter.next()).resetZoom(x, y);
        }
    }

    public void resetZoom() {
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            ((DataGroupLayer)iter.next()).resetZoom();
        }
    }

    public void setClipping(boolean clip) {
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            ((DataGroupLayer)iter.next()).setClipping(clip);
        }
    }

    public boolean hasLayer(String id) {
        if (id.equals(this.labelLayer_.getId())) {
            return true;
        }
        if (id.equals(this.legendLayer_.getId())) {
            return true;
        }
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            if (!id.equals(((DataGroupLayer)iter.next()).getId())) continue;
            return true;
        }
        return false;
    }

    public Layer getLayer(String id) {
        if (id.equals(this.labelLayer_.getId())) {
            return this.labelLayer_;
        }
        if (id.equals(this.legendLayer_.getId())) {
            return this.legendLayer_;
        }
        for (DataGroupLayer dgl : this.dataGroupLayerList_.values()) {
            if (!id.equals(dgl.getId())) continue;
            return dgl;
        }
        return null;
    }

    public boolean isDataInPanel(String id) {
        for (DataGroupLayer dgl : this.dataGroupLayerList_.values()) {
            if (!dgl.isDataInLayer(id)) continue;
            return true;
        }
        return false;
    }

    public Layer getLayerFromDataId(String id) {
        for (DataGroupLayer dgl : this.dataGroupLayerList_.values()) {
            if (!dgl.isDataInLayer(id)) continue;
            return dgl;
        }
        return null;
    }

    public Object[] getObjectsAt(int x, int y, boolean check) {
        int i;
        Object[] obj = null;
        Vector<Object> obList = new Vector<Object>();
        obj = this.labelLayer_.getObjectsAt(x, y, check);
        if (obj != null) {
            for (i = 0; i < obj.length; ++i) {
                obList.addElement(obj[i]);
            }
        }
        if ((obj = this.legendLayer_.getObjectsAt(x, y, check)) != null) {
            for (i = 0; i < obj.length; ++i) {
                obList.addElement(obj[i]);
            }
        }
        Iterator iter = this.dataGroupLayerList_.values().iterator();
        while (iter.hasNext()) {
            obj = ((DataGroupLayer)iter.next()).getObjectsAt(x, y, check);
            if (obj == null) continue;
            for (int i2 = 0; i2 < obj.length; ++i2) {
                obList.addElement(obj[i2]);
            }
        }
        return obList.toArray();
    }

    public DataGroupLayer findDataGroupLayer(String id) {
        return (DataGroupLayer)this.dataGroupLayerList_.get(id);
    }

    public JPane getPane() {
        return this.pane_;
    }

    @Override
    public void setPane(AbstractPane pane) {
        this.pane_ = (JPane)pane;
        this.update();
    }

    public void draw(Graphics g) throws PaneNotFoundException {
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        if (!this.pHolder_.isUsePageBackground()) {
            Color saved = vg.getColor();
            Rectangle r = this.pHolder_.getBounds();
            vg.setColor(this.pHolder_.getBackground());
            vg.fillRect(r.x, r.y, r.width, r.height);
            vg.setColor(saved);
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof LayerControl)) continue;
            ((LayerControl)((Object)comps[i])).draw(vg);
        }
    }

    @Override
    public void drawDraggableItems(VectorGraphics g) throws PaneNotFoundException {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof LayerControl)) continue;
            ((LayerControl)((Object)comps[i])).drawDraggableItems(g);
        }
    }

    public void addData(SGTData data, Attribute attr, DataGroup dataGroup, Legend legend) throws DataTargetMismatchException {
        DataGroupLayer agLayer = this.findDataGroupLayer(dataGroup.getId());
        DataKey key = null;
        if (legend != null) {
            key = (DataKey)this.legendLayer_.findChild(legend.getId());
        }
        agLayer.addData(data, attr, key);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.pHolder_.getId();
    }

    @Override
    public void draw(VectorGraphics g) throws PaneNotFoundException {
    }
}

