/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sgtplot.beans.Label;
import sgtplot.beans.PropertyPanel;
import sgtplot.swing.prop.ColorDialog;
import sgtplot.swing.prop.FontDialog;
import sgtplot.util.Point2D;

class LabelPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private Label label_;
    private static DecimalFormat format_ = new DecimalFormat("#.###");
    private String[] pNames_ = new String[]{"Color", "Font", "Height", "Id", "Justification", "Location", "Orientation", "Selectable", "Text", "Visible", "Width"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private String[] justType = new String[]{"Left", "Center", "Right"};
    private String[] orientType = new String[]{"Horizontal", "Vertical"};

    public LabelPropertyPanel(Label label, boolean expert) {
        this.label_ = label;
        this.label_.addChangeListener(this);
        this.expert_ = expert;
        this.create();
    }

    public void setLabel(Label label, boolean expert) {
        if (this.label_ != null) {
            this.label_.removeChangeListener(this);
        }
        this.label_ = label;
        this.label_.addChangeListener(this);
        this.expert_ = expert;
        this.reset();
    }

    @Override
    void update() {
        int item = -1;
        int i = -1;
        this.updateColor((JButton)this.comps_[++i], this.label_.getColor());
        this.updateFont((JButton)this.comps_[++i], this.label_.getFont());
        ((JTextField)this.comps_[++i]).setText(this.format(this.label_.getHeightP(), format_));
        ((JTextField)this.comps_[++i]).setText(this.label_.getId());
        switch (this.label_.getJustification()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JLabel)this.comps_[++i]).setText(this.format(this.label_.getLocationP(), true));
        switch (this.label_.getOrientation()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JCheckBox)this.comps_[++i]).setSelected(this.label_.isSelectable());
        ((JTextField)this.comps_[++i]).setText(this.label_.getText());
        ((JCheckBox)this.comps_[++i]).setSelected(this.label_.isVisible());
        ((JTextField)this.comps_[++i]).setText(this.format(this.label_.getWidthP(), format_));
    }

    @Override
    void create() {
        int i = -1;
        int item = -1;
        this.comps_[++i] = this.createColor(this.label_.getColor(), this.pNames_[i], this);
        this.comps_[++i] = this.createFont(this.label_.getFont(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.format(this.label_.getHeightP(), format_), this.pNames_[i], this, true);
        String string = this.pNames_[++i];
        this.comps_[i] = this.createTextField(this.label_.getId(), string, this, !this.label_.isInstantiated());
        switch (this.label_.getJustification()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
            }
        }
        this.comps_[++i] = this.createComboBox(this.justType, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createLabel(this.format(this.label_.getLocationP(), true));
        switch (this.label_.getOrientation()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
            }
        }
        this.comps_[++i] = this.createComboBox(this.orientType, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createCheckBox(this.label_.isSelectable(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.label_.getText(), this.pNames_[i], this, true);
        this.comps_[++i] = this.createCheckBox(this.label_.isVisible(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.format(this.label_.getWidthP(), format_), this.pNames_[i], this, true);
        for (i = 0; i < this.comps_.length; ++i) {
            this.addProperty(i + 1, this.pNames_[i], this.comps_[i], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    private void processEvent(Object obj, String command) {
        if (command.equals("Id")) {
            String oldId = this.label_.getId();
            this.label_.getPanelHolder().getLabels().remove(oldId);
            this.label_.setId(((JTextField)obj).getText());
            this.label_.getPanelHolder().getLabels().put(this.label_.getId(), this.label_);
        } else if (command.equals("Justification")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            int item = -1;
            if (str.equals("Left")) {
                item = 0;
            } else if (str.equals("Center")) {
                item = 1;
            } else if (str.equals("Right")) {
                item = 2;
            }
            this.label_.setJustification(item);
        } else if (command.equals("Text")) {
            this.label_.setText(((JTextField)obj).getText());
        } else if (command.equals("Location")) {
            this.label_.setLocationP(this.parsePoint2D(((JTextField)obj).getText()));
        } else if (command.equals("Height")) {
            this.label_.setHeightP(Float.parseFloat(((JTextField)obj).getText()));
        } else if (command.equals("Width")) {
            this.label_.setWidthP(Float.parseFloat(((JTextField)obj).getText()));
        } else if (command.equals("Visible")) {
            this.label_.setVisible(((JCheckBox)obj).isSelected());
        } else if (command.equals("Color")) {
            ColorDialog cd = new ColorDialog(this.getFrame(), "Select Label Color", true);
            cd.setColor(this.label_.getColor());
            cd.setVisible(true);
            Color newcolor = cd.getColor();
            if (newcolor != null) {
                this.label_.setColor(newcolor);
            }
        } else if (command.equals("Font")) {
            FontDialog fd = new FontDialog("Label Font");
            int result = fd.showDialog(this.label_.getFont());
            if (result == FontDialog.OK_RESPONSE) {
                this.label_.setFont(fd.getFont());
            }
        } else if (command.equals("Orientation")) {
            int old = this.label_.getOrientation();
            String str = (String)((JComboBox)obj).getSelectedItem();
            int item = -1;
            if (str.equals("Horizontal")) {
                item = 0;
            } else if (str.equals("Vertical")) {
                item = 1;
            }
            this.label_.setOrientation(item);
            if (old != item) {
                double y;
                double x;
                Point2D.Double loc = this.label_.getLocationP();
                double w = this.label_.getWidthP();
                double h = this.label_.getHeightP();
                this.label_.setWidthP(this.label_.getHeightP());
                this.label_.setHeightP(w);
                switch (this.label_.getJustification()) {
                    case 1: {
                        if (item == 1) {
                            x = loc.x + w * 0.5 - h;
                            y = loc.y - w * 0.5;
                            break;
                        }
                        x = loc.x - h * 0.5 + w;
                        y = loc.y + h * 0.5;
                        break;
                    }
                    default: {
                        if (item == 1) {
                            x = loc.x - h;
                            y = loc.y;
                            break;
                        }
                        x = loc.x + w;
                        y = loc.y;
                        break;
                    }
                    case 2: {
                        if (item == 1) {
                            x = loc.x + w - h;
                            y = loc.y - w;
                            break;
                        }
                        x = loc.x - h + w;
                        y = loc.y + h;
                    }
                }
                this.label_.setLocationP(new Point2D.Double(x, y));
            }
        } else if (command.equals("Selectable")) {
            this.label_.setSelectable(((JCheckBox)obj).isSelected());
        }
    }

    @Override
    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        String command = e.getActionCommand();
        this.processEvent(obj, command);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            JTextField tf = (JTextField)obj;
            String name = tf.getName();
            this.processEvent(obj, name);
        }
    }

    @Override
    public void setExpert(boolean expert) {
        this.expert_ = expert;
    }

    @Override
    public boolean isExpert() {
        return this.expert_;
    }
}

