/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sgtplot.beans.AxisHolder;
import sgtplot.beans.DesignListener;
import sgtplot.beans.Margin;
import sgtplot.beans.PanelHolder;
import sgtplot.util.SoTRange;

public class DataGroup
implements Serializable,
ChangeListener {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int MANUAL = 4;
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final int REFERENCE = 2;
    public static final int TIME = 3;
    public static final int PLAIN = 4;
    public static final int X_DIR = 0;
    public static final int Y_DIR = 1;
    private String id = "";
    private Margin margin = new Margin(0.25f, 0.5f, 0.5f, 0.25f);
    private boolean zoomable = true;
    private AxisHolder xAxisHolder_ = new AxisHolder(4, 0, this);
    private AxisHolder yAxisHolder_ = new AxisHolder(4, 1, this);
    private boolean zAutoScale = true;
    private SoTRange zRangeU = new SoTRange.Double(0.0, 1.0, 0.1);
    private int numberAutoContourLevels = 10;
    private PanelHolder pHolder_ = null;
    private transient Vector changeListeners;
    private transient ChangeEvent changeEvent_ = new ChangeEvent(this);
    private transient boolean instantiated = false;

    public DataGroup() {
        this("Default Id", null);
    }

    public DataGroup(String id, PanelHolder ph) {
        this(id, ph, 0, 4, 0, 4);
    }

    public DataGroup(String id, PanelHolder ph, int xt, int xAxis, int yt, int yAxis) {
        this.id = id;
        this.pHolder_ = ph;
        if (this.xAxisHolder_ == null) {
            this.xAxisHolder_ = new AxisHolder(xAxis, 0, this);
        } else {
            this.xAxisHolder_.setAxisType(xAxis);
            this.xAxisHolder_.setAxisOrientation(0);
            this.xAxisHolder_.setDataGroup(this);
        }
        this.xAxisHolder_.setTransformType(xt);
        this.xAxisHolder_.addChangeListener(this);
        if (this.yAxisHolder_ == null) {
            this.yAxisHolder_ = new AxisHolder(yAxis, 1, this);
        } else {
            this.yAxisHolder_.setAxisType(yAxis);
            this.yAxisHolder_.setAxisOrientation(1);
            this.yAxisHolder_.setDataGroup(this);
        }
        this.yAxisHolder_.setTransformType(yt);
        this.yAxisHolder_.addChangeListener(this);
    }

    public void setPanelHolder(PanelHolder ph) {
        if (this.pHolder_ != null) {
            this.removeChangeListener(this.pHolder_);
        }
        this.pHolder_ = ph;
        this.addChangeListener(this.pHolder_);
    }

    public PanelHolder getPanelHolder() {
        return this.pHolder_;
    }

    public AxisHolder getXAxisHolder() {
        return this.xAxisHolder_;
    }

    public void setXAxisHolder(AxisHolder xah) {
        this.xAxisHolder_ = xah;
        this.xAxisHolder_.addChangeListener(this);
    }

    public AxisHolder getYAxisHolder() {
        return this.yAxisHolder_;
    }

    public void setYAxisHolder(AxisHolder yah) {
        this.yAxisHolder_ = yah;
        this.yAxisHolder_.addChangeListener(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String saved = this.id;
        this.id = id;
        if (!saved.equals(this.id)) {
            this.fireStateChanged();
        }
    }

    public Margin getMargin() {
        return this.margin.copy();
    }

    public void setMargin(Margin margin) {
        Margin saved = this.margin;
        this.margin = margin;
        if (!saved.equals(this.margin)) {
            this.fireStateChanged();
        }
    }

    public void setMargin(float top, float left, float bottom, float right) {
        Margin saved = this.margin;
        this.margin = new Margin(top, left, bottom, right);
        if (!saved.equals(this.margin)) {
            this.fireStateChanged();
        }
    }

    public void removeAllChangeListeners() {
        this.changeListeners = null;
    }

    public void setZAutoScale(boolean zAutoScale) {
        boolean saved = this.zAutoScale;
        this.zAutoScale = zAutoScale;
        if (saved != zAutoScale) {
            this.fireStateChanged();
        }
    }

    public boolean isZAutoScale() {
        return this.zAutoScale;
    }

    public void setZRangeU(SoTRange zRange) {
        this.zRangeU = zRange;
    }

    public SoTRange getZRangeU() {
        return this.zRangeU;
    }

    public void setZoomable(boolean zoomable) {
        boolean saved = this.zoomable;
        this.zoomable = zoomable;
        if (saved != this.zoomable) {
            this.fireStateChanged();
        }
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void removeDesignChangeListeners() {
        if (this.changeListeners != null) {
            Vector v = (Vector)this.changeListeners.clone();
            for (Object obj : v) {
                if (!(obj instanceof DesignListener)) continue;
                this.changeListeners.removeElement(obj);
            }
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(this.changeEvent_);
            }
        }
    }

    public void setInstantiated(boolean instantiated) {
        this.instantiated = instantiated;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    public int getNumberAutoContourLevels() {
        return this.numberAutoContourLevels;
    }

    public void setNumberAutoContourLevels(int numberAutoContourLevels) {
        int saved = this.numberAutoContourLevels;
        this.numberAutoContourLevels = numberAutoContourLevels;
        if (saved != this.numberAutoContourLevels) {
            this.fireStateChanged();
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(DataGroup.class);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor pd = descriptors[i];
                if (pd.getName().equals("instantiated")) {
                    pd.setValue("transient", Boolean.TRUE);
                    continue;
                }
                if (!pd.getName().equals("panelHolder")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }
}

