/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.AxisTransform;
import sgtplot.util.GeoDate;
import sgtplot.util.Range2D;
import sgtplot.util.SoTRange;
import sgtplot.util.SoTValue;
import sgtplot.util.TimeRange;

public class LinearTransform
extends AxisTransform
implements Cloneable {
    double at_;
    double bt_;
    double a_;
    double b_;

    public LinearTransform() {
    }

    public LinearTransform(double p1, double p2, double u1, double u2) {
        super(p1, p2, u1, u2);
    }

    public LinearTransform(Range2D pr, Range2D ur) {
        super(pr, ur);
    }

    public LinearTransform(double p1, double p2, GeoDate t1, GeoDate t2) {
        super(p1, p2, t1, t2);
    }

    public LinearTransform(Range2D pr, TimeRange tr) {
        super(pr, tr);
    }

    public LinearTransform(Range2D pr, SoTRange str) {
        super(pr, str);
    }

    @Override
    public double getTransP(double u) {
        return this.a_ * u + this.b_;
    }

    @Override
    public AxisTransform copy() {
        LinearTransform newTransform;
        try {
            newTransform = (LinearTransform)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newTransform = new LinearTransform();
        }
        return newTransform;
    }

    @Override
    public double getTransP(GeoDate t) {
        return this.at_ * (double)t.getTime() + this.bt_;
    }

    @Override
    public double getTransP(SoTValue v) {
        if (v.isTime()) {
            long t = v.getLongTime();
            return this.at_ * (double)t + this.bt_;
        }
        double u = ((SoTValue.Double)v).getValue();
        return this.a_ * u + this.b_;
    }

    @Override
    public double getTransP(long t) {
        return this.at_ * (double)t + this.bt_;
    }

    @Override
    public double getTransU(double p) {
        return (p - this.b_) / this.a_;
    }

    @Override
    public GeoDate getTimeTransU(double p) {
        return new GeoDate((long)((p - this.bt_) / this.at_));
    }

    @Override
    public long getLongTimeTransU(double p) {
        return (long)((p - this.bt_) / this.at_);
    }

    @Override
    public SoTValue getSoTTransU(double p) {
        if (!this.space_) {
            return new SoTValue.Time((long)((p - this.bt_) / this.at_));
        }
        return new SoTValue.Double((p - this.b_) / this.a_);
    }

    @Override
    void computeTransform() {
        if (this.space_) {
            double denom = this.u1_ - this.u2_;
            if (denom == 0.0) {
                this.a_ = 1.0;
                this.b_ = 0.0;
            } else {
                this.a_ = (this.p1_ - this.p2_) / denom;
                this.b_ = this.p1_ - this.a_ * this.u1_;
            }
        } else {
            double denom = this.t1_ - this.t2_;
            if (denom == 0.0) {
                this.at_ = 1.0;
                this.bt_ = 0.0;
            } else {
                this.at_ = (this.p1_ - this.p2_) / denom;
                this.bt_ = this.p1_ - this.at_ * (double)this.t1_;
            }
        }
    }

    public String toString() {
        return "LinearTransform: " + this.a_ + ", " + this.b_ + "; " + this.at_ + ", " + this.bt_;
    }
}

