/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import sgtplot.ColorMap;
import sgtplot.IndexedColor;
import sgtplot.LinearTransform;
import sgtplot.Transform;
import sgtplot.TransformAccess;
import sgtplot.util.Range2D;

public class IndexedColorMap
extends ColorMap
implements Cloneable,
PropertyChangeListener,
IndexedColor,
TransformAccess {
    protected Color[] colors_;
    private Transform iTrans_ = new LinearTransform(0.0, 1.0, 0.0, 1.0);

    public IndexedColorMap(int[] red, int[] green, int[] blue) {
        this.colors_ = new Color[red.length];
        for (int indx = 0; indx < red.length; ++indx) {
            this.colors_[indx] = new Color(red[indx], green[indx], blue[indx]);
        }
        this.iTrans_.setRangeP(0.0, this.colors_.length);
    }

    public IndexedColorMap(float[] red, float[] green, float[] blue) {
        this.colors_ = new Color[red.length];
        for (int indx = 0; indx < red.length; ++indx) {
            this.colors_[indx] = new Color(red[indx], green[indx], blue[indx]);
        }
        this.iTrans_.setRangeP(0.0, this.colors_.length);
    }

    public IndexedColorMap(Color[] colors) {
        this.colors_ = colors;
        this.iTrans_.setRangeP(0.0, this.colors_.length);
    }

    @Override
    public ColorMap copy() {
        ColorMap newMap;
        try {
            newMap = (ColorMap)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newMap = new IndexedColorMap(this.colors_);
        }
        return newMap;
    }

    @Override
    public Color getColorByIndex(int indx) {
        return this.colors_[indx];
    }

    @Override
    public Color getColor(double val) {
        double ival = val;
        int indx = (int)Math.round(this.iTrans_.getTransP(ival));
        if (indx < 0) {
            indx = 0;
        }
        if (indx > this.colors_.length - 1) {
            indx = this.colors_.length - 1;
        }
        return this.colors_[indx];
    }

    @Override
    public void setRange(Range2D range) {
        this.iTrans_.setRangeU(range);
    }

    @Override
    public Range2D getRange() {
        return this.iTrans_.getRangeU();
    }

    @Override
    public void setColor(int index, Color colr) {
        this.setColor(index, colr.getRed(), colr.getGreen(), colr.getBlue());
    }

    @Override
    public void setColor(int indx, int red, int green, int blue) {
        if (indx < 0 || indx > this.colors_.length) {
            return;
        }
        Color newColor = new Color(red, green, blue);
        if (!this.colors_[indx].equals(newColor)) {
            Color tempOld = this.colors_[indx];
            this.colors_[indx] = newColor;
            this.firePropertyChange("color", tempOld, newColor);
        }
    }

    @Override
    public int getMaximumIndex() {
        return this.colors_.length - 1;
    }

    public void setTransform(Transform trans) {
        if (!trans.equals(this.iTrans_)) {
            Transform tempOld = this.iTrans_;
            if (this.iTrans_ != null) {
                this.iTrans_.removePropertyChangeListener(this);
            }
            this.iTrans_ = trans;
            this.iTrans_.setRangeP(0.0, this.colors_.length);
            this.firePropertyChange("transform", tempOld, this.iTrans_);
            this.iTrans_.addPropertyChangeListener(this);
        }
    }

    public Transform getTransform() {
        return this.iTrans_;
    }

    @Override
    public boolean equals(ColorMap cm) {
        if (cm == null || !(cm instanceof IndexedColorMap)) {
            return false;
        }
        if (!this.iTrans_.equals(((IndexedColorMap)cm).iTrans_)) {
            return false;
        }
        if (this.colors_.length != ((IndexedColorMap)cm).colors_.length) {
            return false;
        }
        for (int i = 0; i < this.colors_.length; ++i) {
            if (this.colors_[i].equals(((IndexedColorMap)cm).colors_[i])) continue;
            return false;
        }
        return true;
    }
}

