/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.Attribute;
import sgtplot.CartesianGraph;
import sgtplot.CartesianRenderer;
import sgtplot.ContourLevelNotFoundException;
import sgtplot.ContourLevels;
import sgtplot.DefaultContourLineAttribute;
import sgtplot.Format;
import sgtplot.Graph;
import sgtplot.GridAttribute;
import sgtplot.IndexedColor;
import sgtplot.Layer;
import sgtplot.contour.Contour;
import sgtplot.contour.ContourLine;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTGrid;
import sgtplot.util.GeoDate;
import sgtplot.util.Range2D;

public class GridCartesianRenderer
extends CartesianRenderer {
    private SGTGrid grid_;
    private GridAttribute attr_ = null;
    private Contour con_ = null;

    private void drawRaster(VectorGraphics g) {
        int[] yp;
        int ySize;
        int count;
        int[] xp;
        int xSize;
        GeoDate[] tValues;
        if (this.grid_.isXTime()) {
            if (this.grid_.getTimeArray().length <= 2) {
                return;
            }
            if (this.grid_.hasXEdges()) {
                tValues = this.grid_.getTimeEdges();
                xSize = tValues.length;
                xp = new int[xSize];
                for (count = 0; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD(tValues[count]);
                }
            } else {
                tValues = this.grid_.getTimeArray();
                xSize = tValues.length;
                xp = new int[xSize + 1];
                xp[0] = this.cg_.getXUtoD(tValues[0].subtract(tValues[1].subtract(tValues[0]).divide(2.0)));
                for (count = 1; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD(tValues[count - 1].add(tValues[count]).divide(2.0));
                }
                xp[xSize] = this.cg_.getXUtoD(tValues[xSize - 1].add(tValues[xSize - 1].subtract(tValues[xSize - 2]).divide(2.0)));
            }
        } else {
            double[] xValues;
            if (this.grid_.getXArray().length <= 2) {
                return;
            }
            if (this.grid_.hasXEdges()) {
                xValues = this.grid_.getXEdges();
                xSize = xValues.length;
                xp = new int[xSize];
                for (count = 0; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD(xValues[count]);
                }
            } else {
                xValues = this.grid_.getXArray();
                xSize = xValues.length;
                xp = new int[xSize + 1];
                xp[0] = this.cg_.getXUtoD(xValues[0] - (xValues[1] - xValues[0]) * 0.5);
                for (count = 1; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD((xValues[count - 1] + xValues[count]) * 0.5);
                }
                xp[xSize] = this.cg_.getXUtoD(xValues[xSize - 1] + (xValues[xSize - 1] - xValues[xSize - 2]) * 0.5);
            }
        }
        if (this.grid_.isYTime()) {
            if (this.grid_.getTimeArray().length <= 2) {
                return;
            }
            if (this.grid_.hasYEdges()) {
                tValues = this.grid_.getTimeEdges();
                ySize = tValues.length;
                yp = new int[ySize];
                for (count = 0; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD(tValues[count]);
                }
            } else {
                tValues = this.grid_.getTimeArray();
                ySize = tValues.length;
                yp = new int[ySize + 1];
                yp[0] = this.cg_.getYUtoD(tValues[0].subtract(tValues[1].subtract(tValues[0]).divide(2.0)));
                for (count = 1; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD(tValues[count - 1].add(tValues[count]).divide(2.0));
                }
                yp[ySize] = this.cg_.getYUtoD(tValues[ySize - 1].add(tValues[ySize - 1].subtract(tValues[ySize - 2]).divide(2.0)));
            }
        } else {
            double[] yValues;
            if (this.grid_.getYArray().length <= 2) {
                return;
            }
            if (this.grid_.hasYEdges()) {
                yValues = this.grid_.getYEdges();
                ySize = yValues.length;
                yp = new int[ySize];
                for (count = 0; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD(yValues[count]);
                }
            } else {
                yValues = this.grid_.getYArray();
                ySize = yValues.length;
                yp = new int[ySize + 1];
                yp[0] = this.cg_.getYUtoD(yValues[0] - (yValues[1] - yValues[0]) * 0.5);
                for (count = 1; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD((yValues[count - 1] + yValues[count]) * 0.5);
                }
                yp[ySize] = this.cg_.getYUtoD(yValues[ySize - 1] + (yValues[ySize - 1] - yValues[ySize - 2]) * 0.5);
            }
        }
        double[] gValues = this.grid_.getZArray();
        count = 0;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                double val = gValues[count];
                if (!Double.isNaN(val)) {
                    Color color = this.attr_.getColorMap().getColor(val);
                    g.setColor(color);
                    this.drawRect(g, xp[i], yp[j], xp[i + 1], yp[j + 1]);
                }
                ++count;
            }
        }
    }

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    public void setAttribute(GridAttribute attr) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = attr;
        this.attr_.addPropertyChangeListener(this);
    }

    private void drawRect(VectorGraphics g, int x1, int y1, int x2, int y2) {
        int height;
        int y;
        int width;
        int x;
        if (x1 < x2) {
            x = x1;
            width = x2 - x1;
        } else {
            x = x2;
            width = x1 - x2;
        }
        if (y1 < y2) {
            y = y1;
            height = y2 - y1;
        } else {
            y = y2;
            height = y1 - y2;
        }
        g.fillRect(x, y, width, height);
    }

    public GridCartesianRenderer(CartesianGraph cg) {
        this(cg, null, null);
    }

    public GridCartesianRenderer(CartesianGraph cg, SGTGrid data) {
        this(cg, data, null);
    }

    public GridCartesianRenderer(CartesianGraph cg, SGTGrid grid, GridAttribute attr) {
        this.cg_ = cg;
        this.grid_ = grid;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    @Override
    public void draw(VectorGraphics g) {
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        if (this.attr_.isRaster()) {
            this.drawRaster(g);
        }
        if (this.attr_.isAreaFill()) {
            double[] x = this.xArrayP();
            double[] y = this.yArrayP();
            double[] z = this.grid_.getZArray();
            int nx = x.length;
            int ny = y.length;
            double[] xt = new double[5];
            double[] yt = new double[5];
            double[] zt = new double[5];
            for (int i = 0; i < nx - 1; ++i) {
                for (int j = 0; j < ny - 1; ++j) {
                    xt[0] = x[i];
                    yt[0] = y[j];
                    zt[0] = z[j + i * ny];
                    xt[1] = x[i + 1];
                    yt[1] = y[j];
                    zt[1] = z[j + (i + 1) * ny];
                    xt[2] = x[i + 1];
                    yt[2] = y[j + 1];
                    zt[2] = z[j + 1 + (i + 1) * ny];
                    xt[3] = xt[0];
                    yt[3] = yt[2];
                    zt[3] = z[j + 1 + i * ny];
                    xt[4] = xt[0];
                    yt[4] = yt[0];
                    zt[4] = zt[0];
                    this.fillSquare(g, xt, yt, zt);
                }
            }
        }
        if (this.attr_.isContour()) {
            Range2D range = this.computeRange(10);
            this.con_ = new Contour(this.cg_, this.grid_, this.attr_.getContourLevels());
            ContourLevels clevels = this.con_.getContourLevels();
            for (int i = 0; i < clevels.size(); ++i) {
                try {
                    double val = clevels.getLevel(i);
                    DefaultContourLineAttribute attr = clevels.getDefaultContourLineAttribute(i);
                    if (!attr.isAutoLabel()) continue;
                    Format format = attr.getLabelFormat().length() <= 0 ? new Format(Format.computeFormat(range.start, range.end, attr.getSignificantDigits())) : new Format(attr.getLabelFormat());
                    String label = format.form(val);
                    attr.setLabelText(label);
                    continue;
                }
                catch (ContourLevelNotFoundException e) {
                    System.out.println(e);
                }
            }
            this.con_.generateContourLines();
            this.con_.generateContourLabels(g);
            Enumeration elem = this.con_.elements();
            while (elem.hasMoreElements()) {
                ContourLine cl = (ContourLine)elem.nextElement();
                cl.draw(g);
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip((Shape)rect);
    }

    private void fillSquare(VectorGraphics g, double[] x, double[] y, double[] z) {
        ContourLevels clevels = this.attr_.getContourLevels();
        IndexedColor cmap = (IndexedColor)((Object)this.attr_.getColorMap());
        double[] xpoly = new double[20];
        double[] ypoly = new double[20];
        double zmin = Math.min(z[0], z[1]);
        double zmax = Math.max(z[0], z[1]);
        for (int i = 2; i <= 3; ++i) {
            zmin = Math.min(zmin, z[i]);
            zmax = Math.max(zmax, z[i]);
        }
        if (Double.isNaN(zmax)) {
            return;
        }
        int maxindex = clevels.getMaximumIndex();
        for (int cindex = -1; cindex <= maxindex; ++cindex) {
            double zlevp1;
            double zlev;
            try {
                zlev = cindex == -1 ? -1.7976931348623157E308 : clevels.getLevel(cindex);
                zlevp1 = cindex == maxindex ? Double.MAX_VALUE : clevels.getLevel(cindex + 1);
            }
            catch (ContourLevelNotFoundException e) {
                System.out.println(e);
                break;
            }
            Color col = cmap.getColorByIndex(cindex + 1);
            if (zmin > zlevp1 || zmax < zlev) continue;
            if (zmin >= zlev && zmax <= zlevp1) {
                this.fillPolygon(g, col, x, y, 4);
                return;
            }
            int npoly = -1;
            for (int j = 0; j < 4; ++j) {
                double f;
                if (z[j] < zlev) {
                    if (z[j + 1] > zlevp1) {
                        f = (z[j] - zlev) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        continue;
                    }
                    if (!(z[j + 1] >= zlev) || !(z[j + 1] <= zlevp1)) continue;
                    f = (z[j] - zlev) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    xpoly[++npoly] = x[j + 1];
                    ypoly[npoly] = y[j + 1];
                    continue;
                }
                if (z[j] > zlevp1) {
                    if (z[j + 1] < zlev) {
                        f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        f = (z[j] - zlev) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        continue;
                    }
                    if (!(z[j + 1] >= zlev) || !(z[j + 1] <= zlevp1)) continue;
                    f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    xpoly[++npoly] = x[j + 1];
                    ypoly[npoly] = y[j + 1];
                    continue;
                }
                if (z[j + 1] > zlevp1) {
                    f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    continue;
                }
                if (z[j + 1] < zlev) {
                    f = (z[j] - zlev) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    continue;
                }
                xpoly[++npoly] = x[j + 1];
                ypoly[npoly] = y[j + 1];
            }
            this.fillPolygon(g, col, xpoly, ypoly, npoly + 1);
        }
    }

    private void fillPolygon(VectorGraphics g, Color c, double[] x, double[] y, int npoints) {
        Layer layer = this.cg_.getLayer();
        int[] xt = new int[20];
        int[] yt = new int[20];
        g.setColor(c);
        for (int i = 0; i < npoints; ++i) {
            xt[i] = layer.getXPtoD(x[i]);
            yt[i] = layer.getYPtoD(y[i]);
        }
        g.fillPolygon(xt, yt, npoints);
    }

    private double[] xArrayP() {
        double[] p;
        if (this.grid_.isXTime()) {
            GeoDate[] t = this.grid_.getTimeArray();
            p = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                p[i] = this.cg_.getXUtoP(t[i]);
            }
        } else {
            double[] x = this.grid_.getXArray();
            p = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                p[i] = this.cg_.getXUtoP(x[i]);
            }
        }
        return p;
    }

    private double[] yArrayP() {
        double[] p;
        if (this.grid_.isYTime()) {
            GeoDate[] t = this.grid_.getTimeArray();
            p = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                p[i] = this.cg_.getYUtoP(t[i]);
            }
        } else {
            double[] y = this.grid_.getYArray();
            p = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                p[i] = this.cg_.getYUtoP(y[i]);
            }
        }
        return p;
    }

    private Range2D computeRange(int levels) {
        double zmin = Double.POSITIVE_INFINITY;
        double zmax = Double.NEGATIVE_INFINITY;
        double[] array = this.grid_.getZArray();
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            zmin = Math.min(zmin, array[i]);
            zmax = Math.max(zmax, array[i]);
        }
        Range2D range = Graph.computeRange(zmin, zmax, levels);
        return range;
    }

    public SGTGrid getGrid() {
        return this.grid_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("GridCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return null;
    }
}

