/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.clapper.util.text.AbstractVariableSubstituter;
import org.clapper.util.text.MapVariableDereferencer;
import org.clapper.util.text.UnixShellVariableSubstituter;
import org.clapper.util.text.VariableSubstituter;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.WindowsCmdVariableSubstituter;

public class TestVariableSubstituter {
    private VariableSubstituter vsub = null;

    private TestVariableSubstituter(VariableSubstituter vsub) {
        this.vsub = vsub;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            TestVariableSubstituter.usage();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            strings.add(args[i]);
        }
        AbstractVariableSubstituter vs = null;
        if (args[0].equals("unix")) {
            vs = new UnixShellVariableSubstituter();
        } else if (args[0].equals("windows")) {
            vs = new WindowsCmdVariableSubstituter();
        } else {
            TestVariableSubstituter.usage();
        }
        try {
            TestVariableSubstituter tester = new TestVariableSubstituter(vs);
            tester.runTest(args[1], strings);
            System.exit(0);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + TestVariableSubstituter.class + " unix|windows properties_file string ...");
        System.err.println("Uses values from System.properties and the specified properties files.");
        System.exit(1);
    }

    private void runTest(String propertiesFile, Collection strings) throws FileNotFoundException, IOException, VariableSubstitutionException {
        FileInputStream in = new FileInputStream(propertiesFile);
        Properties properties = new Properties();
        properties.load(in);
        ((InputStream)in).close();
        properties.putAll((Map<?, ?>)System.getProperties());
        MapVariableDereferencer vderef = new MapVariableDereferencer(properties);
        for (String s : strings) {
            String s2 = this.vsub.substitute(s, vderef, null);
            System.out.println();
            System.out.println("BEFORE: \"" + s + "\"");
            System.out.println("AFTER:  \"" + s2 + "\"");
        }
    }
}

