/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.text.TextUtil;
import org.clapper.util.text.XStringBuffer;

public class SplitString
extends CommandLineUtility {
    private String delims = null;
    private boolean useRegexp = false;
    private int limit = 0;
    private String[] strings = null;
    private boolean preserveEmpty = false;

    private SplitString() {
    }

    public static void main(String[] args) {
        SplitString tester = new SplitString();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            this.runTest();
        }
        catch (Exception ex) {
            throw new CommandLineException(ex);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        switch (shortOption) {
            case 'l': {
                this.limit = this.parseIntOptionArgument(shortOption, longOption, it.next());
                break;
            }
            case 'r': {
                this.delims = it.next();
                this.useRegexp = true;
                break;
            }
            case 'd': {
                this.delims = it.next();
                this.useRegexp = false;
                break;
            }
            case 'p': {
                this.preserveEmpty = true;
                break;
            }
            default: {
                throw new CommandLineUsageException("Unrecognized option");
            }
        }
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        ArrayList<String> temp = new ArrayList<String>();
        do {
            temp.add(it.next());
        } while (it.hasNext());
        this.strings = new String[temp.size()];
        int i = 0;
        it = temp.iterator();
        while (it.hasNext()) {
            this.strings[i] = it.next();
            ++i;
        }
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addOption('l', "limit", "n", "Set the split limit to <n>. If not specified, all instances of the pattern are used. Only applicable when -r is used.");
        info.addOption('r', "regexp", "regexp", "Regular expression to use to split the string. If neither -r nor -s is specified, white space is used.");
        info.addOption('p', "preserve", "Preserve empty strings (i.e., don't parse through adjacent delimiters). Defaults to off.");
        info.addOption('d', "delims", "delims", "Set of delimiters to use to split the strings. If neither -r nor -s is specified, white space is used.");
        info.addParameter("string ...", "String to split. May be specified more than once.", true);
    }

    private void runTest() throws PatternSyntaxException {
        XStringBuffer printableDelims = new XStringBuffer();
        if (this.delims == null) {
            printableDelims.append("white space");
        } else {
            printableDelims.append(this.delims);
            printableDelims.encodeMetacharacters();
        }
        for (int i = 0; i < this.strings.length; ++i) {
            String[] splitStrings = null;
            if (this.useRegexp) {
                splitStrings = this.strings[i].split(this.delims, this.limit);
            } else {
                if (this.delims == null) {
                    this.delims = " \t\n\r";
                }
                splitStrings = this.preserveEmpty ? TextUtil.split(this.strings[i], this.delims, this.preserveEmpty) : TextUtil.split(this.strings[i], this.delims);
            }
            System.out.println();
            System.out.println("String:   \"" + this.strings[i] + "\"");
            System.out.print("Split by: \"" + printableDelims.toString() + "\"");
            if (this.useRegexp) {
                System.out.print(" (regular expression)");
            }
            System.out.println();
            if (splitStrings == null) {
                System.out.println("    <null> result");
                continue;
            }
            if (splitStrings.length == 0) {
                System.out.println("    empty array result");
                continue;
            }
            for (int j = 0; j < splitStrings.length; ++j) {
                System.out.println("    \"" + splitStrings[j] + "\"");
            }
        }
    }
}

