/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import org.clapper.util.text.UndefinedVariableException;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableNameChecker;
import org.clapper.util.text.VariableSubstituter;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.VariableSyntaxException;

public abstract class AbstractVariableSubstituter
implements VariableSubstituter,
VariableNameChecker {
    private boolean abortOnUndefinedVariable = false;
    private boolean abortOnSyntaxError = false;

    protected AbstractVariableSubstituter() {
    }

    @Override
    public boolean legalVariableCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.';
    }

    public String substitute(String s, VariableDereferencer deref) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        return this.substitute(s, deref, null);
    }

    @Override
    public String substitute(String s, VariableDereferencer deref, Object context) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        return this.substitute(s, deref, null, context);
    }

    @Override
    public abstract String substitute(String var1, VariableDereferencer var2, VariableNameChecker var3, Object var4) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException;

    @Override
    public boolean getAbortOnSyntaxError() {
        return this.abortOnSyntaxError;
    }

    @Override
    public boolean getAbortOnUndefinedVariable() {
        return this.abortOnUndefinedVariable;
    }

    @Override
    public void setAbortOnSyntaxError(boolean enable) {
        this.abortOnSyntaxError = enable;
    }

    @Override
    public void setAbortOnUndefinedVariable(boolean enable) {
        this.abortOnUndefinedVariable = enable;
    }
}

