/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.misc.LRUMap;
import org.clapper.util.regex.RegexException;
import org.clapper.util.text.TextUtil;

public class RegexUtil {
    public static final int DEFAULT_LRU_BUFFER_SIZE = 20;
    private LRUMap<Substitution, Pattern> compiledRegexps = new LRUMap(100);

    public String substitute(String substitutionCommand, String s) throws RegexException {
        Pattern pattern;
        if (substitutionCommand.length() < 5) {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.substitutionCommandTooShort", "Substitution command \"{0}\" is too short.", new Object[]{substitutionCommand});
        }
        if (substitutionCommand.charAt(0) != 's') {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionSyntax", "\"{0}\" is a syntactically incorrect substitution command.", new Object[]{substitutionCommand});
        }
        char delim = substitutionCommand.charAt(1);
        if (Character.isWhitespace(delim) || Character.isLetter(delim)) {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionDelim", "Substitution command \"{0}\" uses alphabetic or white-space delimiter \"{1}\".", new Object[]{substitutionCommand, String.valueOf(delim)});
        }
        String[] fields = TextUtil.split(substitutionCommand, delim, true);
        if (fields.length != 3 && fields.length != 4) {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionSyntax", "\"{0}\" is a syntactically incorrect substitution command.", new Object[]{substitutionCommand});
        }
        assert (fields[0].length() == 1 && fields[0].charAt(0) == 's');
        String regex = fields[1];
        String replacement = fields[2];
        Substitution sub = new Substitution(regex);
        if (fields.length == 4) {
            this.getSubstitutionFlags(substitutionCommand, fields[3], sub);
        }
        if ((pattern = this.compiledRegexps.get(sub)) == null) {
            try {
                pattern = Pattern.compile(regex, sub.flags);
                this.compiledRegexps.put(sub, pattern);
            }
            catch (PatternSyntaxException ex) {
                throw new RegexException(ex);
            }
        }
        String result = s;
        Matcher matcher = pattern.matcher(s);
        result = sub.replaceAll ? matcher.replaceAll(replacement) : matcher.replaceFirst(replacement);
        return result;
    }

    private void getSubstitutionFlags(String substitutionCommand, String sFlags, Substitution sub) throws RegexException {
        char[] modifiers = sFlags.toCharArray();
        block7: for (int i = 0; i < modifiers.length; ++i) {
            char mod = modifiers[i];
            switch (mod) {
                case 'g': {
                    sub.replaceAll = true;
                    continue block7;
                }
                case 'i': {
                    sub.flags |= 2;
                    continue block7;
                }
                case 'm': {
                    sub.flags |= 8;
                    continue block7;
                }
                case 'o': {
                    continue block7;
                }
                case 'x': {
                    sub.flags |= 4;
                    continue block7;
                }
                default: {
                    throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionModifier", "Substitution command \"{0}\" has unknown modifier character\"{1}\".", new Object[]{substitutionCommand, String.valueOf(mod)});
                }
            }
        }
    }

    private class Substitution {
        int flags = 0;
        boolean replaceAll = false;
        String regex = null;
        int hc = -1;

        Substitution(String regex) {
            this.regex = regex;
        }

        public synchronized int hashCode() {
            if (this.hc == -1) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.regex);
                buf.append(String.valueOf(this.replaceAll));
                buf.append(String.valueOf(this.flags));
                this.hc = buf.toString().hashCode();
            }
            return this.hc;
        }

        public boolean equals(Object o) {
            boolean eq = false;
            if (o instanceof Substitution) {
                eq = this.regex.equals(((Substitution)o).regex) && this.flags == ((Substitution)o).flags && this.replaceAll == ((Substitution)o).replaceAll;
            }
            return eq;
        }
    }
}

