/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.clapper.util.misc.BuildInfo;
import org.clapper.util.misc.BundleUtil;

public abstract class VersionBase {
    protected VersionBase() {
    }

    public String getVersion() {
        return BundleUtil.getString(this.getVersionBundleName(), this.getVersionKey(), "?");
    }

    public String getCopyright() {
        return BundleUtil.getString(this.getVersionBundleName(), this.getCopyrightKey(), "?");
    }

    public String getApplicationName() {
        return BundleUtil.getString(this.getVersionBundleName(), this.getApplicationNameKey(), "?");
    }

    public String getVersionDisplay() {
        BuildInfo buildInfo = new BuildInfo(this.getBuildInfoBundleName());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String versionBundle = this.getVersionBundleName();
        pw.print(BundleUtil.getString(versionBundle, this.getApplicationNameKey(), "Unknown application"));
        pw.print(", version ");
        pw.println(this.getVersion());
        pw.println(this.getCopyright());
        pw.println();
        pw.println("Build:          " + buildInfo.getBuildID());
        pw.println("Build date:     " + buildInfo.getBuildDate());
        pw.println("Built by:       " + buildInfo.getBuildUserID());
        pw.println("Built on:       " + buildInfo.getBuildOperatingSystem());
        pw.println("Build Java VM:  " + buildInfo.getBuildJavaVM());
        pw.println("Build compiler: " + buildInfo.getBuildJavaCompiler());
        pw.print("Ant version:    " + buildInfo.getBuildAntVersion());
        return sw.getBuffer().toString();
    }

    protected abstract String getVersionBundleName();

    protected abstract String getBuildInfoBundleName();

    protected abstract String getVersionKey();

    protected abstract String getCopyrightKey();

    protected abstract String getApplicationNameKey();
}

