/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.clapper.util.misc.BundleUtil;

public class NestedException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String resourceBundleName = null;
    private String bundleMessageKey = null;
    private String defaultMessage = null;
    private Object[] messageParams = null;

    public NestedException() {
    }

    public NestedException(Throwable exception) {
        this(exception.getMessage(), exception);
    }

    public NestedException(String message) {
        super(message);
    }

    public NestedException(String message, Throwable exception) {
        super(message, exception);
    }

    public NestedException(String bundleName, String messageKey, String defaultMsg) {
        this(bundleName, messageKey, defaultMsg, null, null);
    }

    public NestedException(String bundleName, String messageKey, String defaultMsg, Object[] msgParams) {
        this(bundleName, messageKey, defaultMsg, msgParams, null);
    }

    public NestedException(String bundleName, String messageKey, String defaultMsg, Throwable exception) {
        this(bundleName, messageKey, defaultMsg, null, exception);
    }

    public NestedException(String bundleName, String messageKey, String defaultMsg, Object[] msgParams, Throwable exception) {
        this.initCause(exception);
        this.resourceBundleName = bundleName;
        this.bundleMessageKey = messageKey;
        this.defaultMessage = defaultMsg;
        this.messageParams = msgParams;
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        StringBuilder buf = new StringBuilder();
        String msg = null;
        if (this.resourceBundleName != null && this.bundleMessageKey != null) {
            msg = BundleUtil.getMessage(this.resourceBundleName, locale, this.bundleMessageKey, this.defaultMessage, this.messageParams);
        }
        if (msg == null && (msg = this.defaultMessage) == null) {
            msg = super.getMessage();
        }
        if (msg != null) {
            buf.append(msg);
        } else {
            Throwable containedException;
            for (containedException = this.getCause(); containedException != null && msg == null; containedException = containedException.getCause()) {
                if (containedException instanceof NestedException) {
                    msg = ((NestedException)containedException).getMessage(locale);
                    break;
                }
                msg = containedException.getMessage();
            }
            if (msg != null) {
                buf.append(msg);
            } else {
                buf.append(this.getClass().getName());
                if (containedException != null) {
                    buf.append(" (contains ");
                    buf.append(containedException.getClass().getName());
                    buf.append(")");
                }
            }
        }
        return buf.toString();
    }

    public String getMessages() {
        return this.getMessages(false);
    }

    public String getMessages(boolean elideNewlines) {
        return this.getMessages(elideNewlines, null);
    }

    public String getMessages(boolean elideNewlines, Locale locale) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable ex = this;
        StringBuffer buf = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (elideNewlines) {
            buf = new StringBuffer();
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        while (ex != null) {
            String s = ex instanceof NestedException ? ex.getMessage(locale) : ((Throwable)ex).getMessage();
            if (s == null) {
                s = ((Throwable)ex).toString();
            }
            if (elideNewlines) {
                try {
                    String line;
                    LineNumberReader r = new LineNumberReader(new StringReader(s));
                    String sep = "";
                    buf.setLength(0);
                    while ((line = r.readLine()) != null) {
                        buf.append(sep);
                        buf.append(line);
                        sep = " ";
                    }
                    s = buf.toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!messages.contains(s)) {
                messages.add(s);
            }
            ex = ex.getCause();
        }
        String sep = "";
        for (String message : messages) {
            if (elideNewlines) {
                pw.print(sep);
                pw.print(message);
                sep = ": ";
                continue;
            }
            pw.println(message);
        }
        return sw.getBuffer().toString();
    }

    public Throwable getNestedException() {
        return this.getCause();
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getMessage();
        return message != null ? s + ": " + message : s;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(Locale locale) {
        this.printStackTrace(System.err, locale);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
    }

    public void printStackTrace(PrintWriter out, Locale locale) {
        if (locale == null) {
            super.printStackTrace(out);
        } else {
            Locale oldLocale = Locale.getDefault();
            Locale.setDefault(locale);
            super.printStackTrace(out);
            out.flush();
            Locale.setDefault(oldLocale);
        }
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
    }

    public void printStackTrace(PrintStream out, Locale locale) {
        this.printStackTrace(new PrintWriter(out), locale);
    }
}

