/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import org.clapper.util.io.JustifyStyle;
import org.clapper.util.io.JustifyTextWriter;
import org.clapper.util.io.WordWrapWriter;
import org.clapper.util.text.TextUtil;

public class TestWordWrapWriter {
    private static String prefix = null;
    private static int indent = 0;
    private static int lineLen = 80;
    private static JustifyTextWriter jtWriter = null;
    private static JustifyStyle justification = null;
    private static InputStream in = System.in;

    private TestWordWrapWriter() {
    }

    public static void main(String[] args) {
        try {
            TestWordWrapWriter.runTest(args);
        }
        catch (IllegalArgumentException ex) {
            TestWordWrapWriter.usage();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void runTest(String[] args) throws IllegalArgumentException, IOException {
        String line;
        TestWordWrapWriter.parseParams(args);
        WordWrapWriter wOut = jtWriter != null ? new WordWrapWriter(jtWriter, lineLen) : new WordWrapWriter((OutputStream)System.out, lineLen);
        wOut.setPrefix(prefix);
        wOut.setIndentation(indent);
        LineNumberReader r = new LineNumberReader(new InputStreamReader(in));
        String sep = "";
        while ((line = r.readLine()) != null) {
            if (line.length() == 0) {
                sep = "";
                wOut.println();
                wOut.println();
                wOut.flush();
                continue;
            }
            String[] words = TextUtil.split(line);
            for (int i = 0; i < words.length; ++i) {
                wOut.print(sep);
                wOut.print(words[i]);
                sep = " ";
            }
        }
        wOut.flush();
    }

    private static void parseParams(String[] args) throws IllegalArgumentException {
        try {
            int i;
            for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
                if (args[i].equals("-p")) {
                    prefix = args[++i];
                    continue;
                }
                if (args[i].equals("-i")) {
                    indent = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-l")) {
                    lineLen = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-R")) {
                    justification = JustifyStyle.RIGHT_JUSTIFY;
                    continue;
                }
                if (args[i].equals("-C")) {
                    justification = JustifyStyle.CENTER;
                    continue;
                }
                if (args[i].equals("-L")) {
                    justification = JustifyStyle.LEFT_JUSTIFY;
                    continue;
                }
                throw new IllegalArgumentException(args[i]);
            }
            if (i < args.length) {
                in = new FileInputStream(args[i++]);
            }
            if (i < args.length) {
                System.err.println("Too many arguments.");
                TestWordWrapWriter.usage();
                System.exit(1);
            }
            if (justification != null) {
                jtWriter = new JustifyTextWriter((OutputStream)System.out, justification, lineLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Missing argument(s)");
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad argument to numeric option: " + ex.toString());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    private static void usage() {
        WordWrapWriter err = new WordWrapWriter(System.err);
        err.setPrefix("Usage: ");
        err.println("java " + TestWordWrapWriter.class.getName() + " [OPTIONS]");
        err.setPrefix(null);
        String[] remainder = new String[]{"", "OPTIONS", "", "-p <prefix>    Set the WordWrapWriter prefix to <prefix>", "               Default: None.", "-i <n>         Set the WordWrapWriter indentation to <n>", "               Default: 0", "-l <n>         Set the WordWrapWriter line length to <n>", "               Default: 80", "-R             Use a JustifyTextWriter to right-justify the", "               wrapped lines.", "-C             Use a JustifyTextWriter to center the", "               wrapped lines.", "-L             Use a JustifyTextWriter to left-justify the", "               wrapped lines."};
        for (int i = 0; i < remainder.length; ++i) {
            err.println(remainder[i]);
        }
    }
}

