/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.io.AndFilenameFilter;
import org.clapper.util.io.FileFilterMatchType;
import org.clapper.util.io.NotFilenameFilter;
import org.clapper.util.io.RecursiveFileFinder;
import org.clapper.util.io.RegexFilenameFilter;

public class FindFiles {
    private static String directory = ".";
    private static FileFilterMatchType matchType = FileFilterMatchType.PATH;

    public static void main(String[] args) {
        FindFiles prog = new FindFiles();
        ArrayList<String> acceptPatterns = new ArrayList<String>();
        ArrayList<String> rejectPatterns = new ArrayList<String>();
        try {
            FindFiles.parseParams(args, acceptPatterns, rejectPatterns);
            prog.findFiles(acceptPatterns, rejectPatterns);
        }
        catch (PatternSyntaxException ex) {
            System.err.println(ex);
            System.exit(1);
        }
    }

    private static void parseParams(String[] args, Collection<String> acceptPatterns, Collection<String> rejectPatterns) throws PatternSyntaxException {
        try {
            int i;
            for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
                if (args[i].equals("-e")) {
                    rejectPatterns.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-i")) {
                    acceptPatterns.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-p")) {
                    matchType = FileFilterMatchType.PATH;
                    continue;
                }
                if (args[i].equals("-n")) {
                    matchType = FileFilterMatchType.FILENAME;
                    continue;
                }
                throw new IllegalArgumentException(args[i]);
            }
            int argsLeft = args.length - i;
            if (argsLeft > 1) {
                System.err.println("Too many arguments.");
                FindFiles.usage();
                System.exit(1);
            }
            if (argsLeft == 1) {
                directory = args[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.err.println("Missing argument(s)");
            FindFiles.usage();
            System.exit(1);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Bad option: " + ex.getMessage());
            FindFiles.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: " + FindFiles.class.getName() + " [-e exclude_pattern] ...  [-i include_pattern] ...  [-n|-p] [directory]");
    }

    FindFiles() {
    }

    private void findFiles(Collection<String> acceptPatterns, Collection<String> rejectPatterns) throws PatternSyntaxException {
        RecursiveFileFinder finder = new RecursiveFileFinder();
        ArrayList<File> files = new ArrayList<File>();
        System.out.println("*** Using match type of " + (Object)((Object)matchType));
        AndFilenameFilter masterFilter = new AndFilenameFilter();
        for (String pattern : acceptPatterns) {
            masterFilter.addFilter(new RegexFilenameFilter(pattern, matchType));
        }
        for (String pattern : rejectPatterns) {
            masterFilter.addFilter(new NotFilenameFilter(new RegexFilenameFilter(pattern, matchType)));
        }
        finder.findFiles(new File(directory), masterFilter, files);
        if (files.size() == 0) {
            System.out.println("*** No matches.");
        } else {
            for (File file : files) {
                System.out.println(file);
            }
        }
    }
}

