/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.clapper.util.io.FileUtil;

public class Zipper {
    private static final int OUTPUT_BUF_SIZE = 8192;
    private File zipFile = null;
    private boolean isJar = false;
    private ZipOutputStream zipStream = null;
    private Manifest manifest = null;
    private boolean flatten = false;
    private int totalEntriesWritten = 0;
    private Set<String> tableOfContents = new HashSet<String>();

    public Zipper(String path, boolean flatten) throws IOException {
        this(new File(path), flatten);
    }

    public Zipper(String path, Manifest manifest, boolean flatten) throws IOException {
        this(new File(path), manifest, flatten);
    }

    public Zipper(File file, boolean flatten) throws IOException {
        this(file, null, flatten);
    }

    public Zipper(File file, Manifest manifest, boolean flatten) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File \"" + file.getPath() + "\" is a directory.");
        }
        this.zipFile = file;
        this.flatten = flatten;
        String ext = FileUtil.getFileNameExtension(file.getName());
        if (ext.equals(".jar")) {
            this.isJar = true;
            this.manifest = manifest;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() throws IOException {
        if (this.zipStream != null) {
            this.zipStream.close();
            this.zipStream = null;
        }
    }

    public synchronized boolean containsEntry(String name) {
        return this.tableOfContents.contains(this.convertName(name));
    }

    public File getFile() {
        return this.zipFile;
    }

    public int getTotalEntries() {
        return this.totalEntriesWritten;
    }

    public void put(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File \"" + file.getPath() + "\" does not exist.");
        }
        if (!file.isDirectory() && !file.canRead()) {
            throw new IOException("Cannot read file \"" + file.getPath() + "\".");
        }
        if (file.isDirectory()) {
            this.writeDirectory(file);
        } else {
            this.write(file);
        }
    }

    public void put(File file, String name) throws IOException {
        FileInputStream in = new FileInputStream(file);
        this.write(in, name);
        in.close();
    }

    public void put(String path) throws IOException {
        this.put(new File(path));
    }

    public void put(InputStream istream, String name) throws IOException {
        this.write(istream, name);
    }

    public void put(byte[] bytes, String name) throws IOException {
        this.write(bytes, name);
    }

    public void put(URL url, String name) throws IOException {
        this.write(url.openConnection().getInputStream(), name);
    }

    private void write(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        this.write(in, file.getPath());
        in.close();
    }

    private void write(InputStream istream, String name) throws IOException {
        int total;
        this.open();
        name = this.convertName(name);
        ZipEntry zipEntry = this.getZipEntry(name);
        this.zipStream.putNextEntry(zipEntry);
        byte[] buf = new byte[8192];
        while ((total = istream.read(buf, 0, buf.length)) > 0) {
            this.zipStream.write(buf, 0, total);
        }
        this.zipStream.closeEntry();
        ++this.totalEntriesWritten;
        this.tableOfContents.add(name);
    }

    private void write(byte[] bytes, String name) throws IOException {
        this.open();
        name = this.convertName(name);
        ZipEntry zipEntry = this.getZipEntry(name);
        this.zipStream.putNextEntry(zipEntry);
        this.zipStream.write(bytes, 0, bytes.length);
        this.zipStream.closeEntry();
        ++this.totalEntriesWritten;
        this.tableOfContents.add(name);
    }

    public void writeDirectory(File file) throws IOException {
        this.open();
        String name = this.convertName(file.getPath());
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        ZipEntry zipEntry = this.getZipEntry(name);
        this.zipStream.putNextEntry(zipEntry);
        this.zipStream.closeEntry();
        ++this.totalEntriesWritten;
        this.tableOfContents.add(name);
    }

    private String convertName(String name) {
        if (this.flatten) {
            name = new File(name).getName();
        } else {
            File[] fsRoots = File.listRoots();
            for (int i = 0; i < fsRoots.length; ++i) {
                String root = fsRoots[i].getPath();
                if (!name.toLowerCase().startsWith(root.toLowerCase())) continue;
                name = name.substring(root.length());
                break;
            }
            if (File.separatorChar != '/') {
                name = name.replace(File.separatorChar, '/');
            }
        }
        return name;
    }

    private ZipEntry getZipEntry(String name) {
        return this.isJar ? new ZipEntry(name) : new JarEntry(name);
    }

    private synchronized void open() throws IOException {
        if (this.zipStream == null) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.zipFile));
            this.zipStream = this.isJar ? (this.manifest != null ? new JarOutputStream((OutputStream)out, this.manifest) : new JarOutputStream(out)) : new ZipOutputStream(out);
        }
    }
}

