/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.zip.GZIPOutputStream;
import org.clapper.util.io.FileUtil;
import org.clapper.util.io.IOExceptionExt;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.UnixShellVariableSubstituter;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableSubstitutionException;

public class RollingFileWriter
extends PrintWriter {
    public static final String INDEX_PATTERN = "${n}";
    private static final String GZIP_EXTENSION = ".gz";
    private File primaryFile = null;
    private String filePattern = null;
    private String charsetName = null;
    private long maxRolledFileSize = 0L;
    private int maxRolledOverFiles = 0;
    private Compression compressionType = Compression.COMPRESS_BACKUPS;
    private RolloverCallback callback = null;
    private static String newline = System.getProperty("line.separator");
    private static Logger log = new Logger(RollingFileWriter.class);

    public RollingFileWriter(String fileNamePattern) throws IOExceptionExt {
        this(fileNamePattern, null, Compression.DONT_COMPRESS_BACKUPS);
    }

    public RollingFileWriter(String fileNamePattern, Compression compressionType) throws IOExceptionExt {
        this(fileNamePattern, null, compressionType);
    }

    public RollingFileWriter(String fileNamePattern, String charsetName, Compression compressionType) throws IOExceptionExt {
        this(fileNamePattern, charsetName, 0L, 0, compressionType, null);
    }

    public RollingFileWriter(String fileNamePattern, String charsetName, long maxRolledFileSize, int maxRolledFiles) throws IOExceptionExt {
        this(fileNamePattern, charsetName, maxRolledFileSize, maxRolledFiles, Compression.DONT_COMPRESS_BACKUPS, null);
    }

    public RollingFileWriter(String fileNamePattern, long maxRolledFileSize, int maxRolledFiles, Compression compressionType) throws IOExceptionExt {
        this(fileNamePattern, null, maxRolledFileSize, maxRolledFiles, compressionType, null);
    }

    public RollingFileWriter(String fileNamePattern, String charsetName, long maxRolledFileSize, int maxRolledOverFiles, Compression compressionType, RolloverCallback callback) throws IOExceptionExt {
        super(RollingFileWriter.openPrimaryFile(fileNamePattern, charsetName, maxRolledOverFiles, compressionType, callback), true);
        this.filePattern = fileNamePattern;
        this.compressionType = compressionType;
        this.primaryFile = RollingFileWriter.resolveFilePattern(fileNamePattern, null, maxRolledOverFiles, null);
        this.callback = callback;
        this.charsetName = charsetName;
        this.compressionType = compressionType;
        this.maxRolledFileSize = maxRolledFileSize;
        this.maxRolledOverFiles = maxRolledOverFiles;
    }

    public String getPathName() {
        return this.primaryFile.getPath();
    }

    @Override
    public synchronized void flush() {
        super.flush();
    }

    @Override
    public synchronized void println() {
        super.println();
        try {
            this.checkForRollOver();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void println(boolean b) {
        this.print(b);
        this.println();
    }

    @Override
    public synchronized void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public synchronized void println(char[] s) {
        this.print(s);
        this.println();
    }

    @Override
    public synchronized void println(double d) {
        this.print(d);
        this.println();
    }

    @Override
    public synchronized void println(float f) {
        this.print(f);
        this.println();
    }

    @Override
    public synchronized void println(int i) {
        this.print(i);
        this.println();
    }

    @Override
    public synchronized void println(long l) {
        super.print(l);
        this.println();
    }

    public synchronized void println(short s) {
        super.print(s);
        this.println();
    }

    @Override
    public synchronized void println(String s) {
        super.print(s);
        this.println();
    }

    @Override
    public synchronized void println(Object o) {
        super.print(o);
        this.println();
    }

    private void printlnNoRoll(String line) {
        super.write(line);
        super.write(newline);
        super.flush();
    }

    private synchronized void checkForRollOver() throws IOExceptionExt {
        long fileSize;
        if (this.maxRolledFileSize > 0L && this.maxRolledOverFiles > 0 && (fileSize = this.primaryFile.length()) >= this.maxRolledFileSize) {
            log.debug("fileSize=" + fileSize + ", maxSize=" + this.maxRolledFileSize + " -> must roll files over.");
            this.out = RollingFileWriter.rollFilesOver(this.primaryFile, this.filePattern, this.charsetName, this.maxRolledOverFiles, this.compressionType, this, this.callback);
        }
    }

    private static void renameFile(File sourceFile, File targetFile) throws IOExceptionExt {
        log.debug("Moving file \"" + sourceFile.getName() + "\" to \"" + targetFile.getName() + "\"");
        try {
            if (!sourceFile.renameTo(targetFile)) {
                throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantMoveFile", "Unable to move file \"{0}\" to \"{1}\"", new Object[]{sourceFile.getPath(), targetFile.getPath()});
            }
        }
        catch (SecurityException ex) {
            throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantMoveFile", "Unable to move file \"{0}\" to \"{1}\"", new Object[]{sourceFile.getPath(), targetFile.getPath()}, ex);
        }
    }

    private static Writer openPrimaryFile(String fileNamePattern, String charsetName, int maxRolledOverFiles, Compression compressionType, RolloverCallback callback) throws IOExceptionExt {
        File primaryFile = RollingFileWriter.resolveFilePattern(fileNamePattern, null, maxRolledOverFiles, null);
        log.debug("primaryFile=" + primaryFile.getPath());
        Writer w = null;
        if (primaryFile.exists()) {
            log.debug("Primary file exists. Rolling...");
            w = RollingFileWriter.rollFilesOver(primaryFile, fileNamePattern, charsetName, maxRolledOverFiles, compressionType, null, callback);
        } else {
            log.debug("Primary file does not exist.");
            w = RollingFileWriter.openFile(primaryFile, charsetName);
        }
        return w;
    }

    private static Writer openFile(File file, String charsetName) throws IOExceptionExt {
        OutputStreamWriter result = null;
        try {
            result = charsetName != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName) : new FileWriter(file);
        }
        catch (IOException ex) {
            throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantOpenFile", "Unable to open file \"{0}\"", new Object[]{file.getPath()});
        }
        return result;
    }

    private static File resolveFilePattern(String fileNamePattern, Integer index, int maxRolledOverFiles, Compression compressionType) throws IOExceptionExt {
        try {
            BackupIndexDereferencer deref = new BackupIndexDereferencer(index, maxRolledOverFiles);
            UnixShellVariableSubstituter sub = new UnixShellVariableSubstituter();
            sub.setHonorEscapes(false);
            String fileName = sub.substitute(fileNamePattern, deref, null, fileNamePattern);
            if (!deref.patternIsLegal()) {
                throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.badPattern", "File pattern \"{0}\" is missing the \"$'{n}'\" marker.", new Object[]{fileNamePattern});
            }
            if (compressionType == Compression.COMPRESS_BACKUPS) {
                fileName = fileName + GZIP_EXTENSION;
            }
            return new File(fileName);
        }
        catch (VariableSubstitutionException ex) {
            throw new IOExceptionExt(ex);
        }
    }

    private static Writer rollFilesOver(File primaryFile, String fileNamePattern, String charsetName, int maxRolledOverFiles, Compression compressionType, RollingFileWriter rollingFileWriter, RolloverCallback callback) throws IOExceptionExt {
        int i;
        log.debug("rolling \"" + primaryFile.getPath() + "\"");
        int firstGap = -1;
        int lastLegalIndex = maxRolledOverFiles - 1;
        for (i = 0; i < maxRolledOverFiles; ++i) {
            File f = RollingFileWriter.resolveFilePattern(fileNamePattern, i, maxRolledOverFiles, compressionType);
            if (f.exists()) continue;
            firstGap = i;
            break;
        }
        log.debug("firstGap(1)=" + firstGap);
        if (firstGap == -1) {
            firstGap = lastLegalIndex;
        }
        log.debug("firstGap(2)=" + firstGap);
        for (i = firstGap - 1; i >= 0; --i) {
            File targetFile = RollingFileWriter.resolveFilePattern(fileNamePattern, i + 1, maxRolledOverFiles, compressionType);
            File sourceFile = RollingFileWriter.resolveFilePattern(fileNamePattern, i, maxRolledOverFiles, compressionType);
            if (targetFile.exists()) {
                log.debug("Removing file \"" + targetFile.getPath() + "\"");
                try {
                    targetFile.delete();
                }
                catch (SecurityException ex) {
                    throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantDeleteFile", "Can't delete file \"{0}\"", new Object[]{targetFile.getPath()});
                }
            }
            RollingFileWriter.renameFile(sourceFile, targetFile);
        }
        String rollOverMsg = null;
        if (rollingFileWriter != null) {
            if (callback != null && (rollOverMsg = callback.getRollOverMessage()) != null) {
                log.debug("Appending roll-over message \"" + rollOverMsg + "\" to full primary file \"" + primaryFile + "\"");
                rollingFileWriter.printlnNoRoll(rollOverMsg);
            }
            log.debug("Closing full primary file \"" + primaryFile + "\".");
            rollingFileWriter.flush();
            rollingFileWriter.close();
        }
        File targetFile = RollingFileWriter.resolveFilePattern(fileNamePattern, 0, maxRolledOverFiles, null);
        RollingFileWriter.renameFile(primaryFile, targetFile);
        if (compressionType == Compression.COMPRESS_BACKUPS) {
            RollingFileWriter.gzipFile(targetFile);
        }
        log.debug("Reopening \"" + primaryFile + "\"");
        Writer result = RollingFileWriter.openFile(primaryFile, charsetName);
        if (rollOverMsg != null) {
            try {
                log.debug("Writing roll-over message \"" + rollOverMsg + "\" to top of new primary file \"" + primaryFile + "\"");
                result.write(rollOverMsg);
                result.write(newline);
                result.flush();
            }
            catch (IOException ex) {
                throw new IOExceptionExt(ex);
            }
        }
        return result;
    }

    private static void gzipFile(File file) throws IOExceptionExt {
        try {
            FileInputStream is = new FileInputStream(file);
            GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(file.getPath() + GZIP_EXTENSION));
            FileUtil.copyStream(is, os);
            ((InputStream)is).close();
            ((OutputStream)os).close();
            if (!file.delete()) {
                throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantDeleteFile", "Can't delete file \"{0}\"", new Object[]{file.getPath()});
            }
        }
        catch (IOException ex) {
            throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantGzipFile", "Can't gzip file \"{0}\"", new Object[]{file.getPath()});
        }
    }

    public static enum Compression {
        COMPRESS_BACKUPS,
        DONT_COMPRESS_BACKUPS;

    }

    public static interface RolloverCallback {
        public String getRollOverMessage();
    }

    private static class BackupIndexDereferencer
    implements VariableDereferencer {
        private Integer index;
        private DecimalFormat indexFormat;
        private boolean legal = false;

        BackupIndexDereferencer(Integer index, int maxRolledOverFiles) {
            this.index = index;
            this.indexFormat = this.indexFormat;
            String digitCount = String.valueOf(maxRolledOverFiles - 1);
            StringBuilder format = new StringBuilder();
            for (int i = 0; i < digitCount.length(); ++i) {
                format.append('0');
            }
            this.indexFormat = new DecimalFormat(format.toString());
        }

        @Override
        public String getVariableValue(String varName, Object context) throws VariableSubstitutionException {
            if (!varName.equals("n")) {
                throw new VariableSubstitutionException("org.clapper.util.io.Bundle", "RollingFileWriter.unknownVariable", "Unknown variable \"{0}\" in file pattern \"{1}\"", new Object[]{varName, context});
            }
            this.legal = true;
            StringBuilder buf = new StringBuilder();
            if (this.index != null) {
                buf.append(".");
                buf.append(this.indexFormat.format(this.index));
            }
            return buf.toString();
        }

        boolean patternIsLegal() {
            return this.legal;
        }
    }
}

