/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.io.FileFilterMatchType;

public class RegexFilenameFilter
implements FilenameFilter {
    private FileFilterMatchType matchType = FileFilterMatchType.PATH;
    private Pattern pattern;

    public RegexFilenameFilter(String regex) throws PatternSyntaxException {
        this(regex, FileFilterMatchType.FILENAME);
    }

    public RegexFilenameFilter(String regex, FileFilterMatchType matchType) throws PatternSyntaxException {
        this.matchType = matchType;
        this.pattern = Pattern.compile(regex);
    }

    public RegexFilenameFilter(String regex, int regexFlags, FileFilterMatchType matchType) throws PatternSyntaxException {
        this.matchType = matchType;
        this.pattern = Pattern.compile(regex, regexFlags);
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.matchType == FileFilterMatchType.PATH) {
            name = new File(dir, name).getPath();
        }
        return this.pattern.matcher(name).find();
    }
}

