/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MultipleRegexFilenameFilter
implements FilenameFilter {
    private Collection<Pattern> acceptPatterns = null;
    private Collection<Pattern> rejectPatterns = null;
    private int regexOptions;
    private MatchType matchType = MatchType.FILENAME;

    public MultipleRegexFilenameFilter(MatchType matchType) {
        this.matchType = matchType;
        this.regexOptions = 2;
        this.acceptPatterns = new ArrayList<Pattern>();
        this.rejectPatterns = new ArrayList<Pattern>();
    }

    public void addAcceptPattern(String pattern) throws PatternSyntaxException {
        this.acceptPatterns.add(Pattern.compile(pattern, this.regexOptions));
    }

    public void addRejectPattern(String pattern) throws PatternSyntaxException {
        this.rejectPatterns.add(Pattern.compile(pattern, this.regexOptions));
    }

    @Override
    public boolean accept(File dir, String name) {
        Matcher matcher;
        boolean match = false;
        boolean found = false;
        if (this.matchType == MatchType.PATH) {
            name = dir.getPath() + System.getProperty("file.separator") + name;
        }
        for (Pattern pattern : this.rejectPatterns) {
            matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            match = false;
            found = true;
            break;
        }
        if (!found) {
            if (this.acceptPatterns.size() == 0) {
                match = true;
            } else {
                for (Pattern pattern : this.acceptPatterns) {
                    matcher = pattern.matcher(name);
                    if (!matcher.matches()) continue;
                    match = true;
                    break;
                }
            }
        }
        return match;
    }

    public static enum MatchType {
        FILENAME,
        PATH;

    }
}

