/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.io.CombinationFilterMode;

public class CombinationFilenameFilter
implements FilenameFilter {
    public static final CombinationFilterMode AND_FILTERS = CombinationFilterMode.AND_FILTERS;
    public static final CombinationFilterMode OR_FILTERS = CombinationFilterMode.OR_FILTERS;
    private List<FilenameFilter> filters = new LinkedList<FilenameFilter>();
    private CombinationFilterMode mode = AND_FILTERS;

    public CombinationFilenameFilter() {
        this(AND_FILTERS);
    }

    public CombinationFilenameFilter(CombinationFilterMode mode) {
        this.setMode(mode);
    }

    public CombinationFilterMode getMode() {
        return this.mode;
    }

    public void setMode(CombinationFilterMode mode) {
        this.mode = mode;
    }

    public void addFilter(FilenameFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(FilenameFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean accepted = false;
        Iterator<FilenameFilter> it = this.filters.iterator();
        if (this.mode == AND_FILTERS) {
            accepted = true;
            while (accepted && it.hasNext()) {
                FilenameFilter filter = it.next();
                accepted = filter.accept(dir, name);
            }
        } else {
            accepted = false;
            while (!accepted && it.hasNext()) {
                FilenameFilter filter = it.next();
                accepted = filter.accept(dir, name);
            }
        }
        return accepted;
    }
}

