/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.clapper.util.config.Configuration;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.SectionExistsException;
import org.clapper.util.io.WordWrapWriter;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.VariableSubstitutionException;

public class ParseConfig {
    private ParseConfig() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            ParseConfig.usage();
        }
        ArrayList<String> vars = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            vars.add(args[i]);
        }
        try {
            Logger.enableLogging();
            ParseConfig tester = new ParseConfig();
            tester.runTest(args[0], vars);
            System.exit(0);
        }
        catch (ConfigurationException ex) {
            new WordWrapWriter(System.err).println(ex.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + ParseConfig.class + " file|url [section:var=value] ... ");
        System.exit(1);
    }

    private void runTest(String thing, Collection vars) throws FileNotFoundException, IOException, ConfigurationException, SectionExistsException, NoSuchElementException, VariableSubstitutionException {
        Configuration config = new Configuration();
        try {
            config.load(new URL(thing));
        }
        catch (MalformedURLException ex) {
            config.load(new File(thing));
        }
        for (String s : vars) {
            int i = s.indexOf(58);
            if (i == -1) {
                throw new ConfigurationException("Bad variable setting: \"" + s + "\"");
            }
            String section = s.substring(0, i);
            int j = s.indexOf(61, ++i);
            if (i == -1) {
                throw new ConfigurationException("Bad variable setting: \"" + s + "\"");
            }
            String varName = s.substring(i, j);
            String value = s.substring(j + 1);
            if (!config.containsSection(section)) {
                config.addSection(section);
            }
            config.setVariable(section, varName, value, true);
        }
        System.out.println("Configuration, tokenized:");
        System.out.println("------------------------------------------------------------------------------");
        for (String sectionName : config.getSectionNames()) {
            System.out.println("[" + sectionName + "]");
            for (String variableName : config.getVariableNames(sectionName)) {
                System.out.print(variableName + ": ");
                String[] tokens = config.getConfigurationTokens(sectionName, variableName);
                if (tokens != null) {
                    System.out.print("[");
                    String sep = "";
                    for (int i = 0; i < tokens.length; ++i) {
                        System.out.print(sep + tokens[i]);
                        sep = ",";
                    }
                    System.out.print("]");
                }
                System.out.println();
            }
        }
        System.out.println();
        System.out.println("Configuration, recreated:");
        System.out.println("------------------------------------------------------------------------------");
        config.write(System.out);
    }
}

