/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.Section;
import org.clapper.util.config.Variable;
import org.clapper.util.text.TextUtil;

class ProgramSection
extends Section {
    static final String PROGRAM_NOW_VAR = "now";
    static final String PROGRAM_CWD_VAR = "cwd";
    static final String PROGRAM_CWD_URL_VAR = "cwd.url";

    ProgramSection(String name, int id) throws ConfigurationException {
        super(name, id);
        this.loadProgramSectionStaticValues();
    }

    @Override
    Variable getVariable(String varName) throws ConfigurationException {
        Variable result = varName.startsWith(PROGRAM_NOW_VAR) ? new Variable(varName, this.substituteDatetime(varName), this, 0) : super.getVariable(varName);
        return result;
    }

    private void loadProgramSectionStaticValues() throws ConfigurationException {
        try {
            File dir = new File(".");
            String value = dir.getCanonicalPath();
            this.addVariable(PROGRAM_CWD_VAR, value);
            value = dir.getCanonicalFile().toURI().toURL().toString();
            if (value.charAt(value.length() - 1) == '/') {
                value = value.substring(0, value.length() - 1);
            }
            this.addVariable(PROGRAM_CWD_URL_VAR, value);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    private String substituteDatetime(String varName) throws ConfigurationException {
        String value = "";
        Date now = new Date();
        if (varName.equals(PROGRAM_NOW_VAR)) {
            value = now.toString();
        } else {
            char delim = varName.charAt(PROGRAM_NOW_VAR.length());
            String[] tokens = TextUtil.split(varName, delim);
            if (tokens.length != 2 && tokens.length != 4) {
                throw new ConfigurationException("org.clapper.util.config.Bundle", "ProgramSection.badNowFieldCount", "Section \"{0}\", variable reference \"{1}\": Incorrect number of fields in extended version of \"{2}\" variable. Found {3} fields, expected either {4} or {5}.", new Object[]{this.getName(), varName, PROGRAM_NOW_VAR, String.valueOf(tokens.length), "2", "4"});
            }
            Locale locale = null;
            locale = tokens.length == 2 ? Locale.getDefault() : new Locale(tokens[2], tokens[3]);
            try {
                SimpleDateFormat fmt = new SimpleDateFormat(tokens[1], locale);
                value = fmt.format(now);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException(ex.toString());
            }
        }
        return value;
    }
}

