/*
 * Decompiled with CFR 0.152.
 */
package jhplot.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jhplot.utils.ColorComboBox;
import jhplot.utils.FontLabel;
import jhplot.utils.InputList;

public class GHFontChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected int Closed_Option = -1;
    protected InputList fontNameInputList;
    protected InputList fontSizeInputList;
    protected MutableAttributeSet attributes;
    protected JCheckBox boldCheckBox = new JCheckBox("Bold");
    protected JCheckBox italicCheckBox = new JCheckBox("Italic");
    protected JCheckBox underlineCheckBox = new JCheckBox("Underline");
    protected JCheckBox strikethroughCheckBox = new JCheckBox("Strikethrough");
    protected JCheckBox subscriptCheckBox = new JCheckBox("Subscript");
    protected JCheckBox superscriptCheckBox = new JCheckBox("Superscript");
    protected ColorComboBox colorComboBox;
    protected ColorComboBox colorComboBoxBack;
    protected FontLabel previewLabel;
    protected String inputText;
    public static String[] fontNames;
    public static String[] fontSizes;
    public JTextField sepField;
    private int WIDTH = 350;
    private int HEIGHT = 400;

    public GHFontChooser(Container owner, String inputString) {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setDefaultCloseOperation(2);
        this.setTitle("Title editor");
        this.setModal(true);
        this.setResizable(false);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        fontNames = ge.getAvailableFontFamilyNames();
        fontSizes = new String[]{"7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "40", "48", "72"};
        this.fontNameInputList = new InputList(fontNames, "Name:");
        this.fontSizeInputList = new InputList(fontSizes, "Size:");
        JPanel p = new JPanel(new GridLayout(1, 2, 10, 2));
        p.setBorder(new TitledBorder(new EtchedBorder(), "Font"));
        p.add(this.fontNameInputList);
        this.fontNameInputList.setDisplayedMnemonic('n');
        this.fontNameInputList.setToolTipText("Font name");
        p.add(this.fontSizeInputList);
        this.fontSizeInputList.setDisplayedMnemonic('s');
        this.fontSizeInputList.setToolTipText("Font size");
        this.add(p);
        p = new JPanel(new GridLayout(1, 4, 10, 5));
        p.setBorder(new TitledBorder(new EtchedBorder(), "Effects"));
        this.boldCheckBox.setMnemonic('b');
        this.boldCheckBox.setToolTipText("Bold font");
        p.add(this.boldCheckBox);
        this.italicCheckBox.setMnemonic('i');
        this.italicCheckBox.setToolTipText("Italic font");
        p.add(this.italicCheckBox);
        this.colorComboBox = new ColorComboBox();
        this.colorComboBox.setBorder(new TitledBorder(new EtchedBorder(), "Font color"));
        this.colorComboBox.setToolTipText("Font color");
        ToolTipManager.sharedInstance().registerComponent(this.colorComboBox);
        p.add(this.colorComboBox);
        this.getContentPane().add(p);
        this.colorComboBoxBack = new ColorComboBox();
        this.colorComboBoxBack.setBorder(new TitledBorder(new EtchedBorder(), "Backg. color"));
        this.colorComboBoxBack.setToolTipText("Background color");
        ToolTipManager.sharedInstance().registerComponent(this.colorComboBoxBack);
        p.add(this.colorComboBoxBack);
        this.getContentPane().add(p);
        this.getContentPane().add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(10));
        JLabel lbl = new JLabel("Title:");
        lbl.setDisplayedMnemonic('t');
        p.add(lbl);
        p.add(Box.createHorizontalStrut(24));
        this.sepField = new JTextField(inputString, 2);
        p.add(this.sepField);
        p.add(Box.createHorizontalStrut(10));
        this.getContentPane().add(p);
        p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(new EtchedBorder(), "Preview"));
        this.previewLabel = new FontLabel("Preview Font");
        p.add((Component)this.previewLabel, "Center");
        this.getContentPane().add(p);
        p = new JPanel(new FlowLayout());
        JPanel p1 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton btOK = new JButton("OK");
        btOK.setToolTipText("Save and exit");
        this.getRootPane().setDefaultButton(btOK);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GHFontChooser.this.Closed_Option = 0;
                GHFontChooser.this.dispose();
            }
        };
        btOK.addActionListener(actionListener);
        p1.add(btOK);
        JButton btCancel = new JButton("Cancel");
        btCancel.setToolTipText("Exit without save");
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GHFontChooser.this.Closed_Option = 2;
                GHFontChooser.this.dispose();
            }
        };
        btCancel.addActionListener(actionListener);
        p1.add(btCancel);
        p.add(p1);
        this.getContentPane().add(p);
        ListSelectionListener listSelectListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GHFontChooser.this.updatePreview();
            }
        };
        this.fontNameInputList.addListSelectionListener(listSelectListener);
        this.fontSizeInputList.addListSelectionListener(listSelectListener);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GHFontChooser.this.updatePreview();
            }
        };
        this.boldCheckBox.addActionListener(actionListener);
        this.italicCheckBox.addActionListener(actionListener);
        this.colorComboBox.addActionListener(actionListener);
        this.pack();
    }

    public String getInputText() {
        return this.sepField.getText();
    }

    public void setAttributes(AttributeSet a) {
        this.attributes = new SimpleAttributeSet(a);
        String name = StyleConstants.getFontFamily(a);
        this.fontNameInputList.setSelected(name);
        int size = StyleConstants.getFontSize(a);
        this.fontSizeInputList.setSelectedInt(size);
        this.boldCheckBox.setSelected(StyleConstants.isBold(a));
        this.italicCheckBox.setSelected(StyleConstants.isItalic(a));
        this.underlineCheckBox.setSelected(StyleConstants.isUnderline(a));
        this.strikethroughCheckBox.setSelected(StyleConstants.isStrikeThrough(a));
        this.subscriptCheckBox.setSelected(StyleConstants.isSubscript(a));
        this.superscriptCheckBox.setSelected(StyleConstants.isSuperscript(a));
        this.colorComboBox.setSelectedItem(StyleConstants.getForeground(a));
        this.colorComboBoxBack.setSelectedItem(StyleConstants.getBackground(a));
        this.updatePreview();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        StyleConstants.setFontFamily(this.attributes, this.fontNameInputList.getSelected());
        StyleConstants.setFontSize(this.attributes, this.fontSizeInputList.getSelectedInt());
        StyleConstants.setBold(this.attributes, this.boldCheckBox.isSelected());
        StyleConstants.setItalic(this.attributes, this.italicCheckBox.isSelected());
        StyleConstants.setUnderline(this.attributes, this.underlineCheckBox.isSelected());
        StyleConstants.setStrikeThrough(this.attributes, this.strikethroughCheckBox.isSelected());
        StyleConstants.setSubscript(this.attributes, this.subscriptCheckBox.isSelected());
        StyleConstants.setSuperscript(this.attributes, this.superscriptCheckBox.isSelected());
        StyleConstants.setForeground(this.attributes, (Color)this.colorComboBox.getSelectedItem());
        StyleConstants.setBackground(this.attributes, (Color)this.colorComboBoxBack.getSelectedItem());
        return this.attributes;
    }

    public GHFontChooser(JComponent owner) {
        this(owner, "test");
    }

    public int getOption() {
        return this.Closed_Option;
    }

    protected void updatePreview() {
        String name = this.fontNameInputList.getSelected();
        int size = this.fontSizeInputList.getSelectedInt();
        if (size <= 0) {
            return;
        }
        int style = 0;
        if (this.boldCheckBox.isSelected()) {
            style |= 1;
        }
        if (this.italicCheckBox.isSelected()) {
            style |= 2;
        }
        Font fn = new Font(name, style, size);
        this.previewLabel.setFont(fn);
        Color c = (Color)this.colorComboBox.getSelectedItem();
        this.previewLabel.setForeground(c);
        this.previewLabel.repaint();
    }

    public static void main(String[] argv) {
    }
}

