/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml.driver;

import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDriver
implements XmlHandler,
Locator,
Attributes,
XMLReader {
    private DefaultHandler base = new DefaultHandler();
    private XmlParser parser;
    private boolean seenDTDEvents = false;
    private EntityResolver entityResolver = this.base;
    private DTDHandler dtdHandler = this.base;
    private ContentHandler documentHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private String elementName = null;
    private Stack entityStack = new Stack();
    private Vector attributeNames = new Vector();
    private Vector attributeValues = new Vector();
    private Hashtable properties = new Hashtable();
    private Hashtable features = new Hashtable();

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXException("AElfred driver does not yet have locale support.");
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setDocumentHandler(ContentHandler handler) {
        this.documentHandler = handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void parse(InputSource source) throws SAXException {
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        try {
            if (source.getCharacterStream() != null) {
                this.parser.parse(source.getSystemId(), source.getPublicId(), source.getCharacterStream());
            } else if (source.getByteStream() != null) {
                this.parser.parse(source.getSystemId(), source.getPublicId(), source.getByteStream(), source.getEncoding());
            } else {
                this.parser.parse(source.getSystemId(), source.getPublicId(), source.getEncoding());
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        finally {
            try {
                this.closeStreams(source);
            }
            catch (Exception exception) {}
        }
        try {
            this.closeStreams(source);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void parse(String systemId) throws SAXException {
        this.parse(new InputSource(systemId));
    }

    private void closeStreams(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            source.getCharacterStream().close();
        }
        if (source.getByteStream() != null) {
            source.getByteStream().close();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.documentHandler.setDocumentLocator(this);
        this.documentHandler.startDocument();
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.documentHandler.endDocument();
    }

    @Override
    public Object resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = this.entityResolver.resolveEntity(publicId, systemId);
        if (source == null) {
            return null;
        }
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        }
        if (source.getByteStream() != null) {
            return source.getByteStream();
        }
        return source.getSystemId();
    }

    @Override
    public void startExternalEntity(String systemId) throws SAXException {
        this.entityStack.push(systemId);
    }

    @Override
    public void endExternalEntity(String systemId) throws SAXException {
        this.entityStack.pop();
    }

    @Override
    public void doctypeDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void attribute(String aname, String value, boolean isSpecified) throws SAXException {
        if (value != null) {
            this.attributeNames.addElement(aname);
            this.attributeValues.addElement(value);
        }
    }

    @Override
    public void startElement(String elname) throws SAXException {
        if (!this.seenDTDEvents) {
            this.deliverDTDEvents();
            this.seenDTDEvents = true;
        }
        this.elementName = elname;
        this.documentHandler.startElement("", elname, "", this);
        this.elementName = null;
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    @Override
    public void endElement(String elname) throws SAXException {
        this.documentHandler.endElement("", elname, "");
    }

    @Override
    public void charData(char[] ch, int start, int length) throws SAXException {
        this.documentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.documentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.documentHandler.processingInstruction(target, data);
    }

    @Override
    public void error(String message, String url, int line, int column) throws SAXException {
        this.errorHandler.fatalError(new SAXParseException(message, null, url, line, column));
    }

    private void deliverDTDEvents() throws SAXException {
        String systemId;
        String publicId;
        String nname;
        Enumeration notationNames = this.parser.declaredNotations();
        Enumeration entityNames = this.parser.declaredEntities();
        while (notationNames.hasMoreElements()) {
            nname = (String)notationNames.nextElement();
            publicId = this.parser.getNotationPublicId(nname);
            systemId = this.parser.getNotationSystemId(nname);
            this.dtdHandler.notationDecl(nname, publicId, systemId);
        }
        while (entityNames.hasMoreElements()) {
            String ename = (String)entityNames.nextElement();
            if (this.parser.getEntityType(ename) != 2) continue;
            publicId = this.parser.getEntityPublicId(ename);
            systemId = this.parser.getEntitySystemId(ename);
            nname = this.parser.getEntityNotationName(ename);
            this.dtdHandler.unparsedEntityDecl(ename, publicId, systemId, nname);
        }
    }

    @Override
    public int getLength() {
        return this.attributeNames.size();
    }

    public String getName(int i) {
        return (String)this.attributeNames.elementAt(i);
    }

    @Override
    public String getType(int i) {
        switch (this.parser.getAttributeType(this.elementName, this.getName(i))) {
            case 0: 
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: 
            case 9: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 10: {
                return "NOTATION";
            }
        }
        return null;
    }

    @Override
    public String getValue(int i) {
        return (String)this.attributeValues.elementAt(i);
    }

    @Override
    public String getType(String name) {
        for (int i = 0; i < this.getLength(); ++i) {
            if (!name.equals(this.getName(i))) continue;
            return this.getType(i);
        }
        return null;
    }

    @Override
    public String getValue(String name) {
        for (int i = 0; i < this.getLength(); ++i) {
            if (!name.equals(this.getName(i))) continue;
            return this.getValue(i);
        }
        return null;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return (String)this.entityStack.peek();
    }

    @Override
    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    @Override
    public boolean getFeature(String name) {
        if (this.features.containsKey(name)) {
            return (Boolean)this.features.get(name);
        }
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) {
        this.features.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.documentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.documentHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public String getURI(int index) {
        return "";
    }

    @Override
    public String getLocalName(int index) {
        return "";
    }

    @Override
    public String getQName(int index) {
        return "";
    }

    @Override
    public int getIndex(String uri, String localPart) {
        return -1;
    }

    @Override
    public int getIndex(String qName) {
        return -1;
    }

    @Override
    public String getType(String uri, String localName) {
        return "";
    }

    @Override
    public String getValue(String uri, String localName) {
        return "";
    }
}

