/*
 * Decompiled with CFR 0.152.
 */
package com.flaptor.hist4j;

import com.flaptor.hist4j.AdaptiveHistogram;
import com.flaptor.hist4j.Cell;
import com.flaptor.hist4j.HistogramForkNode;
import com.flaptor.hist4j.HistogramNode;
import java.util.ArrayList;

public class HistogramDataNode
extends HistogramNode {
    private static final long serialVersionUID = -1L;
    private Cell cell = new Cell();

    public HistogramDataNode() {
        this.reset();
    }

    public HistogramDataNode(long count, float minValue, float maxValue) {
        this.reset();
        this.cell.count = count;
        this.cell.minValue = minValue;
        this.cell.maxValue = maxValue;
    }

    @Override
    public void reset() {
        this.cell.count = 0L;
        this.cell.minValue = Float.MAX_VALUE;
        this.cell.maxValue = -3.4028235E38f;
    }

    @Override
    public HistogramNode addValue(AdaptiveHistogram root, float value) {
        HistogramNode self = this;
        if (value >= this.cell.minValue && value <= this.cell.maxValue) {
            if (this.cell.count < (long)root.getCountPerNodeLimit() || this.cell.minValue == this.cell.maxValue) {
                ++this.cell.count;
            } else {
                boolean countWasOdd;
                float splitValue = (this.cell.minValue + this.cell.maxValue) / 2.0f;
                long rightCount = this.cell.count / 2L;
                long leftCount = rightCount;
                boolean bl = countWasOdd = leftCount + rightCount < this.cell.count;
                if (value > splitValue) {
                    ++rightCount;
                    leftCount += (long)(countWasOdd ? 1 : 0);
                } else {
                    ++leftCount;
                    rightCount += (long)(countWasOdd ? 1 : 0);
                }
                HistogramDataNode leftNode = new HistogramDataNode(leftCount, this.cell.minValue, splitValue);
                HistogramDataNode rightNode = new HistogramDataNode(rightCount, splitValue, this.cell.maxValue);
                self = new HistogramForkNode(splitValue, leftNode, rightNode);
            }
        } else if (this.cell.count < (long)root.getCountPerNodeLimit()) {
            ++this.cell.count;
            if (value < this.cell.minValue) {
                this.cell.minValue = value;
            }
            if (value > this.cell.maxValue) {
                this.cell.maxValue = value;
            }
        } else if (value < this.cell.minValue) {
            this.cell.minValue = Math.min(this.cell.minValue, (value + this.cell.maxValue) / 2.0f);
            self = new HistogramForkNode(this.cell.minValue, new HistogramDataNode(1L, value, this.cell.minValue), this);
        } else {
            this.cell.maxValue = Math.max(this.cell.maxValue, (this.cell.minValue + value) / 2.0f);
            self = new HistogramForkNode(this.cell.maxValue, this, new HistogramDataNode(1L, this.cell.maxValue, value));
        }
        return self;
    }

    @Override
    public long getCount(float value) {
        long res = 0L;
        if (value >= this.cell.minValue && value <= this.cell.maxValue) {
            res = this.cell.count;
        }
        return res;
    }

    @Override
    public long getAccumCount(float value) {
        long res = 0L;
        if (value >= this.cell.minValue) {
            res = this.cell.count;
        }
        return res;
    }

    private float interpolate(float x0, float y0, float x1, float y1, float x) {
        return y0 + (x - x0) * (y1 - y0) / (x1 - x0);
    }

    @Override
    public Float getValueForAccumCount(long[] accumCount) {
        Float res = null;
        long runningAccumCount = accumCount[0];
        long targetAccumCount = accumCount[1];
        if (runningAccumCount <= targetAccumCount && runningAccumCount + this.cell.count >= targetAccumCount) {
            float val = this.interpolate(runningAccumCount, this.cell.minValue, runningAccumCount + this.cell.count, this.cell.maxValue, targetAccumCount);
            res = new Float(val);
        }
        accumCount[0] = accumCount[0] + this.cell.count;
        return res;
    }

    @Override
    public void apply(AdaptiveHistogram.ValueConversion valueConversion) {
        this.cell.minValue = valueConversion.convertValue(this.cell.minValue);
        this.cell.maxValue = valueConversion.convertValue(this.cell.maxValue);
    }

    @Override
    public void show(int level) {
        this.margin(level);
        System.out.println("Data: " + this.cell.count + " (" + this.cell.minValue + "," + this.cell.maxValue + ")");
    }

    @Override
    public void toTable(ArrayList<Cell> table) {
        table.add(this.cell);
    }
}

