/*
 * Decompiled with CFR 0.152.
 */
package com.csam.dif;

import com.csam.dif.DIFCell;
import com.csam.dif.DIFDataException;
import com.csam.dif.DIFDataPairParsingException;
import com.csam.dif.DIFKeywordException;
import com.csam.dif.DIFNumberPairInfoException;
import com.csam.dif.DIFReader;
import com.csam.dif.DIFRow;
import com.csam.dif.DIFRowExistsException;
import com.csam.dif.DIFStringFormatException;
import com.csam.dif.DIFWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.TreeMap;

public final class DIFSheet {
    private TreeMap<Integer, DIFRow> rows = new TreeMap();
    private String title;
    private int version;

    public DIFSheet() {
    }

    public DIFSheet(InputStream inStream) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException, ParseException {
        this();
        DIFReader.readSheet(this, inStream);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.getClass().getName() + " {\n");
        ret.append("    title=" + this.getTitle() + "\n");
        Iterator<DIFRow> rows = this.rowIterator();
        while (rows.hasNext()) {
            DIFRow row = rows.next();
            ret.append("    " + row.getRowNumber() + " = {\n");
            Iterator<DIFCell> cells = row.cellIterator();
            while (cells.hasNext()) {
                DIFCell cell = cells.next();
                try {
                    ret.append("        " + cell.getCellNumber() + "(" + cell.getCellType().name() + ") = " + cell.getStringCellValue() + "\n");
                }
                catch (DIFDataException ex) {
                    ex.printStackTrace();
                    ret.append(ex.toString());
                }
            }
            ret.append("    }\n");
        }
        ret.append("}");
        return ret.toString();
    }

    public DIFRow createRow(int rowNumber) throws DIFRowExistsException {
        if (this.hasRow(rowNumber)) {
            throw new DIFRowExistsException(this, rowNumber);
        }
        DIFRow row = new DIFRow(this, rowNumber);
        this.rows.put(rowNumber, row);
        return row;
    }

    public boolean hasRow(int rowNumber) {
        return this.rows.containsKey(rowNumber);
    }

    public Iterator<DIFRow> rowIterator() {
        return this.rows.values().iterator();
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public int getFirstRowNumber() {
        return this.rows.firstKey();
    }

    public int getLastRowNumber() {
        return this.rows.lastKey();
    }

    public DIFRow getRow(int rowNumber) {
        return this.rows.get(rowNumber);
    }

    public void deleteRow(int rowNumber) {
        DIFRow row = this.rows.remove(rowNumber);
        row.cleanUp();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    protected void cleanUp() {
        while (this.getPhysicalNumberOfRows() > 0) {
            int rowNum = this.getLastRowNumber();
            this.deleteRow(rowNum);
        }
    }

    public void write(OutputStream outStream) {
        DIFWriter.writeSheet(this, outStream);
    }
}

