/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jgraph.JGraph;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.GraphTransferHandler;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphDropTargetListener;
import org.jgraph.util.RectUtils;

public class BasicGraphUI
extends GraphUI
implements Serializable {
    public static final boolean DNDPREVIEW = System.getProperty("java.version").compareTo("1.4.0") < 0 || System.getProperty("java.version").compareTo("1.4.0") > 0;
    public static int SCROLLBORDER = 18;
    public static float SCROLLSTEP = 0.05f;
    public static int MAXCELLS = 20;
    public static int MAXHANDLES = 20;
    public static int MAXCLIPCELLS = 20;
    protected Dimension preferredMinSize;
    protected JGraph graph;
    protected GraphLayoutCache graphLayoutCache;
    protected GraphCellEditor cellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected GraphModel graphModel;
    protected GraphSelectionModel graphSelectionModel;
    protected CellHandle handle;
    protected BasicMarqueeHandler marquee;
    protected Component editingComponent;
    protected CellView focus;
    protected CellView lastFocus;
    protected Object editingCell;
    protected boolean editorHasDifferentSize;
    protected Point insertionLocation;
    protected int dropAction = 0;
    protected boolean snapSelectedView = false;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected CellEditorListener cellEditorListener = this.createCellEditorListener();
    protected GraphSelectionListener graphSelectionListener;
    protected GraphModelListener graphModelListener;
    protected GraphLayoutCacheListener graphLayoutCacheListener;
    protected TransferHandler defaultTransferHandler;
    protected GraphDropTargetListener defaultDropTargetListener;
    protected DropTarget dropTarget = null;

    public static ComponentUI createUI(JComponent x) {
        return new BasicGraphUI();
    }

    protected void setModel(GraphModel model) {
        this.cancelEditing(this.graph);
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        this.graphModel = model;
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if (this.graphModel != null) {
            this.updateSize();
        }
    }

    protected void setGraphLayoutCache(GraphLayoutCache cache) {
        this.cancelEditing(this.graph);
        if (this.graphLayoutCache != null && this.graphLayoutCacheListener != null) {
            this.graphLayoutCache.removeGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        this.graphLayoutCache = cache;
        if (this.graphLayoutCache != null && this.graphLayoutCacheListener != null) {
            this.graphLayoutCache.addGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        this.updateSize();
    }

    protected void setMarquee(BasicMarqueeHandler marqueeHandler) {
        this.marquee = marqueeHandler;
    }

    protected void setSelectionModel(GraphSelectionModel newLSM) {
        this.cancelEditing(this.graph);
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
        this.graphSelectionModel = newLSM;
        if (this.graphSelectionModel != null && this.graphSelectionListener != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
        if (this.graph != null) {
            this.graph.repaint();
        }
    }

    @Override
    public CellHandle getHandle() {
        return this.handle;
    }

    @Override
    public int getDropAction() {
        return this.dropAction;
    }

    protected Object getFocusedCell() {
        if (this.focus != null) {
            return this.focus.getCell();
        }
        return null;
    }

    @Override
    public Dimension2D getPreferredSize(JGraph graph, CellView view) {
        if (view != null) {
            boolean focus;
            Component component;
            boolean icon;
            Object cell = view.getCell();
            String valueStr = graph.convertValueToString(cell);
            boolean label = valueStr != null && valueStr.length() > 0;
            boolean bl = icon = GraphConstants.getIcon(view.getAllAttributes()) != null;
            if ((label || icon) && (component = view.getRendererComponent(graph, focus = this.getFocusedCell() == cell && graph.hasFocus(), false, false)) != null) {
                graph.add(component);
                component.validate();
                Dimension d = component.getPreferredSize();
                int inset = 2 * GraphConstants.getInset(view.getAllAttributes());
                d.width += inset;
                d.height += inset;
                return d;
            }
            if (view.getBounds() == null) {
                if (this.graphLayoutCache != null) {
                    view.update(null);
                } else if (graph.getGraphLayoutCache() != null) {
                    view.update(graph.getGraphLayoutCache());
                } else {
                    view.update(null);
                }
            }
            Rectangle2D bounds = view.getBounds();
            return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }
        return null;
    }

    @Override
    public Point getInsertionLocation() {
        return this.insertionLocation;
    }

    @Override
    public void setInsertionLocation(Point p) {
        this.insertionLocation = p;
    }

    @Override
    public void selectCellsForEvent(JGraph graph, Object[] cells, MouseEvent event) {
        this.selectCellsForEvent(cells, event);
    }

    public void selectCellsForEvent(Object[] cells, MouseEvent event) {
        if (cells == null || !this.graph.isSelectionEnabled()) {
            return;
        }
        if (this.isToggleSelectionEvent(event)) {
            for (int i = 0; i < cells.length; ++i) {
                this.toggleSelectionCellForEvent(cells[i], event);
            }
        } else if (this.isAddToSelectionEvent(event)) {
            this.graph.addSelectionCells(cells);
        } else {
            this.graph.setSelectionCells(cells);
        }
    }

    public void selectCellForEvent(Object cell, MouseEvent event) {
        if (this.graph.isSelectionEnabled()) {
            if (this.isToggleSelectionEvent(event)) {
                this.toggleSelectionCellForEvent(cell, event);
            } else if (this.isAddToSelectionEvent(event)) {
                this.graph.addSelectionCell(cell);
            } else {
                this.graph.setSelectionCell(cell);
            }
        }
    }

    protected void toggleSelectionCellForEvent(Object cell, MouseEvent event) {
        if (this.graph.isCellSelected(cell)) {
            this.graph.removeSelectionCell(cell);
        } else {
            this.graph.addSelectionCell(cell);
        }
    }

    public boolean isAddToSelectionEvent(MouseEvent e) {
        return e.isShiftDown();
    }

    public boolean isToggleSelectionEvent(MouseEvent e) {
        switch (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
            case 2: {
                return e.isControlDown();
            }
            case 8: {
                return e.isAltDown();
            }
            case 4: {
                return e.isMetaDown();
            }
        }
        return false;
    }

    public boolean isForceMarqueeEvent(MouseEvent event) {
        if (this.marquee != null) {
            return this.marquee.isForceMarqueeEvent(event);
        }
        return false;
    }

    public boolean isConstrainedMoveEvent(MouseEvent event) {
        if (event != null) {
            return event.isShiftDown();
        }
        return false;
    }

    @Override
    public boolean isEditing(JGraph graph) {
        return this.editingComponent != null;
    }

    @Override
    public boolean stopEditing(JGraph graph) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    @Override
    public void cancelEditing(JGraph graph) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    @Override
    public void startEditingAtCell(JGraph graph, Object cell) {
        graph.scrollCellToVisible(cell);
        if (cell != null) {
            this.startEditing(cell, null);
        }
    }

    @Override
    public Object getEditingCell(JGraph graph) {
        return this.editingCell;
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            throw new NullPointerException("null component passed to BasicGraphUI.installUI()");
        }
        this.graph = (JGraph)c;
        this.marquee = this.graph.getMarqueeHandler();
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.stopEditingInCompleteEditing = true;
        this.preferredSize = new Dimension();
        this.setGraphLayoutCache(this.graph.getGraphLayoutCache());
        this.setModel(this.graph.getModel());
    }

    protected void completeUIInstall() {
        this.setSelectionModel(this.graph.getSelectionModel());
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.graph.getBackground() == null || this.graph.getBackground() instanceof UIResource) {
            this.graph.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.graph.getFont() == null || this.graph.getFont() instanceof UIResource) {
            try {
                this.graph.setFont(UIManager.getFont("Tree.font"));
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (JGraph.IS_MAC) {
            this.graph.setMarqueeColor(UIManager.getColor("MenuItem.selectionBackground"));
        } else {
            this.graph.setMarqueeColor(UIManager.getColor("Table.gridColor"));
        }
        this.graph.setHandleColor(UIManager.getColor("MenuItem.selectionBackground"));
        this.graph.setLockedHandleColor(UIManager.getColor("MenuItem.background"));
        this.graph.setGridColor(UIManager.getColor("Tree.selectionBackground"));
        this.graph.setOpaque(true);
    }

    protected void installListeners() {
        TransferHandler th = this.graph.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.defaultTransferHandler = this.createTransferHandler();
            try {
                this.graph.setTransferHandler(this.defaultTransferHandler);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (this.graphLayoutCache != null) {
            this.graphLayoutCacheListener = this.createGraphLayoutCacheListener();
            this.graphLayoutCache.addGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        this.dropTarget = this.graph.getDropTarget();
        try {
            if (this.dropTarget != null) {
                this.defaultDropTargetListener = new GraphDropTargetListener();
                this.dropTarget.addDropTargetListener(this.defaultDropTargetListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.graph.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.graph.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.graph.addKeyListener(this.keyListener);
        }
        if ((this.graphModelListener = this.createGraphModelListener()) != null && this.graphModel != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if ((this.graphSelectionListener = this.createGraphSelectionListener()) != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.graph, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.graph, 0, km);
        SwingUtilities.replaceUIActionMap(this.graph, this.createActionMap());
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("Tree.focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("selectPrevious", new GraphIncrementAction(1, "selectPrevious"));
        map.put("selectPreviousChangeLead", new GraphIncrementAction(1, "selectPreviousLead"));
        map.put("selectPreviousExtendSelection", new GraphIncrementAction(1, "selectPreviousExtendSelection"));
        map.put("selectParent", new GraphIncrementAction(4, "selectParent"));
        map.put("selectParentChangeLead", new GraphIncrementAction(4, "selectParentChangeLead"));
        map.put("selectNext", new GraphIncrementAction(3, "selectNext"));
        map.put("selectNextChangeLead", new GraphIncrementAction(3, "selectNextLead"));
        map.put("selectNextExtendSelection", new GraphIncrementAction(3, "selectNextExtendSelection"));
        map.put("selectChild", new GraphIncrementAction(2, "selectChild"));
        map.put("selectChildChangeLead", new GraphIncrementAction(2, "selectChildChangeLead"));
        map.put("cancel", new GraphCancelEditingAction("cancel"));
        map.put("startEditing", new GraphEditAction("startEditing"));
        map.put("selectAll", new GraphSelectAllAction("selectAll", true));
        map.put("clearSelection", new GraphSelectAllAction("clearSelection", false));
        return map;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.graph.add(this.rendererPane);
        }
    }

    protected TransferHandler createTransferHandler() {
        return new GraphTransferHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected GraphSelectionListener createGraphSelectionListener() {
        return new GraphSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected GraphLayoutCacheListener createGraphLayoutCacheListener() {
        return new GraphLayoutCacheHandler();
    }

    protected GraphModelListener createGraphModelListener() {
        return new GraphModelHandler();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.cancelEditing(this.graph);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void completeUIUninstall() {
        this.graphLayoutCache = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.graph = null;
        this.graphModel = null;
        this.graphSelectionModel = null;
        this.graphSelectionListener = null;
    }

    protected void uninstallListeners() {
        TransferHandler th = this.graph.getTransferHandler();
        if (th == this.defaultTransferHandler) {
            this.graph.setTransferHandler(null);
        }
        if (this.graphLayoutCacheListener != null) {
            this.graphLayoutCache.removeGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        if (this.dropTarget != null && this.defaultDropTargetListener != null) {
            this.dropTarget.removeDropTargetListener(this.defaultDropTargetListener);
        }
        if (this.componentListener != null) {
            this.graph.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.graph.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.graph.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.keyListener != null) {
            this.graph.removeKeyListener(this.keyListener);
        }
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.graph, null);
        SwingUtilities.replaceUIInputMap(this.graph, 1, null);
        SwingUtilities.replaceUIInputMap(this.graph, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.graph.remove(this.rendererPane);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.graph != c) {
            throw new InternalError("BasicGraphUI cannot paint " + c.toString() + "; " + this.graph + " was expected.");
        }
        Rectangle2D clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            clipBounds = (Rectangle2D)clipBounds.clone();
        }
        if (this.graph.isDoubleBuffered()) {
            Graphics offGraphics = this.graph.getOffgraphics();
            Image offscreen = this.graph.getOffscreen();
            if (offGraphics == null || offscreen == null) {
                this.drawGraph(g, clipBounds);
                this.paintOverlay(g);
                return;
            }
            if (offscreen instanceof VolatileImage) {
                int volatileContentsLostCount = 0;
                do {
                    offGraphics = this.graph.getOffgraphics();
                    if (++volatileContentsLostCount <= 10) continue;
                    this.graph.setVolatileOffscreen(false);
                } while (((VolatileImage)offscreen).contentsLost());
            }
            g.drawImage(this.graph.getOffscreen(), 0, 0, this.graph);
            if (this.handle != null) {
                this.handle.paint(g);
            }
            if (this.marquee != null) {
                this.marquee.paint(this.graph, g);
            }
            this.paintOverlay(g);
            offGraphics.setClip(null);
        } else {
            this.drawGraph(g, clipBounds);
        }
    }

    protected void paintOverlay(Graphics g) {
    }

    public void drawGraph(Graphics g, Rectangle2D clipBounds) {
        g.setClip(clipBounds);
        Rectangle2D realClipBounds = null;
        if (clipBounds != null) {
            realClipBounds = this.graph.fromScreen(new Rectangle2D.Double(clipBounds.getX(), clipBounds.getY(), clipBounds.getWidth(), clipBounds.getHeight()));
        }
        this.paintBackground(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform at = g2.getTransform();
        if (this.graph.isAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double scale = this.graph.getScale();
        g2.scale(scale, scale);
        this.paintCells(g, realClipBounds);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.graph.isPortsScaled()) {
            g2.setTransform(at);
        }
        this.paintForeground(g);
        g2.setTransform(at);
        if (this.handle != null) {
            this.handle.paint(g);
        }
        if (this.marquee != null) {
            this.marquee.paint(this.graph, g);
        }
        if (this.rendererPane != null) {
            this.rendererPane.removeAll();
        }
    }

    protected void paintCells(Graphics g, Rectangle2D realClipBounds) {
        CellView[] views = this.graphLayoutCache.getRoots();
        for (int i = 0; i < views.length; ++i) {
            Rectangle2D bounds = views[i].getBounds();
            if (bounds == null) continue;
            if (realClipBounds == null) {
                this.paintCell(g, views[i], bounds, false);
                continue;
            }
            if (!bounds.intersects(realClipBounds)) continue;
            this.paintCell(g, views[i], bounds, false);
        }
    }

    @Override
    public void paintCell(Graphics g, CellView view, Rectangle2D bounds, boolean preview) {
        if (view != null && bounds != null) {
            boolean bfocus = view == this.focus;
            boolean sel = this.graph.isCellSelected(view.getCell());
            Component component = view.getRendererComponent(this.graph, sel, bfocus, preview);
            this.rendererPane.paintComponent(g, component, this.graph, (int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight(), true);
        }
        if (!view.isLeaf()) {
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                this.paintCell(g, children[i], children[i].getBounds(), preview);
            }
        }
    }

    protected void paintBackground(Graphics g) {
        Rectangle clip = g.getClipBounds();
        this.paintBackgroundImage(g, clip);
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), g, clip);
        }
    }

    protected void paintBackgroundImage(Graphics g, Rectangle clip) {
        ImageIcon icon;
        Component component = this.graph.getBackgroundComponent();
        if (component != null) {
            this.paintBackgroundComponent(g, component, clip);
        }
        if ((icon = this.graph.getBackgroundImage()) == null) {
            return;
        }
        Image backgroundImage = icon.getImage();
        if (backgroundImage == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = null;
        if (this.graph.isBackgroundScaled()) {
            transform = g2.getTransform();
            g2.scale(this.graph.getScale(), this.graph.getScale());
        }
        g2.drawImage(backgroundImage, 0, 0, this.graph);
        if (transform != null) {
            g2.setTransform(transform);
        }
    }

    protected void paintBackgroundComponent(Graphics g, Component component) {
        try {
            g.setPaintMode();
            Dimension dim = component.getPreferredSize();
            this.rendererPane.paintComponent(g, component, this.graph, 0, 0, (int)dim.getWidth(), (int)dim.getHeight(), true);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    protected void paintBackgroundComponent(Graphics g, Component component, Rectangle clip) {
        try {
            g.setPaintMode();
            Dimension dim = component.getPreferredSize();
            this.rendererPane.paintComponent(g, component, this.graph, 0, 0, (int)dim.getWidth(), (int)dim.getHeight(), true);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    protected void paintGrid(double gs, Graphics g, Rectangle2D clipBounds) {
        if (clipBounds == null) {
            Rectangle graphBounds = this.graph.getBounds();
            clipBounds = new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)graphBounds).getWidth(), ((RectangularShape)graphBounds).getHeight());
        }
        double xl = clipBounds.getX();
        double yt = clipBounds.getY();
        double xr = xl + clipBounds.getWidth();
        double yb = yt + clipBounds.getHeight();
        double sgs = Math.max(2.0, gs * this.graph.getScale());
        int xs = (int)(Math.floor(xl / sgs) * sgs);
        int xe = (int)(Math.ceil(xr / sgs) * sgs);
        int ys = (int)(Math.floor(yt / sgs) * sgs);
        int ye = (int)(Math.ceil(yb / sgs) * sgs);
        g.setColor(this.graph.getGridColor());
        switch (this.graph.getGridMode()) {
            case 1: {
                int cs = sgs > 16.0 ? 2 : (sgs < 8.0 ? 0 : 1);
                for (double x = (double)xs; x <= (double)xe; x += sgs) {
                    for (double y = (double)ys; y <= (double)ye; y += sgs) {
                        int ix = (int)Math.round(x);
                        int iy = (int)Math.round(y);
                        g.drawLine(ix - cs, iy, ix + cs, iy);
                        g.drawLine(ix, iy - cs, ix, iy + cs);
                    }
                }
                break;
            }
            case 2: {
                xe += (int)Math.ceil(sgs);
                ye += (int)Math.ceil(sgs);
                for (double x = (double)xs; x <= (double)xe; x += sgs) {
                    int ix = (int)Math.round(x);
                    g.drawLine(ix, ys, ix, ye);
                }
                for (double y = (double)ys; y <= (double)ye; y += sgs) {
                    int iy = (int)Math.round(y);
                    g.drawLine(xs, iy, xe, iy);
                }
                break;
            }
            default: {
                for (double x = (double)xs; x <= (double)xe; x += sgs) {
                    for (double y = (double)ys; y <= (double)ye; y += sgs) {
                        int ix = (int)Math.round(x);
                        int iy = (int)Math.round(y);
                        g.drawLine(ix, iy, ix, iy);
                    }
                }
            }
        }
    }

    protected void paintForeground(Graphics g) {
        if (this.graph.isPortsVisible() && this.graph.isPortsOnTop()) {
            this.paintPorts(g, this.graphLayoutCache.getPorts());
        }
    }

    @Override
    public void paintPorts(Graphics g, CellView[] ports) {
        if (ports != null) {
            Rectangle r = g.getClipBounds();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i] == null) continue;
                Rectangle2D tmp = ports[i].getBounds();
                Rectangle2D.Double bounds = new Rectangle2D.Double(tmp.getX(), tmp.getY(), tmp.getWidth(), tmp.getHeight());
                Point2D center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                if (!this.graph.isPortsScaled()) {
                    center = this.graph.toScreen(center);
                }
                bounds.setFrame(center.getX() - ((RectangularShape)bounds).getWidth() / 2.0, center.getY() - ((RectangularShape)bounds).getHeight() / 2.0, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
                if (r != null && !bounds.intersects(r)) continue;
                this.paintCell(g, ports[i], bounds, false);
            }
        }
    }

    @Override
    public void updateHandle() {
        if (this.graphLayoutCache != null) {
            Object[] cells = this.graphLayoutCache.getVisibleCells(this.graph.getSelectionCells());
            this.handle = cells != null && cells.length > 0 ? this.createHandle(this.createContext(this.graph, cells)) : null;
        }
    }

    protected GraphContext createContext(JGraph graph, Object[] cells) {
        return new GraphContext(graph, cells);
    }

    public CellHandle createHandle(GraphContext context) {
        if (context != null && !context.isEmpty() && this.graph.isEnabled()) {
            try {
                return new RootHandle(context);
            }
            catch (HeadlessException headlessException) {
            }
            catch (RuntimeException e) {
                throw e;
            }
        }
        return null;
    }

    public void updateSize() {
        this.validCachedPreferredSize = false;
        this.graph.graphDidChange();
        this.updateHandle();
    }

    protected void updateCachedPreferredSize() {
        Insets in;
        Rectangle2D size = AbstractCellView.getBounds(this.graphLayoutCache.getRoots());
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        Point2D.Double psize = new Point2D.Double(size.getX() + size.getWidth(), size.getY() + size.getHeight());
        Dimension d = this.graph.getMinimumSize();
        Point min = d != null ? this.graph.toScreen(new Point(d.width, d.height)) : new Point(0, 0);
        Point2D scaled = this.graph.toScreen(psize);
        this.preferredSize = new Dimension((int)Math.max(((Point2D)min).getX(), scaled.getX()), (int)Math.max(((Point2D)min).getY(), scaled.getY()));
        ImageIcon image = this.graph.getBackgroundImage();
        if (image != null) {
            int height = image.getIconHeight();
            int width = image.getIconWidth();
            Point2D imageSize = this.graph.toScreen(new Point(width, height));
            this.preferredSize = new Dimension((int)Math.max(this.preferredSize.getWidth(), imageSize.getX()), (int)Math.max(this.preferredSize.getHeight(), imageSize.getY()));
        }
        if ((in = this.graph.getInsets()) != null) {
            this.preferredSize.setSize(this.preferredSize.getWidth() + (double)in.left + (double)in.right, this.preferredSize.getHeight() + (double)in.top + (double)in.bottom);
        }
        this.validCachedPreferredSize = true;
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension pSize = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.graph != null) {
            if (pSize != null) {
                return new Dimension(Math.max(pSize.width, this.preferredSize.width), Math.max(pSize.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (pSize != null) {
            return pSize;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (this.graph != null) {
            return this.getPreferredSize(this.graph);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.graph.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageGraph) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component oldComponent = this.editingComponent;
            Object oldCell = this.editingCell;
            GraphCellEditor oldEditor = this.cellEditor;
            boolean requestFocus = this.graph != null && (this.graph.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingCell = null;
            this.editingComponent = null;
            if (messageStop) {
                oldEditor.stopCellEditing();
            } else if (messageCancel) {
                oldEditor.cancelCellEditing();
            }
            this.graph.remove(oldComponent);
            if (requestFocus) {
                this.graph.requestFocus();
            }
            if (messageGraph) {
                Object newValue = oldEditor.getCellEditorValue();
                this.graphLayoutCache.valueForCellChanged(oldCell, newValue);
            }
            this.updateSize();
            if (oldEditor != null && this.cellEditorListener != null) {
                oldEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = null;
        }
    }

    protected boolean startEditing(Object cell, MouseEvent event) {
        this.completeEditing();
        if (this.graph.isCellEditable(cell)) {
            CellView tmp = this.graphLayoutCache.getMapping(cell, false);
            this.cellEditor = tmp.getEditor();
            this.editingComponent = this.cellEditor.getGraphCellEditorComponent(this.graph, cell, this.graph.isCellSelected(cell));
            if (this.cellEditor.isCellEditable(event)) {
                Rectangle2D cellBounds = this.graph.getCellBounds(cell);
                this.editingCell = cell;
                Dimension editorSize = this.editingComponent.getPreferredSize();
                this.graph.add(this.editingComponent);
                Point2D p = this.getEditorLocation(cell, editorSize, this.graph.toScreen(new Point2D.Double(cellBounds.getX(), cellBounds.getY())));
                this.editingComponent.setBounds((int)p.getX(), (int)p.getY(), (int)((Dimension2D)editorSize).getWidth(), (int)((Dimension2D)editorSize).getHeight());
                this.editingCell = cell;
                this.editingComponent.validate();
                if (this.cellEditorListener == null) {
                    this.cellEditorListener = this.createCellEditorListener();
                }
                if (this.cellEditor != null && this.cellEditorListener != null) {
                    this.cellEditor.addCellEditorListener(this.cellEditorListener);
                }
                Rectangle visRect = this.graph.getVisibleRect();
                this.graph.paintImmediately((int)p.getX(), (int)p.getY(), (int)(((RectangularShape)visRect).getWidth() + ((RectangularShape)visRect).getX() - cellBounds.getX()), (int)((Dimension2D)editorSize).getHeight());
                if (this.cellEditor.shouldSelectCell(event) && this.graph.isSelectionEnabled()) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.graph.setSelectionCell(cell);
                    }
                    catch (Exception e) {
                        System.err.println("Editing exception: " + e);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (event instanceof MouseEvent) {
                    Point componentPoint = SwingUtilities.convertPoint(this.graph, new Point(event.getX(), event.getY()), this.editingComponent);
                    Component activeComponent = SwingUtilities.getDeepestComponentAt(this.editingComponent, componentPoint.x, componentPoint.y);
                    if (activeComponent != null) {
                        new MouseInputHandler(this.graph, activeComponent, event);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected Point2D getEditorLocation(Object cell, Dimension2D editorSize, Point2D pt) {
        CellView view = this.graphLayoutCache.getMapping(cell, false);
        if (view instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)view;
            CellViewRenderer renderer = edgeView.getRenderer();
            if (renderer instanceof EdgeRenderer) {
                Point2D tmp = ((EdgeRenderer)renderer).getLabelPosition(edgeView);
                pt = tmp != null ? tmp : AbstractCellView.getCenterPoint(edgeView);
                pt.setLocation(Math.max(0.0, pt.getX() - editorSize.getWidth() / 2.0), Math.max(0.0, pt.getY() - editorSize.getHeight() / 2.0));
            }
            this.graph.toScreen(pt);
        }
        return pt;
    }

    public static void autoscroll(JGraph graph, Point p) {
        Rectangle view = graph.getBounds();
        if (graph.getParent() instanceof JViewport) {
            view = ((JViewport)graph.getParent()).getViewRect();
        }
        if (view.contains(p)) {
            Point target = new Point(p);
            int dx = (int)((float)graph.getWidth() * SCROLLSTEP);
            int dy = (int)((float)graph.getHeight() * SCROLLSTEP);
            if (target.x - view.x < SCROLLBORDER) {
                target.x -= dx;
            }
            if (target.y - view.y < SCROLLBORDER) {
                target.y -= dy;
            }
            if (view.x + view.width - target.x < SCROLLBORDER) {
                target.x += dx;
            }
            if (view.y + view.height - target.y < SCROLLBORDER) {
                target.y += dy;
            }
            graph.scrollPointToVisible(target);
        }
    }

    public boolean isSnapSelectedView() {
        return this.snapSelectedView;
    }

    public void setSnapSelectedView(boolean snapSelectedView) {
        this.snapSelectedView = snapSelectedView;
    }

    public class GraphDropTargetListener
    extends BasicGraphDropTargetListener
    implements Serializable {
        @Override
        protected void saveComponentState(JComponent comp) {
        }

        @Override
        protected void restoreComponentState(JComponent comp) {
            if (BasicGraphUI.this.handle != null) {
                BasicGraphUI.this.handle.mouseDragged(null);
            }
        }

        @Override
        protected void updateInsertionLocation(JComponent comp, Point p) {
            BasicGraphUI.this.setInsertionLocation(p);
            if (BasicGraphUI.this.handle != null) {
                int mod = BasicGraphUI.this.dropAction == 1 ? 2 : 0;
                BasicGraphUI.this.handle.mouseDragged(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            BasicGraphUI.this.dropAction = e.getDropAction();
            super.dragEnter(e);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            BasicGraphUI.this.dropAction = e.getDropAction();
            super.dropActionChanged(e);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component source, Component destination, MouseEvent event) {
            this.source = source;
            this.destination = destination;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            destination.dispatchEvent(SwingUtilities.convertMouseEvent(source, event, destination));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
            this.removeFromSource();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class GraphSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public GraphSelectAllAction(String name, boolean selectAll) {
            this.selectAll = selectAll;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (BasicGraphUI.this.graph != null) {
                if (this.selectAll) {
                    BasicGraphUI.this.graph.setSelectionCells(BasicGraphUI.this.graph.getGraphLayoutCache().getVisibleCells(BasicGraphUI.this.graph.getRoots()));
                } else {
                    BasicGraphUI.this.graph.clearSelection();
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphEditAction
    extends AbstractAction {
        public GraphEditAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.isEnabled() && BasicGraphUI.this.getFocusedCell() instanceof GraphCell) {
                BasicGraphUI.this.graph.startEditingAtCell(BasicGraphUI.this.getFocusedCell());
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphCancelEditingAction
    extends AbstractAction {
        public GraphCancelEditingAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicGraphUI.this.graph != null) {
                BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled() && BasicGraphUI.this.graph.isEditing();
        }
    }

    public class GraphIncrementAction
    extends AbstractAction {
        protected int direction;

        private GraphIncrementAction(int direction, String name) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicGraphUI.this.graph != null) {
                int step = 70;
                Rectangle rect = BasicGraphUI.this.graph.getVisibleRect();
                if (this.direction == 1) {
                    rect.translate(0, -step);
                } else if (this.direction == 2) {
                    rect.translate(step, 0);
                } else if (this.direction == 3) {
                    rect.translate(0, step);
                } else if (this.direction == 4) {
                    rect.translate(-step, 0);
                }
                BasicGraphUI.this.graph.scrollRectToVisible(rect);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == BasicGraphUI.this.graph) {
                String changeName = event.getPropertyName();
                if (changeName.equals("minimumSize")) {
                    BasicGraphUI.this.updateCachedPreferredSize();
                } else if (changeName.equals("model")) {
                    BasicGraphUI.this.setModel((GraphModel)event.getNewValue());
                } else if (changeName.equals("view")) {
                    BasicGraphUI.this.setGraphLayoutCache((GraphLayoutCache)event.getNewValue());
                    BasicGraphUI.this.graph.repaint();
                } else if (changeName.equals("marquee")) {
                    BasicGraphUI.this.setMarquee((BasicMarqueeHandler)event.getNewValue());
                } else if (changeName.equals("transferHandler")) {
                    if (BasicGraphUI.this.dropTarget != null) {
                        BasicGraphUI.this.dropTarget.removeDropTargetListener(BasicGraphUI.this.defaultDropTargetListener);
                    }
                    BasicGraphUI.this.dropTarget = BasicGraphUI.this.graph.getDropTarget();
                    try {
                        if (BasicGraphUI.this.dropTarget != null) {
                            BasicGraphUI.this.dropTarget.addDropTargetListener(BasicGraphUI.this.defaultDropTargetListener);
                        }
                    }
                    catch (TooManyListenersException tooManyListenersException) {}
                } else if (changeName.equals("editable")) {
                    boolean editable = (Boolean)event.getNewValue();
                    if (!editable && BasicGraphUI.this.isEditing(BasicGraphUI.this.graph)) {
                        BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
                    }
                } else if (changeName.equals("selectionModel")) {
                    BasicGraphUI.this.setSelectionModel(BasicGraphUI.this.graph.getSelectionModel());
                } else if (changeName.equals("gridVisible") || changeName.equals("gridSize") || changeName.equals("gridColor") || changeName.equals("handleColor") || changeName.equals("lockedHandleColor") || changeName.equals("handleSize") || changeName.equals("portsVisible") || changeName.equals("antiAliased")) {
                    BasicGraphUI.this.graph.repaint();
                } else if (changeName.equals("scale")) {
                    BasicGraphUI.this.updateSize();
                } else if (changeName.equals("backgroundImage")) {
                    BasicGraphUI.this.updateSize();
                } else if (changeName.equals("font")) {
                    BasicGraphUI.this.completeEditing();
                    BasicGraphUI.this.updateSize();
                } else if (changeName.equals("componentOrientation") && BasicGraphUI.this.graph != null) {
                    BasicGraphUI.this.graph.graphDidChange();
                }
            }
        }
    }

    public class RootHandle
    implements CellHandle,
    Serializable {
        protected transient double _mouseToViewDelta_x = 0.0;
        protected transient double _mouseToViewDelta_y = 0.0;
        protected transient boolean firstDrag = true;
        protected transient CellView[] views;
        protected transient CellView[] contextViews;
        protected transient CellView[] portViews;
        protected transient CellView targetGroup;
        protected transient CellView ignoreTargetGroup;
        protected transient Rectangle2D cachedBounds;
        protected transient Point2D initialLocation;
        protected transient CellHandle[] handles;
        protected transient Point2D start = null;
        protected transient Point2D last;
        protected transient Point2D snapStart;
        protected transient Point2D snapLast;
        protected transient Graphics offgraphics;
        protected boolean isMoving = false;
        protected boolean isDragging = false;
        protected transient CellHandle activeHandle = null;
        protected transient GraphContext context;
        protected boolean isContextVisible = true;
        protected boolean blockPaint = false;
        protected Point2D current;
        protected transient ConnectionSet disconnect = null;

        public RootHandle(GraphContext ctx) {
            this.context = ctx;
            if (!ctx.isEmpty()) {
                Object[] cells;
                this.views = ctx.createTemporaryCellViews();
                Rectangle2D tmpBounds = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(ctx.getCells()));
                if (ctx.getDescendantCount() < MAXCELLS) {
                    this.contextViews = ctx.createTemporaryContextViews();
                    this.initialLocation = BasicGraphUI.this.graph.toScreen(this.getInitialLocation(ctx.getCells()));
                } else {
                    this.cachedBounds = tmpBounds;
                }
                if (this.initialLocation == null && tmpBounds != null) {
                    this.initialLocation = new Point2D.Double(tmpBounds.getX(), tmpBounds.getY());
                }
                if ((cells = ctx.getCells()).length < MAXHANDLES) {
                    this.handles = new CellHandle[this.views.length];
                    for (int i = 0; i < this.views.length; ++i) {
                        this.handles[i] = this.views[i].getHandle(ctx);
                    }
                    this.portViews = ctx.createTemporaryPortViews();
                }
            }
        }

        protected Point2D getInitialLocation(Object[] cells) {
            if (cells != null && cells.length > 0) {
                RectangularShape ret = null;
                for (int i = 0; i < cells.length; ++i) {
                    if (BasicGraphUI.this.graphModel != null && BasicGraphUI.this.graphModel.isEdge(cells[i])) {
                        Point2D pt;
                        CellView cellView = BasicGraphUI.this.graphLayoutCache.getMapping(cells[i], false);
                        if (!(cellView instanceof EdgeView)) continue;
                        EdgeView edgeView = (EdgeView)cellView;
                        if (edgeView.getSource() == null && (pt = edgeView.getPoint(0)) != null) {
                            if (ret == null) {
                                ret = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
                            } else {
                                Rectangle2D.union((Rectangle2D)ret, new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0), (Rectangle2D)ret);
                            }
                        }
                        if (edgeView.getTarget() != null || (pt = edgeView.getPoint(edgeView.getPointCount() - 1)) == null) continue;
                        if (ret == null) {
                            ret = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
                            continue;
                        }
                        Rectangle2D.union((Rectangle2D)ret, new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0), (Rectangle2D)ret);
                        continue;
                    }
                    Rectangle2D r = BasicGraphUI.this.graph.getCellBounds(cells[i]);
                    if (r == null) continue;
                    if (ret == null) {
                        ret = (Rectangle2D)r.clone();
                    }
                    Rectangle2D.union((Rectangle2D)ret, r, (Rectangle2D)ret);
                }
                if (ret != null) {
                    return new Point2D.Double(ret.getX(), ret.getY());
                }
            }
            return null;
        }

        public GraphContext getContext() {
            return this.context;
        }

        @Override
        public void paint(Graphics g) {
            if (this.handles != null && this.handles.length < MAXHANDLES) {
                for (int i = 0; i < this.handles.length; ++i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].paint(g);
                }
            }
            this.blockPaint = true;
            if (!BasicGraphUI.this.graph.isXorEnabled() && this.current != null) {
                double dx = this.current.getX() - this.start.getX();
                double dy = this.current.getY() - this.start.getY();
                if (dx != 0.0 || dy != 0.0) {
                    this.overlay(g);
                }
            } else {
                this.blockPaint = true;
            }
        }

        @Override
        public void overlay(Graphics g) {
            if (this.isDragging && !DNDPREVIEW) {
                return;
            }
            if (this.cachedBounds != null) {
                g.setColor(Color.black);
                g.drawRect((int)this.cachedBounds.getX(), (int)this.cachedBounds.getY(), (int)this.cachedBounds.getWidth() - 2, (int)this.cachedBounds.getHeight() - 2);
            } else {
                int i;
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(BasicGraphUI.this.graph.getScale(), BasicGraphUI.this.graph.getScale());
                if (this.views != null) {
                    for (i = 0; i < this.views.length; ++i) {
                        BasicGraphUI.this.paintCell(g, this.views[i], this.views[i].getBounds(), true);
                    }
                }
                if (this.contextViews != null && this.isContextVisible) {
                    for (i = 0; i < this.contextViews.length; ++i) {
                        BasicGraphUI.this.paintCell(g, this.contextViews[i], this.contextViews[i].getBounds(), true);
                    }
                }
                if (!BasicGraphUI.this.graph.isPortsScaled()) {
                    g2.setTransform(oldTransform);
                }
                if (this.portViews != null && BasicGraphUI.this.graph.isPortsVisible()) {
                    BasicGraphUI.this.paintPorts(g, this.portViews);
                }
                g2.setTransform(oldTransform);
            }
            if (this.targetGroup != null) {
                Rectangle2D b = BasicGraphUI.this.graph.toScreen((Rectangle2D)this.targetGroup.getBounds().clone());
                g.setColor(BasicGraphUI.this.graph.getHandleColor());
                g.fillRect((int)b.getX() - 1, (int)b.getY() - 1, (int)b.getWidth() + 2, (int)b.getHeight() + 2);
                g.setColor(BasicGraphUI.this.graph.getMarqueeColor());
                g.draw3DRect((int)b.getX() - 2, (int)b.getY() - 2, (int)b.getWidth() + 3, (int)b.getHeight() + 3, true);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!event.isConsumed() && this.handles != null) {
                for (int i = this.handles.length - 1; i >= 0 && !event.isConsumed(); --i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].mouseMoved(event);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!event.isConsumed() && BasicGraphUI.this.graph.isMoveable()) {
                Point screenPoint;
                Point2D pt;
                CellView view;
                if (this.handles != null) {
                    for (int i = this.handles.length - 1; i >= 0; --i) {
                        if (this.handles[i] == null) continue;
                        this.handles[i].mousePressed(event);
                        if (!event.isConsumed()) continue;
                        this.activeHandle = this.handles[i];
                        return;
                    }
                }
                if (this.views != null && (view = this.findViewForPoint(pt = BasicGraphUI.this.graph.fromScreen((Point2D)(screenPoint = event.getPoint()).clone()))) != null) {
                    if (BasicGraphUI.this.snapSelectedView) {
                        Rectangle2D bounds = view.getBounds();
                        this.start = BasicGraphUI.this.graph.toScreen(new Point2D.Double(bounds.getX(), bounds.getY()));
                        this.snapStart = BasicGraphUI.this.graph.snap((Point2D)this.start.clone());
                        this._mouseToViewDelta_x = ((Point2D)screenPoint).getX() - this.start.getX();
                        this._mouseToViewDelta_y = ((Point2D)screenPoint).getY() - this.start.getY();
                    } else {
                        this.snapStart = BasicGraphUI.this.graph.snap((Point2D)screenPoint.clone());
                        this._mouseToViewDelta_x = this.snapStart.getX() - ((Point2D)screenPoint).getX();
                        this._mouseToViewDelta_y = this.snapStart.getY() - ((Point2D)screenPoint).getY();
                        this.start = (Point2D)this.snapStart.clone();
                    }
                    this.last = (Point2D)this.start.clone();
                    this.snapLast = (Point2D)this.snapStart.clone();
                    this.isContextVisible = this.contextViews != null && this.contextViews.length < MAXCELLS && (!event.isControlDown() || !BasicGraphUI.this.graph.isCloneable());
                    event.consume();
                }
                if (BasicGraphUI.this.graph.isMoveIntoGroups() || BasicGraphUI.this.graph.isMoveOutOfGroups()) {
                    Object[] cells = this.context.getCells();
                    Object ignoreGroup = BasicGraphUI.this.graph.getModel().getParent(cells[0]);
                    for (int i = 1; i < cells.length; ++i) {
                        Object tmp = BasicGraphUI.this.graph.getModel().getParent(cells[i]);
                        if (ignoreGroup == tmp) continue;
                        ignoreGroup = null;
                        break;
                    }
                    if (ignoreGroup != null) {
                        this.ignoreTargetGroup = BasicGraphUI.this.graph.getGraphLayoutCache().getMapping(ignoreGroup, false);
                    }
                }
            }
        }

        protected CellView findViewForPoint(Point2D pt) {
            double snap = BasicGraphUI.this.graph.getTolerance();
            Rectangle2D.Double r = new Rectangle2D.Double(pt.getX() - snap, pt.getY() - snap, 2.0 * snap, 2.0 * snap);
            for (int i = 0; i < this.views.length; ++i) {
                if (!this.views[i].intersects(BasicGraphUI.this.graph, r)) continue;
                return this.views[i];
            }
            return null;
        }

        protected CellView findUnselectedInnermostGroup(double x, double y) {
            Object[] cells = BasicGraphUI.this.graph.getDescendants(BasicGraphUI.this.graph.getRoots());
            for (int i = cells.length - 1; i >= 0; --i) {
                CellView view = BasicGraphUI.this.graph.getGraphLayoutCache().getMapping(cells[i], false);
                if (view == null || view.isLeaf() || this.context.contains(view.getCell()) || !view.getBounds().contains(x, y)) continue;
                return view;
            }
            return null;
        }

        protected void startDragging(MouseEvent event) {
            this.isDragging = true;
            if (BasicGraphUI.this.graph.isDragEnabled()) {
                int action = event.isControlDown() && BasicGraphUI.this.graph.isCloneable() ? 1 : 2;
                TransferHandler th = BasicGraphUI.this.graph.getTransferHandler();
                BasicGraphUI.this.setInsertionLocation(event.getPoint());
                try {
                    th.exportAsDrag(BasicGraphUI.this.graph, event, action);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Component getFirstOpaqueParent(Component component) {
            if (component != null) {
                for (Component parent = component; parent != null; parent = parent.getParent()) {
                    if (!parent.isOpaque() || parent instanceof JViewport) continue;
                    return parent;
                }
            }
            return component;
        }

        protected void initOffscreen() {
            if (!BasicGraphUI.this.graph.isXorEnabled()) {
                return;
            }
            try {
                this.offgraphics = BasicGraphUI.this.graph.getOffgraphics();
            }
            catch (Exception e) {
                this.offgraphics = null;
            }
            catch (Error e) {
                this.offgraphics = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            boolean constrained = BasicGraphUI.this.isConstrainedMoveEvent(event);
            boolean spread = false;
            Rectangle2D dirty = null;
            if (this.firstDrag && BasicGraphUI.this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            if (event != null && !event.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseDragged(event);
                } else if (this.start != null) {
                    Point2D snapCurrent;
                    Graphics g = this.offgraphics != null ? this.offgraphics : BasicGraphUI.this.graph.getGraphics();
                    Point ep = event.getPoint();
                    Point2D.Double point = new Point2D.Double(ep.getX() - this._mouseToViewDelta_x, ep.getY() - this._mouseToViewDelta_y);
                    this.current = snapCurrent = BasicGraphUI.this.graph.snap(point);
                    int thresh = BasicGraphUI.this.graph.getMinimumMove();
                    double dx = this.current.getX() - this.start.getX();
                    double dy = this.current.getY() - this.start.getY();
                    if (this.isMoving || Math.abs(dx) > (double)thresh || Math.abs(dy) > (double)thresh) {
                        double totDy;
                        double totDx;
                        Point2D constrainedPosition;
                        boolean overlayed = false;
                        this.isMoving = true;
                        if (this.disconnect == null && BasicGraphUI.this.graph.isDisconnectOnMove()) {
                            this.disconnect = this.context.disconnect(BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views));
                        }
                        if ((constrainedPosition = this.constrainDrag(event, totDx = this.current.getX() - this.start.getX(), totDy = this.current.getY() - this.start.getY(), dx = this.current.getX() - this.last.getX(), dy = this.current.getY() - this.last.getY())) != null) {
                            dx = constrainedPosition.getX();
                            dy = constrainedPosition.getY();
                        }
                        double scale = BasicGraphUI.this.graph.getScale();
                        dx /= scale;
                        dy /= scale;
                        if (BasicGraphUI.this.graph.isDragEnabled() && !this.isDragging) {
                            this.startDragging(event);
                        }
                        if (dx != 0.0 || dy != 0.0) {
                            Rectangle2D ignoredRegion;
                            if (this.offgraphics != null || !BasicGraphUI.this.graph.isXorEnabled()) {
                                dirty = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views));
                                Rectangle2D t = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (t != null) {
                                    dirty.add(t);
                                }
                            }
                            if (BasicGraphUI.this.graph.isXorEnabled()) {
                                g.setColor(BasicGraphUI.this.graph.getForeground());
                                g.setXORMode(BasicGraphUI.this.graph.getBackground().darker());
                            }
                            if (!(this.snapLast.equals(this.snapStart) || this.offgraphics == null && this.blockPaint)) {
                                if (BasicGraphUI.this.graph.isXorEnabled()) {
                                    this.overlay(g);
                                }
                                overlayed = true;
                            }
                            this.isContextVisible = (!event.isControlDown() || !BasicGraphUI.this.graph.isCloneable()) && this.contextViews != null && this.contextViews.length < MAXCELLS;
                            this.blockPaint = false;
                            if (constrained && this.cachedBounds == null) {
                                CellView[] all = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                                for (int i = 0; i < all.length; ++i) {
                                    CellView orig = BasicGraphUI.this.graphLayoutCache.getMapping(all[i].getCell(), false);
                                    AttributeMap attr = orig.getAllAttributes();
                                    all[i].changeAttributes(BasicGraphUI.this.graph.getGraphLayoutCache(), (AttributeMap)attr.clone());
                                    all[i].refresh(BasicGraphUI.this.graph.getGraphLayoutCache(), this.context, false);
                                }
                            }
                            if (this.cachedBounds != null) {
                                if (dirty != null) {
                                    dirty.add(this.cachedBounds);
                                }
                                this.cachedBounds.setFrame(this.cachedBounds.getX() + dx * scale, this.cachedBounds.getY() + dy * scale, this.cachedBounds.getWidth(), this.cachedBounds.getHeight());
                                if (dirty != null) {
                                    dirty.add(this.cachedBounds);
                                }
                            } else {
                                GraphLayoutCache.translateViews(this.views, dx, dy);
                                if (this.views != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.views);
                                }
                                if (this.contextViews != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.contextViews);
                                }
                            }
                            if (BasicGraphUI.this.graph.isAutoResizeGraph() && (event.getX() > BasicGraphUI.this.graph.getWidth() - SCROLLBORDER || event.getY() > BasicGraphUI.this.graph.getHeight() - SCROLLBORDER)) {
                                int SPREADSTEP = 25;
                                Rectangle view = null;
                                if (BasicGraphUI.this.graph.getParent() instanceof JViewport) {
                                    view = ((JViewport)BasicGraphUI.this.graph.getParent()).getViewRect();
                                }
                                if (view != null && view.contains(event.getPoint())) {
                                    if (view.x + view.width - event.getPoint().x < SCROLLBORDER) {
                                        BasicGraphUI.this.preferredSize.width = Math.max(BasicGraphUI.this.preferredSize.width, (int)view.getWidth()) + SPREADSTEP;
                                        spread = true;
                                    }
                                    if (view.y + view.height - event.getPoint().y < SCROLLBORDER) {
                                        BasicGraphUI.this.preferredSize.height = Math.max(BasicGraphUI.this.preferredSize.height, (int)view.getHeight()) + SPREADSTEP;
                                        spread = true;
                                    }
                                    if (spread) {
                                        BasicGraphUI.this.graph.revalidate();
                                        BasicGraphUI.autoscroll(BasicGraphUI.this.graph, event.getPoint());
                                        if (BasicGraphUI.this.graph.isDoubleBuffered()) {
                                            this.initOffscreen();
                                        }
                                    }
                                }
                            }
                            Rectangle2D rectangle2D = ignoredRegion = this.ignoreTargetGroup != null ? (Rectangle2D)this.ignoreTargetGroup.getBounds().clone() : null;
                            if (this.targetGroup != null) {
                                Rectangle2D tmp = BasicGraphUI.this.graph.toScreen((Rectangle2D)this.targetGroup.getBounds().clone());
                                if (dirty != null) {
                                    dirty.add(tmp);
                                } else {
                                    dirty = tmp;
                                }
                            }
                            this.targetGroup = null;
                            if (BasicGraphUI.this.graph.isMoveIntoGroups() && (ignoredRegion == null || !ignoredRegion.intersects(AbstractCellView.getBounds(this.views)))) {
                                CellView cellView = this.targetGroup = event.isControlDown() ? null : this.findUnselectedInnermostGroup(snapCurrent.getX() / scale, snapCurrent.getY() / scale);
                                if (this.targetGroup == this.ignoreTargetGroup) {
                                    this.targetGroup = null;
                                }
                            }
                            if (!(snapCurrent.equals(this.snapStart) || this.offgraphics == null && this.blockPaint || spread)) {
                                if (BasicGraphUI.this.graph.isXorEnabled()) {
                                    this.overlay(g);
                                }
                                overlayed = true;
                            }
                            if (constrained) {
                                this.last = (Point2D)this.start.clone();
                            }
                            this.last.setLocation(this.last.getX() + dx * scale, this.last.getY() + dy * scale);
                            this.snapLast = snapCurrent;
                            if (overlayed && (this.offgraphics != null || !BasicGraphUI.this.graph.isXorEnabled())) {
                                if (dirty == null) {
                                    dirty = new Rectangle2D.Double();
                                }
                                dirty.add(BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views)));
                                Rectangle2D t = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (t != null) {
                                    dirty.add(t);
                                }
                                int border = PortView.SIZE + 4;
                                if (BasicGraphUI.this.graph.isPortsScaled()) {
                                    border = (int)(BasicGraphUI.this.graph.getScale() * (double)border);
                                }
                                int border2 = border / 2;
                                dirty.setFrame(dirty.getX() - (double)border2, dirty.getY() - (double)border2, dirty.getWidth() + (double)border, dirty.getHeight() + (double)border);
                                double sx1 = Math.max(0.0, dirty.getX());
                                double sy1 = Math.max(0.0, dirty.getY());
                                double sx2 = sx1 + dirty.getWidth();
                                double sy2 = sy1 + dirty.getHeight();
                                if (this.isDragging && !DNDPREVIEW) {
                                    return;
                                }
                                if (this.offgraphics != null) {
                                    BasicGraphUI.this.graph.drawImage((int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2);
                                } else {
                                    BasicGraphUI.this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth() + 1, (int)dirty.getHeight() + 1);
                                }
                            }
                        }
                    }
                }
            } else if (event == null) {
                BasicGraphUI.this.graph.repaint();
            }
        }

        protected Point2D constrainDrag(MouseEvent event, double totDx, double totDy, double dx, double dy) {
            boolean constrained = BasicGraphUI.this.isConstrainedMoveEvent(event);
            if (constrained && this.cachedBounds == null) {
                if (Math.abs(totDx) < Math.abs(totDy)) {
                    dx = 0.0;
                    dy = totDy;
                } else {
                    dx = totDx;
                    dy = 0.0;
                }
            } else {
                if (!BasicGraphUI.this.graph.isMoveBelowZero() && this.last != null && this.initialLocation != null && this.start != null) {
                    if (this.initialLocation.getX() + totDx < 0.0) {
                        dx = this.start.getX() - this.last.getX() - this.initialLocation.getX();
                    }
                    if (this.initialLocation.getY() + totDy < 0.0) {
                        dy = this.start.getY() - this.last.getY() - this.initialLocation.getY();
                    }
                }
                if (!BasicGraphUI.this.graph.isMoveBeyondGraphBounds() && this.last != null && this.initialLocation != null && this.start != null) {
                    Rectangle graphBounds = BasicGraphUI.this.graph.getBounds();
                    Rectangle2D viewBounds = AbstractCellView.getBounds(this.views);
                    if (this.initialLocation.getX() + totDx + viewBounds.getWidth() > ((RectangularShape)graphBounds).getWidth()) {
                        dx = 0.0;
                    }
                    if (this.initialLocation.getY() + totDy + viewBounds.getHeight() > ((RectangularShape)graphBounds).getHeight()) {
                        dy = 0.0;
                    }
                }
            }
            return new Point2D.Double(dx, dy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent event) {
            try {
                if (event != null && !event.isConsumed()) {
                    if (this.activeHandle != null) {
                        this.activeHandle.mouseReleased(event);
                        this.activeHandle = null;
                    } else if (this.isMoving && !event.getPoint().equals(this.start)) {
                        if (this.cachedBounds != null) {
                            Point ep = event.getPoint();
                            Point2D.Double point = new Point2D.Double(ep.getX() - this._mouseToViewDelta_x, ep.getY() - this._mouseToViewDelta_y);
                            Point2D snapCurrent = BasicGraphUI.this.graph.snap(point);
                            double dx = snapCurrent.getX() - this.start.getX();
                            double dy = snapCurrent.getY() - this.start.getY();
                            if (!BasicGraphUI.this.graph.isMoveBelowZero() && this.initialLocation.getX() + dx < 0.0) {
                                dx = -1.0 * this.initialLocation.getX();
                            }
                            if (!BasicGraphUI.this.graph.isMoveBelowZero() && this.initialLocation.getY() + dy < 0.0) {
                                dy = -1.0 * this.initialLocation.getY();
                            }
                            Point2D tmp = BasicGraphUI.this.graph.fromScreen(new Point2D.Double(dx, dy));
                            GraphLayoutCache.translateViews(this.views, tmp.getX(), tmp.getY());
                        }
                        Object[] all = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                        Map attributes = GraphConstants.createAttributes(all, null);
                        if (event.isControlDown() && BasicGraphUI.this.graph.isCloneable()) {
                            Object[] cells = BasicGraphUI.this.graph.getDescendants(BasicGraphUI.this.graph.order(this.context.getCells()));
                            Map hiddenMapping = BasicGraphUI.this.graphLayoutCache.getHiddenMapping();
                            for (int i = 0; i < cells.length; ++i) {
                                CellView view;
                                Object witness = attributes.get(cells[i]);
                                if (witness != null || (view = (CellView)hiddenMapping.get(cells[i])) == null || BasicGraphUI.this.graphModel.isPort(view.getCell())) continue;
                                AttributeMap attrs = (AttributeMap)view.getAllAttributes().clone();
                                attributes.put(cells[i], attrs.clone());
                            }
                            ConnectionSet cs = ConnectionSet.create(BasicGraphUI.this.graphModel, cells, false);
                            ParentMap pm = ParentMap.create(BasicGraphUI.this.graphModel, cells, false, true);
                            cells = BasicGraphUI.this.graphLayoutCache.insertClones(cells, BasicGraphUI.this.graph.cloneCells(cells), attributes, cs, pm, 0.0, 0.0);
                        } else if (BasicGraphUI.this.graph.isMoveable()) {
                            ParentMap pm = null;
                            if (this.targetGroup != null) {
                                pm = new ParentMap(this.context.getCells(), this.targetGroup.getCell());
                            } else if (BasicGraphUI.this.graph.isMoveOutOfGroups() && this.ignoreTargetGroup != null && !this.ignoreTargetGroup.getBounds().intersects(AbstractCellView.getBounds(this.views))) {
                                pm = new ParentMap(this.context.getCells(), null);
                            }
                            BasicGraphUI.this.graph.getGraphLayoutCache().edit(attributes, this.disconnect, pm, null);
                        }
                        event.consume();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.ignoreTargetGroup = null;
                this.targetGroup = null;
                this.isDragging = false;
                this.disconnect = null;
                this.firstDrag = true;
                this.current = null;
                this.start = null;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected CellView cell;
        protected Object handler;
        protected transient Cursor previousCursor = null;

        @Override
        public void mousePressed(MouseEvent e) {
            this.handler = null;
            if (!e.isConsumed() && BasicGraphUI.this.graph.isEnabled()) {
                boolean isEditable;
                BasicGraphUI.this.graph.requestFocus();
                int s = BasicGraphUI.this.graph.getTolerance();
                Rectangle2D r = BasicGraphUI.this.graph.fromScreen(new Rectangle2D.Double(e.getX() - s, e.getY() - s, 2 * s, 2 * s));
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.intersects(BasicGraphUI.this.graph, r) ? BasicGraphUI.this.focus : null;
                this.cell = BasicGraphUI.this.graph.getNextSelectableViewAt(BasicGraphUI.this.focus, e.getX(), e.getY());
                if (BasicGraphUI.this.focus == null) {
                    BasicGraphUI.this.focus = this.cell;
                }
                BasicGraphUI.this.completeEditing();
                boolean isForceMarquee = BasicGraphUI.this.isForceMarqueeEvent(e);
                boolean bl = isEditable = BasicGraphUI.this.graph.isGroupsEditable() || BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.isLeaf();
                if (!isForceMarquee) {
                    if (e.getClickCount() == BasicGraphUI.this.graph.getEditClickCount() && BasicGraphUI.this.focus != null && isEditable && BasicGraphUI.this.focus.getParentView() == null && BasicGraphUI.this.graph.isCellEditable(BasicGraphUI.this.focus.getCell()) && this.handleEditTrigger(this.cell.getCell(), e)) {
                        e.consume();
                        this.cell = null;
                    } else if (!BasicGraphUI.this.isToggleSelectionEvent(e)) {
                        if (BasicGraphUI.this.handle != null) {
                            BasicGraphUI.this.handle.mousePressed(e);
                            this.handler = BasicGraphUI.this.handle;
                        }
                        if (!e.isConsumed() && this.cell != null && !BasicGraphUI.this.graph.isCellSelected(this.cell.getCell())) {
                            BasicGraphUI.this.selectCellForEvent(this.cell.getCell(), e);
                            BasicGraphUI.this.focus = this.cell;
                            if (BasicGraphUI.this.handle != null) {
                                BasicGraphUI.this.handle.mousePressed(e);
                                this.handler = BasicGraphUI.this.handle;
                            }
                            e.consume();
                            this.cell = null;
                        }
                    }
                }
                if (!(e.isConsumed() || BasicGraphUI.this.marquee == null || BasicGraphUI.this.isToggleSelectionEvent(e) && BasicGraphUI.this.focus != null && !isForceMarquee)) {
                    BasicGraphUI.this.marquee.mousePressed(e);
                    this.handler = BasicGraphUI.this.marquee;
                }
            }
        }

        protected boolean handleEditTrigger(Object cell, MouseEvent e) {
            BasicGraphUI.this.graph.scrollCellToVisible(cell);
            if (cell != null) {
                BasicGraphUI.this.startEditing(cell, e);
            }
            return BasicGraphUI.this.graph.isEditing();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BasicGraphUI.autoscroll(BasicGraphUI.this.graph, e.getPoint());
            if (BasicGraphUI.this.graph.isEnabled()) {
                if (this.handler != null && this.handler == BasicGraphUI.this.marquee) {
                    BasicGraphUI.this.marquee.mouseDragged(e);
                } else if (this.handler == null && !BasicGraphUI.this.isEditing(BasicGraphUI.this.graph) && BasicGraphUI.this.focus != null) {
                    if (!BasicGraphUI.this.graph.isCellSelected(BasicGraphUI.this.focus.getCell())) {
                        BasicGraphUI.this.selectCellForEvent(BasicGraphUI.this.focus.getCell(), e);
                        this.cell = null;
                    }
                    if (BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mousePressed(e);
                    }
                    this.handler = BasicGraphUI.this.handle;
                }
                if (BasicGraphUI.this.handle != null && this.handler == BasicGraphUI.this.handle) {
                    BasicGraphUI.this.handle.mouseDragged(e);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.previousCursor == null) {
                this.previousCursor = BasicGraphUI.this.graph.getCursor();
            }
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled()) {
                if (BasicGraphUI.this.marquee != null) {
                    BasicGraphUI.this.marquee.mouseMoved(e);
                }
                if (BasicGraphUI.this.handle != null) {
                    BasicGraphUI.this.handle.mouseMoved(e);
                }
                if (!e.isConsumed() && this.previousCursor != null) {
                    Cursor currentCursor = BasicGraphUI.this.graph.getCursor();
                    if (currentCursor != this.previousCursor) {
                        BasicGraphUI.this.graph.setCursor(this.previousCursor);
                    }
                    this.previousCursor = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                if (e != null && !e.isConsumed() && BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled()) {
                    if (this.handler == BasicGraphUI.this.marquee && BasicGraphUI.this.marquee != null) {
                        BasicGraphUI.this.marquee.mouseReleased(e);
                    } else if (this.handler == BasicGraphUI.this.handle && BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mouseReleased(e);
                    }
                    if (this.isDescendant(this.cell, BasicGraphUI.this.focus) && e.getModifiers() != 0) {
                        this.cell = BasicGraphUI.this.focus;
                    }
                    if (!e.isConsumed() && this.cell != null) {
                        Object tmp = this.cell.getCell();
                        boolean wasSelected = BasicGraphUI.this.graph.isCellSelected(tmp);
                        if (!e.isPopupTrigger() || !wasSelected) {
                            BasicGraphUI.this.selectCellForEvent(tmp, e);
                            BasicGraphUI.this.focus = this.cell;
                            this.postProcessSelection(e, tmp, wasSelected);
                        }
                    }
                }
            }
            finally {
                this.handler = null;
                this.cell = null;
            }
        }

        protected void postProcessSelection(MouseEvent e, Object cell, boolean wasSelected) {
            if (wasSelected && BasicGraphUI.this.graph.isCellSelected(cell) && e.getModifiers() != 0) {
                Object parent = cell;
                Object nextParent = null;
                while ((nextParent = BasicGraphUI.this.graphModel.getParent(parent)) != null && BasicGraphUI.this.graphLayoutCache.isVisible(nextParent)) {
                    parent = nextParent;
                }
                BasicGraphUI.this.selectCellForEvent(parent, e);
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(parent, false);
            }
        }

        protected boolean isDescendant(CellView parentView, CellView childView) {
            Object child;
            if (parentView == null || childView == null) {
                return false;
            }
            Object parent = parentView.getCell();
            Object ancestor = child = childView.getCell();
            do {
                if (ancestor != parent) continue;
                return true;
            } while ((ancestor = BasicGraphUI.this.graphModel.getParent(ancestor)) != null);
            return false;
        }
    }

    public class KeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        @Override
        public void keyPressed(KeyEvent e) {
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.hasFocus() && BasicGraphUI.this.graph.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                if (BasicGraphUI.this.graph.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener listener = BasicGraphUI.this.graph.getActionForKeyStroke(keyStroke);
                    this.repeatKeyAction = listener instanceof Action ? (Action)listener : null;
                } else {
                    this.repeatKeyAction = null;
                    if (keyStroke.getKeyCode() == 27) {
                        if (BasicGraphUI.this.marquee != null) {
                            BasicGraphUI.this.marquee.mouseReleased(null);
                        }
                        if (BasicGraphUI.this.mouseListener != null) {
                            BasicGraphUI.this.mouseListener.mouseReleased(null);
                        }
                        BasicGraphUI.this.updateHandle();
                        BasicGraphUI.this.graph.repaint();
                    }
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(BasicGraphUI.this.graph, 1001, ""));
                    e.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.isKeyDown = false;
        }
    }

    public class CellEditorHandler
    implements CellEditorListener,
    Serializable {
        @Override
        public void editingStopped(ChangeEvent e) {
            BasicGraphUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            BasicGraphUI.this.completeEditing(false, false, false);
        }
    }

    public class GraphSelectionHandler
    implements GraphSelectionListener,
    Serializable {
        @Override
        public void valueChanged(GraphSelectionEvent event) {
            BasicGraphUI.this.updateHandle();
            Object[] cells = event.getCells();
            if (cells != null && cells.length <= MAXCLIPCELLS) {
                Rectangle2D r = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(cells));
                if (BasicGraphUI.this.focus != null) {
                    if (r != null) {
                        Rectangle2D.union(r, BasicGraphUI.this.focus.getBounds(), r);
                    } else {
                        r = BasicGraphUI.this.focus.getBounds();
                    }
                }
                if (BasicGraphUI.this.lastFocus != null) {
                    if (r != null) {
                        Rectangle2D.union(r, BasicGraphUI.this.lastFocus.getBounds(), r);
                    } else {
                        r = BasicGraphUI.this.lastFocus.getBounds();
                    }
                }
                if (r != null) {
                    Rectangle2D unscaledDirty = BasicGraphUI.this.graph.fromScreen((Rectangle2D)r.clone());
                    BasicGraphUI.this.graph.addOffscreenDirty(unscaledDirty);
                    int hsize = BasicGraphUI.this.graph.getHandleSize() + 1;
                    BasicGraphUI.this.updateHandle();
                    Rectangle dirtyRegion = new Rectangle((int)(r.getX() - (double)hsize), (int)(r.getY() - (double)hsize), (int)(r.getWidth() + (double)(2 * hsize)), (int)(r.getHeight() + (double)(2 * hsize)));
                    BasicGraphUI.this.graph.repaint(dirtyRegion);
                }
            } else {
                Rectangle dirtyRegion = new Rectangle(BasicGraphUI.this.graph.getSize());
                BasicGraphUI.this.graph.addOffscreenDirty(dirtyRegion);
                BasicGraphUI.this.graph.repaint();
            }
        }
    }

    public class GraphLayoutCacheHandler
    implements GraphLayoutCacheListener,
    Serializable {
        @Override
        public void graphLayoutCacheChanged(GraphLayoutCacheEvent e) {
            Object[] roots;
            Object[] changed = e.getChange().getChanged();
            if (changed != null && changed.length > 0) {
                for (int i = 0; i < changed.length; ++i) {
                    BasicGraphUI.this.graph.updateAutoSize(BasicGraphUI.this.graphLayoutCache.getMapping(changed[i], false));
                }
            }
            Rectangle2D oldDirtyRegion = e.getChange().getDirtyRegion();
            BasicGraphUI.this.graph.addOffscreenDirty(oldDirtyRegion);
            Rectangle2D newDirtyRegion = BasicGraphUI.this.graph.getClipRectangle(e.getChange());
            BasicGraphUI.this.graph.addOffscreenDirty(newDirtyRegion);
            Object[] inserted = e.getChange().getInserted();
            if (inserted != null && inserted.length > 0 && BasicGraphUI.this.graphLayoutCache.isSelectsLocalInsertedCells() && (!BasicGraphUI.this.graphLayoutCache.isSelectsAllInsertedCells() || BasicGraphUI.this.graphLayoutCache.isPartial()) && BasicGraphUI.this.graph.isEnabled() && (roots = DefaultGraphModel.getRoots(BasicGraphUI.this.graphModel, inserted)) != null && roots.length > 0) {
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(roots[0], false);
                BasicGraphUI.this.graph.setSelectionCells(roots);
            }
            BasicGraphUI.this.updateSize();
        }
    }

    public class GraphModelHandler
    implements GraphModelListener,
    Serializable {
        @Override
        public void graphChanged(GraphModelEvent e) {
            Object[] roots;
            int i;
            Object[] removed = e.getChange().getRemoved();
            if (removed != null && removed.length > 0) {
                if (BasicGraphUI.this.focus != null) {
                    Object focusedCell = BasicGraphUI.this.focus.getCell();
                    for (int i2 = 0; i2 < removed.length; ++i2) {
                        if (removed[i2] != focusedCell) continue;
                        BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                        BasicGraphUI.this.focus = null;
                        break;
                    }
                }
                BasicGraphUI.this.graph.getSelectionModel().removeSelectionCells(removed);
            }
            Rectangle2D oldDirty = null;
            Rectangle2D dirtyRegion = e.getChange().getDirtyRegion();
            if (dirtyRegion == null) {
                oldDirty = BasicGraphUI.this.graph.getClipRectangle(e.getChange());
            }
            if (BasicGraphUI.this.graphLayoutCache != null) {
                BasicGraphUI.this.graphLayoutCache.graphChanged(e.getChange());
            }
            Object[] inserted = e.getChange().getInserted();
            Object[] changed = e.getChange().getChanged();
            if (inserted != null && inserted.length > 0) {
                for (i = 0; i < inserted.length; ++i) {
                    BasicGraphUI.this.graph.updateAutoSize(BasicGraphUI.this.graphLayoutCache.getMapping(inserted[i], false));
                }
            }
            if (changed != null && changed.length > 0) {
                for (i = 0; i < changed.length; ++i) {
                    BasicGraphUI.this.graph.updateAutoSize(BasicGraphUI.this.graphLayoutCache.getMapping(changed[i], false));
                }
            }
            if (dirtyRegion == null) {
                Rectangle2D newDirtyRegion = BasicGraphUI.this.graph.getClipRectangle(e.getChange());
                dirtyRegion = RectUtils.union(oldDirty, newDirtyRegion);
                e.getChange().setDirtyRegion(dirtyRegion);
            }
            if (dirtyRegion != null) {
                BasicGraphUI.this.graph.addOffscreenDirty(dirtyRegion);
            }
            if (!BasicGraphUI.this.graphLayoutCache.isPartial() && BasicGraphUI.this.graphLayoutCache.isSelectsAllInsertedCells() && BasicGraphUI.this.graph.isEnabled() && (roots = DefaultGraphModel.getRoots(BasicGraphUI.this.graphModel, inserted)) != null && roots.length > 0) {
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(roots[0], false);
                BasicGraphUI.this.graph.setSelectionCells(roots);
            }
            BasicGraphUI.this.updateSize();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = this.getScrollPane();
                if (scrollPane == null) {
                    BasicGraphUI.this.updateSize();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicGraphUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container c;
            for (c = BasicGraphUI.this.graph.getParent(); c != null && !(c instanceof JScrollPane); c = c.getParent()) {
            }
            if (c instanceof JScrollPane) {
                return (JScrollPane)c;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicGraphUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }
}

