/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient PortView view;
    protected Color graphBackground = Color.white;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean xorEnabled;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    @Override
    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof PortView && graph != null) {
            this.graphBackground = graph.getBackground();
            this.view = (PortView)view;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.xorEnabled = graph.isXorEnabled();
            return this;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.xorEnabled) {
            g.setColor(this.graphBackground);
            g.setXORMode(this.graphBackground);
        }
        super.paint(g);
        if (this.preview) {
            g.fill3DRect(0, 0, d.width, d.height, true);
        } else {
            g.fillRect(0, 0, d.width, d.height);
        }
        boolean offset = GraphConstants.getOffset(this.view.getAllAttributes()) != null;
        g.setColor(this.getForeground());
        if (!offset) {
            g.fillRect(1, 1, d.width - 2, d.height - 2);
        } else if (!this.preview) {
            g.drawRect(1, 1, d.width - 3, d.height - 3);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

