/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.graph.GraphLayoutCache;

public class GraphUndoManager
extends UndoManager {
    public synchronized boolean canUndo(Object source) {
        if (this.isInProgress()) {
            UndoableEdit edit = this.editToBeUndone(source);
            return edit != null && edit.canUndo();
        }
        return super.canUndo();
    }

    public synchronized boolean canRedo(Object source) {
        if (this.isInProgress()) {
            UndoableEdit edit = this.editToBeRedone(source);
            return edit != null && edit.canRedo();
        }
        return super.canRedo();
    }

    public void undo(Object source) {
        if (source == null || !this.isInProgress()) {
            super.undo();
        } else {
            UndoableEdit edit = this.editToBeUndone(source);
            if (edit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(edit);
        }
    }

    protected UndoableEdit editToBeUndone(Object source) {
        UndoableEdit edit = null;
        Object src = null;
        do {
            if ((edit = this.nextEditToBeUndone(edit)) instanceof GraphLayoutCacheEvent.GraphLayoutCacheChange) {
                src = ((GraphLayoutCacheEvent.GraphLayoutCacheChange)((Object)edit)).getSource();
            }
            if (src instanceof GraphLayoutCache) continue;
            src = null;
        } while (edit != null && src != null && src != source);
        return edit;
    }

    protected UndoableEdit nextEditToBeUndone(UndoableEdit current) {
        if (current == null) {
            return this.editToBeUndone();
        }
        int index = this.edits.indexOf(current) - 1;
        if (index >= 0) {
            return (UndoableEdit)this.edits.get(index);
        }
        return null;
    }

    public void redo(Object source) {
        if (source == null || !this.isInProgress()) {
            super.redo();
        } else {
            UndoableEdit edit = this.editToBeRedone(source);
            if (edit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(edit);
        }
    }

    protected UndoableEdit editToBeRedone(Object source) {
        UndoableEdit edit = this.nextEditToBeRedone(null);
        UndoableEdit last = null;
        Object src = null;
        do {
            last = edit;
            if ((edit = this.nextEditToBeRedone(edit)) instanceof GraphLayoutCacheEvent.GraphLayoutCacheChange) {
                src = ((GraphLayoutCacheEvent.GraphLayoutCacheChange)((Object)edit)).getSource();
            }
            if (src instanceof GraphLayoutCache) continue;
            src = null;
        } while (edit != null && src != null && src != source);
        return last;
    }

    protected UndoableEdit nextEditToBeRedone(UndoableEdit current) {
        if (current == null) {
            return this.editToBeRedone();
        }
        int index = this.edits.indexOf(current) + 1;
        if (index < this.edits.size()) {
            return (UndoableEdit)this.edits.get(index);
        }
        return null;
    }
}

