/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphCell
extends DefaultMutableTreeNode
implements GraphCell,
Cloneable {
    protected AttributeMap attributes = null;

    public DefaultGraphCell() {
        this(null);
    }

    public DefaultGraphCell(Object userObject) {
        this(userObject, null);
    }

    public DefaultGraphCell(Object userObject, AttributeMap storageMap) {
        this(userObject, storageMap, null);
    }

    public DefaultGraphCell(Object userObject, AttributeMap storageMap, MutableTreeNode[] children) {
        super(userObject, true);
        this.setAttributes(storageMap);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.add(children[i]);
            }
        }
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    @Override
    public AttributeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public Map changeAttributes(Map change) {
        return this.getAttributes().applyMap(change);
    }

    @Override
    public void setAttributes(AttributeMap attributes) {
        if (attributes == null) {
            attributes = new AttributeMap();
        }
        this.attributes = attributes;
    }

    public Object addPort() {
        return this.addPort(null);
    }

    public Object addPort(Point2D offset) {
        return this.addPort(offset, null);
    }

    public Object addPort(Point2D offset, Object userObject) {
        DefaultPort port = new DefaultPort(userObject);
        if (offset == null) {
            this.add(port);
        } else {
            GraphConstants.setOffset(port.getAttributes(), offset);
            this.add(port);
        }
        return port;
    }

    @Override
    public Object clone() {
        DefaultGraphCell c = (DefaultGraphCell)super.clone();
        c.attributes = (AttributeMap)this.attributes.clone();
        return c;
    }
}

