/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;

public class ConnectionSet
implements Serializable {
    protected Set connections = new HashSet();
    protected Set edges = new HashSet();

    public static ConnectionSet create(GraphModel m, Object[] cells, boolean disconnect) {
        ConnectionSet cs = new ConnectionSet();
        for (int i = 0; i < cells.length; ++i) {
            Object cell = cells[i];
            if (m.isEdge(cell)) {
                if (disconnect) {
                    cs.disconnect(cell);
                } else {
                    cs.connect(cell, m.getSource(cell), m.getTarget(cell));
                }
            }
            Iterator it = m.edges(cell);
            while (it.hasNext()) {
                Object edge = it.next();
                if (m.getSource(edge) == cell) {
                    ConnectionSet.connect(cs, edge, cell, true, disconnect);
                    continue;
                }
                if (m.getTarget(edge) != cell) continue;
                ConnectionSet.connect(cs, edge, cell, false, disconnect);
            }
        }
        return cs;
    }

    public ConnectionSet() {
    }

    public ConnectionSet(Object edge, Object port, boolean source) {
        this.connect(edge, port, source);
    }

    public ConnectionSet(Set connections) {
        this.setConnections(connections);
        for (Connection conn : connections) {
            this.edges.add(conn.getEdge());
        }
    }

    public ConnectionSet(Object edge, Object source, Object target) {
        this.connect(edge, source, target);
    }

    protected static void connect(ConnectionSet cs, Object edge, Object port, boolean source, boolean disconnect) {
        if (disconnect) {
            cs.disconnect(edge, source);
        } else {
            cs.connect(edge, port, source);
        }
    }

    public void addConnections(CellView[] views) {
        for (int i = 0; i < views.length; ++i) {
            if (!(views[i] instanceof EdgeView)) continue;
            EdgeView edgeView = (EdgeView)views[i];
            Object edge = edgeView.getCell();
            CellView sourceView = edgeView.getSource();
            CellView targetView = edgeView.getTarget();
            Object source = null;
            if (sourceView != null) {
                source = sourceView.getCell();
            }
            Object target = null;
            if (targetView != null) {
                target = targetView.getCell();
            }
            this.connect(edge, source, target);
        }
    }

    public void connect(Object edge, Object source, Object target) {
        this.connect(edge, source, true);
        this.connect(edge, target, false);
    }

    public void connect(Object edge, Object port, boolean source) {
        Connection c = new Connection(edge, port, source);
        this.connections.remove(c);
        this.connections.add(c);
        this.edges.add(edge);
    }

    public void disconnect(Object edge) {
        this.disconnect(edge, true);
        this.disconnect(edge, false);
    }

    public void disconnect(Object edge, boolean source) {
        this.connections.add(new Connection(edge, null, source));
        this.edges.add(edge);
    }

    public boolean isEmpty() {
        return this.connections.isEmpty();
    }

    public int size() {
        return this.connections.size();
    }

    public Iterator connections() {
        return this.connections.iterator();
    }

    public Set getChangedEdges() {
        return this.edges;
    }

    public Object getPort(Object edge, boolean source) {
        if (this.edges.contains(edge)) {
            for (Connection c : this.connections) {
                if (c.getEdge() != edge || c.isSource() != source) continue;
                return c.getPort();
            }
        }
        return null;
    }

    public ConnectionSet clone(Map map) {
        ConnectionSet cs = new ConnectionSet();
        Iterator it = this.connections();
        while (it.hasNext()) {
            Connection c = (Connection)it.next();
            Object edge = map.get(c.getEdge());
            Object port = c.getPort();
            if (port != null) {
                port = map.get(port);
            }
            if (edge != null && port != null) {
                cs.connect(edge, port, c.isSource());
                continue;
            }
            if (edge == null) continue;
            cs.connect(edge, c.getPort(), c.isSource());
        }
        return cs;
    }

    public Set getConnections() {
        return this.connections;
    }

    public Set getEdges() {
        return this.edges;
    }

    public void setConnections(Set set) {
        this.connections = set;
    }

    public void setEdges(Set set) {
        this.edges = set;
    }

    public static class Connection
    implements Serializable {
        protected Object edge;
        protected Object port;
        protected boolean isSource;

        public Connection() {
        }

        public Connection(Object edge, Object port, boolean isSource) {
            this.edge = edge;
            this.port = port;
            this.isSource = isSource;
        }

        public Object getEdge() {
            return this.edge;
        }

        public Object getPort() {
            return this.port;
        }

        public boolean isSource() {
            return this.isSource;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Connection) {
                Connection other = (Connection)obj;
                return other.getEdge().equals(this.edge) && other.isSource() == this.isSource;
            }
            return false;
        }

        public int hashCode() {
            return this.edge.hashCode();
        }

        public void setEdge(Object object) {
            this.edge = object;
        }

        public void setSource(boolean b) {
            this.isSource = b;
        }

        public void setPort(Object object) {
            this.port = object;
        }
    }
}

