/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;

public class BasicMarqueeHandler {
    protected transient Cursor previousCursor = null;
    protected Rectangle2D marqueeBounds;
    protected Point2D startPoint;
    protected Point2D currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent event) {
        return event.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        try {
            if (e != null && this.marqueeBounds != null) {
                if (!(e.getSource() instanceof JGraph)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
                }
                JGraph graph = (JGraph)e.getSource();
                Rectangle2D bounds = graph.fromScreen((Rectangle2D)this.marqueeBounds.clone());
                this.handleMarqueeEvent(e, graph, bounds);
                graph.setCursor(this.previousCursor);
                Rectangle dirty = new Rectangle((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth() + 1, (int)this.marqueeBounds.getHeight() + 1);
                ++dirty.width;
                ++dirty.height;
                graph.repaint(dirty);
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
    }

    public void handleMarqueeEvent(MouseEvent e, JGraph graph, Rectangle2D bounds) {
        CellView[] views = graph.getGraphLayoutCache().getRoots(bounds);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < views.length; ++i) {
            if (!bounds.contains(views[i].getBounds())) continue;
            list.add(views[i].getCell());
        }
        Object[] cells = list.toArray();
        graph.getUI().selectCellsForEvent(graph, cells, e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startPoint != null) {
            if (!(e.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
            }
            JGraph graph = (JGraph)e.getSource();
            Graphics g = graph.getGraphics();
            Color bg = graph.getBackground();
            Color fg = graph.getMarqueeColor();
            if (graph.isXorEnabled()) {
                g.setColor(fg);
                g.setXORMode(bg);
                this.overlay(graph, g, true);
            }
            Rectangle2D dirty = (Rectangle2D)this.marqueeBounds.clone();
            this.processMouseDraggedEvent(e);
            if (graph.isXorEnabled()) {
                g.setColor(bg);
                g.setXORMode(fg);
                this.overlay(graph, g, false);
            } else {
                dirty.add(this.marqueeBounds);
                graph.repaint((int)dirty.getX() - 1, (int)dirty.getY() - 1, (int)dirty.getWidth() + 2, (int)dirty.getHeight() + 2);
            }
        }
    }

    protected void processMouseDraggedEvent(MouseEvent e) {
        if (this.startPoint != null) {
            this.currentPoint = e.getPoint();
            this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
            this.marqueeBounds.add(this.currentPoint);
        }
    }

    public void paint(JGraph graph, Graphics g) {
        if (this.marqueeBounds != null) {
            if (graph.isXorEnabled()) {
                Color bg = graph.getBackground();
                Color fg = graph.getMarqueeColor();
                g.setColor(fg);
                g.setXORMode(bg);
            }
            this.overlay(graph, g, false);
        }
    }

    public void overlay(JGraph graph, Graphics g, boolean clear) {
        if (this.marqueeBounds != null) {
            if (!graph.isXorEnabled()) {
                g.setColor(graph.getMarqueeColor());
            }
            g.drawRect((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth(), (int)this.marqueeBounds.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.startPoint = e.getPoint();
        this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
        if (!(e.getSource() instanceof JGraph)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
        }
        JGraph graph = (JGraph)e.getSource();
        if (this.isMarqueeTriggerEvent(e, graph)) {
            this.previousCursor = graph.getCursor();
            graph.setCursor(new Cursor(1));
        }
    }

    public boolean isMarqueeTriggerEvent(MouseEvent e, JGraph graph) {
        return graph.isSelectionEnabled();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle2D getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point2D currentPoint) {
        this.currentPoint = currentPoint;
    }

    public void setMarqueeBounds(Rectangle2D marqueeBounds) {
        this.marqueeBounds = marqueeBounds;
    }

    public void setPreviousCursor(Cursor previousCursor) {
        this.previousCursor = previousCursor;
    }

    public void setStartPoint(Point2D startPoint) {
        this.startPoint = startPoint;
    }

    public static JGraph getGraphForEvent(MouseEvent event) {
        if (event.getSource() instanceof JGraph) {
            return (JGraph)event.getSource();
        }
        return null;
    }
}

