/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class AttributeMap
extends Hashtable
implements Cloneable {
    public static transient AttributeMap emptyAttributeMap = new AttributeMap(0){

        @Override
        public Object clone() {
            return this;
        }
    };

    public AttributeMap() {
        super(8);
    }

    public AttributeMap(int initialCapacity) {
        super(initialCapacity);
    }

    public AttributeMap(int initialCapacity, float loadCapacity) {
        super(initialCapacity, loadCapacity);
    }

    public AttributeMap(Map map) {
        super(map);
    }

    public Point2D createPoint() {
        return new SerializablePoint2D();
    }

    public Point2D createPoint(Point2D p) {
        if (p != null) {
            return this.createPoint(p.getX(), p.getY());
        }
        return null;
    }

    public Point2D createPoint(double x, double y) {
        return new SerializablePoint2D(x, y);
    }

    public Rectangle2D createRect() {
        return new SerializableRectangle2D();
    }

    public Rectangle2D createRect(double x, double y, double w, double h) {
        return new SerializableRectangle2D(x, y, w, h);
    }

    public Rectangle2D createRect(Point2D pt) {
        return this.createRect(pt, 0.0);
    }

    public Rectangle2D createRect(Point2D pt, double size) {
        if (pt != null) {
            return this.createRect(pt.getX(), pt.getY(), size, size);
        }
        return null;
    }

    public Rectangle2D createRect(Rectangle2D rect) {
        if (rect != null) {
            return this.createRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        return null;
    }

    public Rectangle2D createRect(double x, double y, double w, double h, double grow1, double grow2) {
        return this.createRect(x - grow1, y - grow1, w + grow1 + grow2, h + grow1 + grow2);
    }

    public Rectangle2D createRect(Rectangle2D rect, double grow1, double grow2) {
        if (rect != null) {
            return this.createRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), grow1, grow2);
        }
        return null;
    }

    public AttributeMap applyMap(Map change) {
        AttributeMap undo = new AttributeMap();
        if (change != null) {
            Object[] remove;
            if (GraphConstants.isRemoveAll(change)) {
                undo.putAll(this);
                this.clear();
            }
            if ((remove = GraphConstants.getRemoveAttributes(change)) != null) {
                for (int i = 0; i < remove.length; ++i) {
                    Object oldValue = this.remove(remove[i]);
                    if (oldValue == null) continue;
                    undo.put(remove[i], oldValue);
                }
            }
            HashSet removeAttributes = null;
            for (Map.Entry entry : change.entrySet()) {
                Object key = entry.getKey();
                if (key.equals("removeAll") || key.equals("removeAttributes") || key.equals("value")) continue;
                Object oldValue = this.applyValue(key, entry.getValue());
                if (oldValue == null) {
                    if (removeAttributes == null) {
                        removeAttributes = new HashSet();
                    }
                    removeAttributes.add(key);
                    continue;
                }
                undo.put(key, oldValue);
            }
            if (removeAttributes != null && !removeAttributes.isEmpty()) {
                GraphConstants.setRemoveAttributes(undo, removeAttributes.toArray());
            }
        }
        return undo;
    }

    public Object applyValue(Object key, Object value) {
        if (value instanceof Rectangle2D) {
            value = this.createRect((Rectangle2D)value);
        }
        if (value instanceof Point2D) {
            value = this.createPoint((Point2D)value);
        }
        if (value instanceof Point2D[]) {
            value = this.clonePoints((Point2D[])value);
        }
        if (value instanceof List) {
            value = this.clonePoints((List)value);
        }
        return this.put(key, value);
    }

    public Point2D[] clonePoints(Point2D[] points) {
        List pts = this.clonePoints(points, true);
        Point2D[] newPoints = new Point2D[pts.size()];
        pts.toArray(newPoints);
        return newPoints;
    }

    public List clonePoints(List points) {
        return this.clonePoints(points.toArray(), true);
    }

    public List clonePoints(Object[] points, boolean convertPortViews) {
        ArrayList<Object> newList = new ArrayList<Object>(points.length);
        for (int i = 0; i < points.length; ++i) {
            Object point = points[i];
            if (point instanceof PortView && convertPortViews) {
                point = this.createPoint(((PortView)point).getLocation());
            } else if (point instanceof Point2D) {
                point = this.createPoint((Point2D)point);
            }
            newList.add(point);
        }
        return newList;
    }

    public static void translate(Collection c, double dx, double dy) {
        for (Object map : c) {
            if (!(map instanceof AttributeMap)) continue;
            ((AttributeMap)map).translate(dx, dy);
        }
    }

    public void translate(double dx, double dy) {
        if (GraphConstants.isMoveable(this)) {
            List points;
            Rectangle2D bounds = GraphConstants.getBounds(this);
            if (bounds != null) {
                int moveableAxis = GraphConstants.getMoveableAxis(this);
                if (moveableAxis == 1) {
                    dy = 0.0;
                } else if (moveableAxis == 2) {
                    dx = 0.0;
                }
                bounds.setFrame(bounds.getX() + dx, bounds.getY() + dy, bounds.getWidth(), bounds.getHeight());
            }
            if ((points = GraphConstants.getPoints(this)) != null) {
                for (int i = 0; i < points.size(); ++i) {
                    Object obj = points.get(i);
                    if (!(obj instanceof Point2D)) continue;
                    Point2D pt = (Point2D)obj;
                    pt.setLocation(pt.getX() + dx, pt.getY() + dy);
                }
            }
        }
    }

    public void scale(double sx, double sy, Point2D origin) {
        List points;
        Rectangle2D bounds = GraphConstants.getBounds(this);
        if (bounds != null) {
            int sizeableAxis;
            Point2D p = this.createPoint(bounds.getX(), bounds.getY());
            Point2D loc = (Point2D)p.clone();
            p.setLocation(origin.getX() + (double)Math.round((p.getX() - origin.getX()) * sx), origin.getY() + (double)Math.round((p.getY() - origin.getY()) * sy));
            if (!p.equals(loc)) {
                this.translate(p.getX() - loc.getX(), p.getY() - loc.getY());
            }
            if ((sizeableAxis = GraphConstants.getSizeableAxis(this)) == 1) {
                sy = 1.0;
            } else if (sizeableAxis == 2) {
                sx = 1.0;
            }
            double w = Math.max(1L, Math.round(bounds.getWidth() * sx));
            double h = Math.max(1L, Math.round(bounds.getHeight() * sy));
            bounds.setFrame(bounds.getX(), bounds.getY(), w, h);
        }
        if ((points = GraphConstants.getPoints(this)) != null) {
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                Point2D loc = (Point2D)obj;
                Point2D p = (Point2D)loc.clone();
                p.setLocation(origin.getX() + (double)Math.round((p.getX() - origin.getX()) * sx), origin.getY() + (double)Math.round((p.getY() - origin.getY()) * sy));
                loc.setLocation(p);
            }
        }
    }

    public Map diff(Map newState) {
        Hashtable diff = new Hashtable();
        for (Map.Entry entry : newState.entrySet()) {
            Object key = entry.getKey();
            Object newValue = entry.getValue();
            Object oldValue = this.get(key);
            if (oldValue != null && oldValue.equals(newValue)) continue;
            diff.put(key, newValue);
        }
        return diff;
    }

    @Override
    public Object clone() {
        return this.cloneEntries((AttributeMap)super.clone());
    }

    public AttributeMap cloneEntries(AttributeMap newMap) {
        Point2D label;
        Point2D[] positions;
        List points;
        Rectangle2D bounds = GraphConstants.getBounds(newMap);
        if (bounds != null) {
            GraphConstants.setBounds(newMap, (Rectangle2D)bounds.clone());
        }
        if ((points = GraphConstants.getPoints(newMap)) != null) {
            GraphConstants.setPoints(newMap, this.clonePoints(points));
        }
        if ((positions = GraphConstants.getExtraLabelPositions(newMap)) != null) {
            GraphConstants.setExtraLabelPositions(newMap, this.clonePoints(positions));
        }
        if ((label = GraphConstants.getLabelPosition(newMap)) != null) {
            GraphConstants.setLabelPosition(newMap, (Point2D)label.clone());
        }
        return newMap;
    }

    public static class SerializableRectangle2D
    extends Rectangle2D.Double
    implements Serializable {
        public SerializableRectangle2D() {
        }

        public SerializableRectangle2D(double x, double y, double width, double height) {
            super(x, y, width, height);
        }

        public void setX(double x) {
            this.setFrame(x, this.getY(), this.getWidth(), this.getHeight());
        }

        public void setY(double y) {
            this.setFrame(this.getX(), y, this.getWidth(), this.getHeight());
        }

        public void setWidth(double width) {
            this.setFrame(this.getX(), this.getY(), width, this.getHeight());
        }

        public void setHeight(double height) {
            this.setFrame(this.getX(), this.getY(), this.getWidth(), height);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new Double(this.getX()));
            out.writeObject(new Double(this.getY()));
            out.writeObject(new Double(this.getWidth()));
            out.writeObject(new Double(this.getHeight()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Double x = (Double)in.readObject();
            Double y = (Double)in.readObject();
            Double width = (Double)in.readObject();
            Double height = (Double)in.readObject();
            this.setFrame(x, y, width, height);
        }
    }

    public static class SerializablePoint2D
    extends Point2D.Double
    implements Serializable {
        public SerializablePoint2D() {
        }

        public SerializablePoint2D(double x, double y) {
            super(x, y);
        }

        public void setX(double x) {
            this.setLocation(x, this.getY());
        }

        public void setY(double y) {
            this.setLocation(this.getX(), y);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new Double(this.getX()));
            out.writeObject(new Double(this.getY()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Double x = (Double)in.readObject();
            Double y = (Double)in.readObject();
            this.setLocation(x, y);
        }
    }
}

