/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;

public class RpSpeed {
    static JEP j;
    static int num_itts;

    public static void main(String[] args) {
        long t1 = System.currentTimeMillis();
        RpSpeed.initJep();
        long t2 = System.currentTimeMillis();
        System.out.println("Jep initialise " + (t2 - t1));
        RpSpeed.doAll(new String[0], "1*2*3+4*5*6+7*8*9");
        RpSpeed.doAll(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
        RpSpeed.doAll(new String[]{"x=0.7"}, "cos(x)^2+sin(x)^2");
    }

    public static void doAll(String[] eqns, String eqn2) {
        System.out.print("Testing speed for <");
        for (int i = 0; i < eqns.length; ++i) {
            System.out.print(eqns[i] + ",");
        }
        System.out.println("> and <" + eqn2 + ">");
        RpSpeed.doJep(eqns, eqn2);
        RpSpeed.doRpe(eqns, eqn2);
        System.out.println();
    }

    static void initJep() {
        j = new JEP();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setImplicitMul(true);
        j.setAllowAssignment(true);
    }

    static void doJep(String[] eqns, String eqn2) {
        try {
            for (int i = 0; i < eqns.length; ++i) {
                Node node2 = j.parse(eqns[i]);
                j.evaluate(node2);
            }
            Node node = j.parse(eqn2);
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                j.evaluate(node);
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Using Jep:\t" + (t2 - t1));
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
        }
    }

    static void doRpe(String[] eqns, String eqn2) {
        try {
            for (int i = 0; i < eqns.length; ++i) {
                Node node2 = j.parse(eqns[i]);
                j.evaluate(node2);
            }
            Node node3 = j.parse(eqn2);
            RpEval rpe = new RpEval(j);
            RpCommandList list = rpe.compile(node3);
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                rpe.evaluate(list);
            }
            long t2 = System.currentTimeMillis();
            System.out.print("Using RpEval2:\t\t" + (t2 - t1));
            double res = rpe.evaluate(list);
            System.out.println("\t" + res);
            rpe.cleanUp();
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        num_itts = 100000;
    }
}

