/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public class PFunction
extends AbstractPNode {
    String name;
    PostfixMathCommandI pfmc;
    XOperator op = null;
    PNodeI[] args;

    public PFunction(PolynomialCreator pc, String name, PostfixMathCommandI pfmc, PNodeI[] args) {
        super(pc);
        this.name = name;
        this.pfmc = pfmc;
        this.args = args;
    }

    @Override
    public boolean equals(PNodeI node) {
        if (!(node instanceof PFunction)) {
            return false;
        }
        PFunction fun = (PFunction)node;
        if (!this.name.equals(fun.name)) {
            return false;
        }
        if (this.args.length != fun.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(fun.args[i])) continue;
            return false;
        }
        return true;
    }

    public int compareTo(PFunction fun) {
        int res = this.name.compareTo(fun.name);
        if (res != 0) {
            return res;
        }
        if (this.args.length < fun.args.length) {
            return -1;
        }
        if (this.args.length > fun.args.length) {
            return 1;
        }
        for (int i = 0; i < this.args.length; ++i) {
            res = this.args[i].compareTo(fun.args[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.args[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        Node[] funargs = new Node[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            funargs[i] = this.args[i].toNode();
        }
        ASTFunNode fun = this.pc.nf.buildFunctionNode(this.name, this.pfmc, funargs);
        return fun;
    }

    @Override
    public PNodeI expand() throws ParseException {
        PNodeI[] newTerms = new PNodeI[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            newTerms[i] = this.args[i].expand();
        }
        return new PFunction(this.pc, this.name, this.pfmc, newTerms);
    }
}

