/*
 * Decompiled with CFR 0.152.
 */
package root;

import hep.aida.ITuple;
import hep.aida.ref.tuple.ReadOnlyAbstractTuple;
import hep.io.root.RootClassNotFound;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafC;
import hep.io.root.interfaces.TLeafD;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.interfaces.TLeafL;
import hep.io.root.interfaces.TTree;
import java.io.IOException;
import org.freehep.util.Value;
import root.TLeafBColumn;
import root.TLeafCColumn;
import root.TLeafColumn;
import root.TLeafDColumn;
import root.TLeafFColumn;
import root.TLeafFolderColumn;
import root.TLeafIColumn;
import root.TLeafLColumn;
import root.TLeafObjectColumn;

class TTreeTuple
extends ReadOnlyAbstractTuple {
    private TKey key;
    private Value theValue;
    private TLeafColumn[] columns;
    private int nCol;

    TTreeTuple(TKey key, String name) {
        super(name, key.getTitle());
        this.key = key;
        this.nCol = this.tree().getLeaves().size();
        this.columns = new TLeafColumn[this.nCol];
        this.theValue = new Value();
        TLeafFolderColumn subTuple = null;
        TLeafI lastDim = null;
        int n = 0;
        for (int i = 0; i < this.nCol; ++i) {
            TLeaf leaf = (TLeaf)this.tree().getLeaves().get(i);
            int nDim = leaf.getArrayDim();
            if (nDim == 0) {
                if (leaf instanceof TLeafI) {
                    this.columns[n++] = new TLeafIColumn((TLeafI)leaf);
                    continue;
                }
                if (leaf instanceof TLeafL) {
                    this.columns[n++] = new TLeafLColumn((TLeafL)leaf);
                    continue;
                }
                if (leaf instanceof TLeafF) {
                    this.columns[n++] = new TLeafFColumn((TLeafF)leaf);
                    continue;
                }
                if (leaf instanceof TLeafD) {
                    this.columns[n++] = new TLeafDColumn((TLeafD)leaf);
                    continue;
                }
                if (leaf instanceof TLeafB) {
                    this.columns[n++] = new TLeafBColumn((TLeafB)leaf);
                    continue;
                }
                if (leaf instanceof TLeafC) {
                    this.columns[n++] = new TLeafCColumn((TLeafC)leaf);
                    continue;
                }
                System.out.println("Ignored column " + leaf.getName() + " of type " + leaf.getClass());
                continue;
            }
            TLeafI dim = (TLeafI)leaf.getLeafCount();
            if (dim == null) {
                this.columns[n++] = new TLeafObjectColumn(leaf);
                continue;
            }
            if (dim == lastDim) {
                subTuple.addColumn(leaf);
                continue;
            }
            subTuple = new TLeafFolderColumn(dim);
            this.columns[n++] = subTuple;
            subTuple.addColumn(leaf);
            lastDim = dim;
        }
        this.nCol = n;
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean providesColumnDefaultValues() {
        return false;
    }

    public void columnValue(int column, Value v) {
        this.columns[column].getValue(this.getRow(), v);
    }

    public ITuple findTuple(int col) {
        this.columns[col].getValue(this.getRow(), this.theValue);
        return (ITuple)this.theValue.getObject();
    }

    public double columnMax(int index) throws IllegalArgumentException {
        this.columns[index].maxValue(this.theValue);
        return this.theValue.getDouble();
    }

    public double columnMean(int index) throws IllegalArgumentException {
        this.columns[index].meanValue(this.theValue);
        return this.theValue.getDouble();
    }

    public double columnMin(int index) throws IllegalArgumentException {
        this.columns[index].minValue(this.theValue);
        return this.theValue.getDouble();
    }

    public String columnName(int index) throws IllegalArgumentException {
        return this.columns[index].name();
    }

    public double columnRms(int index) throws IllegalArgumentException {
        this.columns[index].rmsValue(this.theValue);
        return this.theValue.getDouble();
    }

    public Class columnType(int index) throws IllegalArgumentException {
        return this.columns[index].type();
    }

    public int columns() {
        return this.nCol;
    }

    public int findColumn(String name) throws IllegalArgumentException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].name().equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown column " + name);
    }

    public int rows() {
        return (int)this.tree().getEntries();
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    private TTree tree() {
        try {
            return (TTree)this.key.getObject();
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Root Class Not Found " + x.getClassName(), x);
        }
        catch (IOException x) {
            throw new RuntimeException("IOException reading root file", x);
        }
    }

    public String columnDefaultString(int index) {
        throw new UnsupportedOperationException();
    }

    public Object columnDefaultValue(int index) {
        throw new UnsupportedOperationException();
    }
}

