/*
 * Decompiled with CFR 0.152.
 */
package jyplot.XYErrorBar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import jyplot.XYErrorBar.XYErrorBarRenderer;
import jyplot.XYErrorBar.XYErrorBarSeries;
import jyplot.XYErrorBar.XYErrorBarSeriesCollection;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class ErrorBarDemo {
    public ErrorBarDemo() {
        XYDataset dataset = this.createDataset();
        ChartPanel chartPanel = this.createChartPanel(dataset);
        JFrame frame = new JFrame("Error Bar Demo");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)chartPanel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.pack();
        frame.setLocation((screenSize.width - frame.getWidth()) / 2, (screenSize.height - frame.getHeight()) / 2);
        frame.show();
    }

    public static void main(String[] args) {
        new ErrorBarDemo();
    }

    private ChartPanel createChartPanel(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createScatterPlot((String)"Error Bar Demo", (String)"x", (String)"y", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYErrorBarRenderer r = new XYErrorBarRenderer();
        chart.getXYPlot().setRenderer((XYItemRenderer)r);
        r.addChangeListener((RendererChangeListener)chart.getXYPlot());
        ChartPanel chartPanel = new ChartPanel(chart, false, false, false, false, false);
        chartPanel.setMouseZoomable(true, false);
        return chartPanel;
    }

    private XYDataset createDataset() {
        XYErrorBarSeriesCollection dataset = new XYErrorBarSeriesCollection();
        XYErrorBarSeries series = new XYErrorBarSeries("Series 1");
        for (int i = 0; i < 10; ++i) {
            series.add(i, i, i - 2, i + 2);
        }
        dataset.addSeries(series);
        return dataset;
    }
}

