/*
 * Decompiled with CFR 0.152.
 */
package jyplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.html.StyleSheet;
import jyplot.BarXYDataset;
import jyplot.BaseChartPanel;
import jyplot.CustomSymbolAxis;
import jyplot.XYStatisticalLineAndShapeRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JyplotVanilla
implements Serializable {
    private static final long serialVersionUID = 1L;
    static Class thisclass = JyplotVanilla.class;
    static String shortname = thisclass.getName().substring(thisclass.getName().lastIndexOf(".") + 1);
    JFrame frame;
    JPanel jpanel;
    protected static final Color DEFAULT_BG_COLOR = Color.white;
    ArrayList chartMouseListeners;
    boolean enableJFrame;
    boolean closeOnExit;
    protected JFreeChart chart;
    HashMap chartToPanelMap;
    ArrayList<JFreeChart> chartList;
    int rows;
    int cols;
    int currentPlotNumber;
    XYSeriesCollection dataset;
    protected float figureWidth;
    protected float figureHeight;
    protected int dpi;
    HashMap<String, Color> colourcodes;
    Map<String, Color> stringColorMap;
    StyleSheet styleSheet;
    Color currentColor;
    int currentDatasetIndex;
    int currentSeriestIndex;
    HashMap seriesIndexColorMap;

    public JyplotVanilla(boolean enableJFrame) {
        this.enableJFrame = enableJFrame;
        this.closeOnExit = false;
        this.rows = 1;
        this.cols = 1;
        this.chartList = new ArrayList();
        if (this.jpanel == null) {
            this.jpanel = new JPanel(new GridLayout(1, 1));
        }
        this.jpanel.setVisible(true);
        this.seriesIndexColorMap = new HashMap();
        this.chartMouseListeners = new ArrayList();
        this.chartToPanelMap = new HashMap();
        this.colourcodes = new HashMap();
        this.colourcodes.put("r", Color.RED);
        this.colourcodes.put("g", Color.GREEN);
        this.colourcodes.put("b", Color.BLUE);
        this.colourcodes.put("y", Color.YELLOW);
        this.colourcodes.put("o", Color.ORANGE);
        this.stringColorMap = this.getStringToColorMap();
        this.styleSheet = new StyleSheet();
        this.figureWidth = 8.0f;
        this.figureHeight = 6.0f;
        this.subplot(1, 1, 1);
    }

    public JyplotVanilla() {
        this(true);
    }

    public void subplot(int number) {
        int rows = 1;
        int cols = 1;
        int plotnumber = 1;
        rows = number / 100;
        cols = (number - rows * 100) / 10;
        plotnumber = number - rows * 100 - cols * 10;
        if (rows > 9 || cols > 9 || plotnumber > 9) {
            System.out.println("Incorrect format for subplot");
            return;
        }
        this.subplot(rows, cols, plotnumber);
    }

    public void subplot(int rows, int cols, int plotnumber) {
        this.chart = null;
        int maxCharts = rows * cols;
        if (plotnumber > maxCharts) {
            System.out.println("Error in subplot(" + rows + ", " + cols + ", " + plotnumber + ")");
            System.out.println("Plot index is greater than max number of plots.");
            return;
        }
        for (int i = 0; i < maxCharts - this.chartList.size(); ++i) {
            this.chartList.add(null);
        }
        this.rows = rows;
        this.cols = cols;
        this.currentPlotNumber = plotnumber - 1;
    }

    public void show() {
        this.show(800, 400);
    }

    public void show(int width, int height) {
        if (this.jpanel == null) {
            this.jpanel = new JPanel(new GridLayout(1, 1));
        }
        this.jpanel.setPreferredSize(new Dimension(width, height));
        GridLayout gridLayout = (GridLayout)this.jpanel.getLayout();
        gridLayout.setColumns(this.cols);
        gridLayout.setRows(this.rows);
        if (this.enableJFrame && this.frame == null) {
            this.frame = new JFrame("Figure");
            this.frame.setSize(width, height);
            this.frame.setVisible(false);
            this.setQuitOnWindowClose(this.closeOnExit);
            this.frame.getContentPane().add(this.jpanel);
        }
        this.jpanel.setSize(width, height);
        this.jpanel.removeAll();
        int currentChartIndex = 0;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                try {
                    this.chart = this.chartList.get(currentChartIndex);
                    this.chart.setBorderPaint((Paint)DEFAULT_BG_COLOR);
                    this.chart.setBackgroundPaint((Paint)DEFAULT_BG_COLOR);
                    this.chart.setBorderVisible(false);
                    ++currentChartIndex;
                    BaseChartPanel chartpanel = null;
                    if (this.chartToPanelMap.containsKey(this.chart) && this.chartToPanelMap.get(this.chart) != null) {
                        chartpanel = (BaseChartPanel)this.chartToPanelMap.get(this.chart);
                        chartpanel.setBackground(DEFAULT_BG_COLOR);
                    } else {
                        chartpanel = new BaseChartPanel(this.chart);
                        this.chartToPanelMap.put(this.chart, chartpanel);
                        chartpanel.setBackground(DEFAULT_BG_COLOR);
                    }
                    this.jpanel.add(chartpanel);
                    chartpanel.repaint();
                    continue;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        this.jpanel.setVisible(true);
        this.jpanel.revalidate();
        this.jpanel.repaint();
        if (this.enableJFrame) {
            this.frame.setVisible(true);
        }
    }

    public XYDataset plot(double[] y) {
        double[] x = new double[y.length];
        for (int i = 1; i <= x.length; ++i) {
            x[i - 1] = i;
        }
        return this.plot(x, y);
    }

    public XYDataset plot(double[] x, double[] y) {
        return this.plot(x, y, null);
    }

    public XYDataset plot(double[] x, double[] y, Color color) {
        return this.plot(x, y, color, null, null, false, false, null, false);
    }

    public XYDataset plot(double[] x, double[] y, Color color, String dataname, double[] yErrorBars, boolean seperateYAxis, boolean yaxisVisible, String rangeLabel, boolean shapesVisible) {
        if (x == null) {
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        }
        if (dataname == null) {
            dataname = "";
        }
        XYSeries series = new XYSeries((Comparable)((Object)dataname));
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i]) || Double.isInfinite(x[i]) || Double.isInfinite(y[i])) continue;
            series.add(x[i], y[i]);
        }
        if (dataname != null) {
            series.setKey((Comparable)((Object)dataname));
        }
        if (this.chart == null) {
            this.createXYChart();
        }
        this.chart.setBorderPaint((Paint)DEFAULT_BG_COLOR);
        this.chart.setBackgroundPaint((Paint)DEFAULT_BG_COLOR);
        this.chart.setBorderVisible(false);
        XYPlot plot = this.chart.getXYPlot();
        if (plot == null) {
            System.err.println("Plot is null");
        }
        plot.setBackgroundPaint((Paint)DEFAULT_BG_COLOR);
        int currentDatasetIndex = plot.getDatasetCount();
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        plot.setDataset(currentDatasetIndex, (XYDataset)dataset);
        XYLineAndShapeRenderer renderer = null;
        renderer = new XYLineAndShapeRenderer();
        plot.setRenderer(currentDatasetIndex, (XYItemRenderer)renderer);
        if (seperateYAxis) {
            this.setSeperateYAxis(rangeLabel, color, yaxisVisible);
        }
        this.setShapesVisible(shapesVisible);
        this.setSeriesColor(color);
        if (dataname == null || dataname.equalsIgnoreCase("")) {
            renderer.setSeriesVisibleInLegend(Boolean.valueOf(false));
        }
        this.chart.getXYPlot().configureDomainAxes();
        this.chart.getXYPlot().configureRangeAxes();
        this.grid(false);
        return dataset;
    }

    protected void setSeperateYAxis(String rangeLabel, Color color, boolean visible) {
        XYPlot plot = this.chart.getXYPlot();
        int currentDatasetIndex = plot.getDatasetCount() - 1;
        NumberAxis axis = new NumberAxis(rangeLabel);
        plot.setRangeAxis(currentDatasetIndex, (ValueAxis)axis);
        axis.setAutoRangeIncludesZero(false);
        axis.setAutoRange(true);
        axis.setVisible(visible);
        if (color != null) {
            axis.setLabelPaint((Paint)color);
            axis.setTickLabelPaint((Paint)color);
        }
        plot.mapDatasetToRangeAxis(currentDatasetIndex, currentDatasetIndex);
    }

    public void title(String p) {
        if (this.chart != null) {
            this.chart.setTitle(p);
        } else {
            System.out.println("title(): No chart created");
        }
    }

    public void title(String p, int fontsize) {
        if (this.chart != null) {
            this.chart.setTitle(p);
            this.chart.getTitle().setFont(new Font("SansSerif", 1, fontsize));
        } else {
            System.out.println("title(): No chart created");
        }
    }

    public void xlabel(String p) {
        if (this.chart != null) {
            int currentDataSetIndex = this.chart.getXYPlot().getDomainAxisCount() - 1;
            if (currentDataSetIndex == -1) {
                currentDataSetIndex = 0;
            }
            ValueAxis axis = this.chart.getXYPlot().getDomainAxisForDataset(currentDataSetIndex);
            axis.setLabel(p);
            axis.setAxisLineVisible(true);
            axis.setTickLabelsVisible(true);
            axis.setTickMarksVisible(true);
        } else {
            System.out.println("xlabel(): No chart created");
        }
    }

    public void ylabel(String p) {
        if (!this.isXYPlot()) {
            return;
        }
        this.chart.getXYPlot().getRangeAxis().setLabel(p);
        this.chart.getXYPlot().getRangeAxis().setAxisLineVisible(true);
        this.chart.getXYPlot().getRangeAxis().setTickLabelsVisible(true);
        this.chart.getXYPlot().getRangeAxis().setTickMarksVisible(true);
    }

    public void legend(String[] p) {
        if (!this.isXYPlot()) {
            return;
        }
        if (p == null) {
            for (int i = 0; i < this.getChart().getXYPlot().getDatasetCount(); ++i) {
                this.getChart().getXYPlot().getRenderer(i).setSeriesVisibleInLegend(Boolean.valueOf(false));
            }
            return;
        }
        Class<BarXYDataset> BarXYDatasetClass = BarXYDataset.class;
        if (this.chart.getXYPlot().getDataset().getClass() == BarXYDatasetClass) {
            BarXYDataset dataset = (BarXYDataset)this.chart.getXYPlot().getDataset();
            for (int i = 0; i < dataset.getSeriesCount() && p.length >= i; ++i) {
                dataset.setSeriesKey(i, (Comparable)((Object)p[i]));
            }
        } else {
            System.err.println("chart.getXYPlot().getDataset().getClass() != BarXYDatasetClass");
        }
    }

    public void label(String p) {
        if (!this.isXYPlot()) {
            return;
        }
        try {
            int latestDatasetIndex = this.chart.getXYPlot().getDatasetCount() - 1;
            if (p != null && !p.equalsIgnoreCase("")) {
                ((XYSeriesCollection)this.chart.getXYPlot().getDataset(latestDatasetIndex)).getSeries(this.chart.getXYPlot().getDataset(latestDatasetIndex).getSeriesCount() - 1).setKey((Comparable)((Object)p));
                this.chart.getXYPlot().getRendererForDataset(this.chart.getXYPlot().getDataset(latestDatasetIndex)).setSeriesVisibleInLegend(Boolean.valueOf(true));
            } else {
                this.chart.getXYPlot().getRendererForDataset(this.chart.getXYPlot().getDataset(latestDatasetIndex)).setSeriesVisibleInLegend(latestDatasetIndex, Boolean.valueOf(false));
                this.chart.getXYPlot().getRendererForDataset(this.chart.getXYPlot().getDataset(latestDatasetIndex)).setSeriesVisibleInLegend(Boolean.valueOf(false));
                this.chart.getXYPlot().getRendererForDataset(this.chart.getXYPlot().getDataset(latestDatasetIndex)).setSeriesVisibleInLegend(Boolean.valueOf(false), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void linestyle(String[] p) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        AbstractRenderer r1 = (AbstractRenderer)plot.getRenderer(0);
        for (int i = 0; i < this.dataset.getSeriesCount() && p.length >= i; ++i) {
            BasicStroke stroke = (BasicStroke)r1.getSeriesStroke(i);
            r1.setSeriesStroke(i, (Stroke)new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), new float[]{12.0f, 12.0f}, 0.0f));
        }
    }

    public void linewidth(float[] p) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        AbstractRenderer r1 = (AbstractRenderer)plot.getRenderer(0);
        for (int i = 0; i < this.dataset.getSeriesCount() && p.length >= i; ++i) {
            r1.setSeriesStroke(i, (Stroke)new BasicStroke(p[i]));
        }
    }

    public void linecolor(Color[] p) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        AbstractRenderer r1 = (AbstractRenderer)plot.getRenderer(0);
        for (int i = 0; i < this.dataset.getSeriesCount() && p.length >= i; ++i) {
            r1.setSeriesPaint(i, (Paint)p[i]);
        }
    }

    public void axis(double[] p) {
        if (this.chart == null) {
            System.out.println("No chart yet.");
            return;
        }
        if (p.length > 1) {
            this.xlim(p[0], p[1]);
        }
        if (p.length > 3) {
            this.ylim(p[2], p[3]);
        }
    }

    public void xlim(double min, double max) {
        if (this.chart == null) {
            System.err.println("No chart yet.");
            return;
        }
        try {
            ValueAxis XAxis = this.chart.getXYPlot().getDomainAxis();
            XAxis.setRange(min, max);
            XAxis.setAutoRange(false);
        }
        catch (ClassCastException e) {
            System.out.println("Plot is not an XYPlot: you cannot set the axis range.");
        }
    }

    public void ylim(double min, double max) {
        if (this.chart == null) {
            System.err.println("No chart yet.");
            return;
        }
        try {
            ValueAxis YAxis = this.chart.getXYPlot().getRangeAxis();
            YAxis.setRange(min, max);
            YAxis.setAutoRange(false);
        }
        catch (ClassCastException e) {
            System.out.println("Plot is not an XYPlot: you cannot set the axis range.");
        }
    }

    public void loglog(int p) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        String xlabel = plot.getRangeAxis().getLabel();
        String ylabel = plot.getDomainAxis().getLabel();
        plot.setDomainAxis(p, (ValueAxis)new LogarithmicAxis(xlabel));
        plot.setRangeAxis(p, (ValueAxis)new LogarithmicAxis(ylabel));
    }

    public void loglog() {
        this.loglog(0);
    }

    public static void main(String[] args) {
        JyplotVanilla j = new JyplotVanilla(true);
        j.subplot(2, 2, 1);
        double[] x1 = new double[]{10.0, 20.0, 10.0, 40.0, 30.0, 10.0, 30.0, 50.0};
        double[] y1 = new double[]{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0};
        j.plot(x1, y1);
        j.subplot(2, 2, 2);
        j.plot(x1, y1);
        j.subplot(2, 2, 3);
        j.plot(x1, y1);
        j.subplot(2, 2, 4);
        j.plot(x1, y1);
        j.show(800, 400);
        j.savefig("/tmp/delete.png", 100, 100);
    }

    protected static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBorderPaint((Paint)DEFAULT_BG_COLOR);
        chart.setBackgroundPaint((Paint)DEFAULT_BG_COLOR);
        chart.setBorderVisible(false);
        return chart;
    }

    public void bar(Object[] x, double[] y, Color color) {
        double[] _left = new double[y.length];
        double[] _height = new double[y.length];
        double[] _width = new double[y.length];
        double[] _bottom = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            _width[i] = 1.0;
            _bottom[i] = 0.0;
            _height[i] = y[i];
            _left[i] = (double)i - 0.5;
        }
        this.bar(_left, _height, _width, _bottom, color);
        String[] xticks = new String[x.length];
        double[] xticksloc = new double[x.length];
        for (int i = 0; i < xticks.length; ++i) {
            xticks[i] = x[i].toString();
            xticksloc[i] = i;
        }
        this.xticks(xticksloc, xticks);
    }

    public void bar(Object[] x, double[] y) {
        this.bar(x, y, null);
    }

    public void bar(double left, double height, double width, double bottom, Color color) {
        double[] _left = new double[]{left};
        double[] _height = new double[]{height};
        double[] _width = new double[]{width};
        double[] _bottom = new double[]{bottom};
        this.bar(_left, _height, _width, _bottom, color);
    }

    public void bar(List<Double> left, List<Double> height, List<Double> width, List<Double> bottom, Color color) {
        if (left.size() != height.size() || left.size() != width.size() || left.size() != bottom.size()) {
            System.out.println("bar(): lists must be of the same length.");
            return;
        }
        double[] _left = new double[left.size()];
        double[] _height = new double[left.size()];
        double[] _width = new double[left.size()];
        double[] _bottom = new double[left.size()];
        for (int i = 0; i < left.size(); ++i) {
            _left[i] = left.get(i);
            _height[i] = height.get(i);
            _width[i] = width.get(i);
            _bottom[i] = bottom.get(i);
        }
        this.bar(_left, _height, _width, _bottom, color);
    }

    public BarXYDataset bar(double[] left, double[] height, double[] width, double[] bottom, Color color) {
        BarXYDataset dataset;
        int datasetIndex = 0;
        if (this.chart == null) {
            dataset = new BarXYDataset(left, bottom, width, height);
            this.chart = ChartFactory.createXYBarChart(null, null, (boolean)false, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            this.chart.setBorderVisible(false);
            this.chart.setBorderPaint((Paint)DEFAULT_BG_COLOR);
            this.chart.setBackgroundPaint((Paint)DEFAULT_BG_COLOR);
            this.chart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            this.chartToPanelMap.put(this.chart, null);
            this.chartList.set(this.currentPlotNumber, this.chart);
        } else {
            boolean foundBarXYDataset = false;
            for (int i = 0; i < this.chart.getXYPlot().getDatasetCount(); ++i) {
                if (this.chart.getXYPlot().getDataset(i) == null || !this.chart.getXYPlot().getDataset(i).getClass().getName().matches(".*BarXYDataset")) continue;
                foundBarXYDataset = true;
                ((BarXYDataset)this.chart.getXYPlot().getDataset(i)).addSeries(left, bottom, width, height);
                datasetIndex = i;
                break;
            }
            if (!foundBarXYDataset) {
                BarXYDataset dataset2 = new BarXYDataset(left, bottom, width, height);
                datasetIndex = this.chart.getXYPlot().getDatasetCount();
                this.chart.getXYPlot().setDataset(datasetIndex, (XYDataset)dataset2);
                this.chart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            }
        }
        dataset = (BarXYDataset)this.chart.getXYPlot().getDataset(datasetIndex);
        if (this.chart.getXYPlot().getRenderer(datasetIndex) != null && this.chart.getXYPlot().getRenderer(datasetIndex).getClass() == XYBarRenderer.class) {
            ((XYBarRenderer)this.chart.getXYPlot().getRenderer(datasetIndex)).setUseYInterval(true);
            ((XYBarRenderer)this.chart.getXYPlot().getRenderer(datasetIndex)).setDrawBarOutline(false);
        } else {
            XYBarRenderer barRenderer = new XYBarRenderer();
            barRenderer.setUseYInterval(true);
            barRenderer.setDrawBarOutline(false);
            this.chart.getXYPlot().setRenderer(datasetIndex, (XYItemRenderer)barRenderer);
        }
        XYBarRenderer barRenderer = (XYBarRenderer)this.chart.getXYPlot().getRenderer(datasetIndex);
        int seriesNumber = dataset.getSeriesCount() - 1;
        this.chart.getXYPlot().configureDomainAxes();
        this.chart.getXYPlot().configureRangeAxes();
        this.chart.getXYPlot().setDomainGridlinesVisible(false);
        this.chart.getXYPlot().setRangeGridlinesVisible(false);
        barRenderer.setSeriesFillPaint(seriesNumber, (Paint)color, true);
        barRenderer.setSeriesPaint(seriesNumber, (Paint)color, true);
        this.seriesIndexColorMap.put(new Integer(seriesNumber), color);
        return dataset;
    }

    public void xticks(List<Double> locations, List ticklabels) {
        if (ticklabels != null && locations.size() != ticklabels.size()) {
            System.out.println("xticks(): lists must be of the same length.");
            ticklabels = null;
        }
        double[] _locations = new double[locations.size()];
        String[] _ticklabels = new String[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            _locations[i] = locations.get(i);
            _ticklabels[i] = ticklabels != null ? (String)ticklabels.get(i) : "";
        }
        this.xticks(_locations, _ticklabels);
    }

    public void xticks(double[] locations, String[] ticklabels) {
        if (this.chart != null) {
            if (ticklabels != null) {
                NumberAxis xNumberAxis = (NumberAxis)this.chart.getXYPlot().getDomainAxis();
                CustomSymbolAxis symbolaxis = new CustomSymbolAxis(xNumberAxis.getLabel(), ticklabels, locations);
                symbolaxis.setGridBandsVisible(false);
                symbolaxis.setRange(xNumberAxis.getRange());
                symbolaxis.setAutoRangeMinimumSize(xNumberAxis.getRange().getUpperBound());
                this.chart.getXYPlot().setDomainAxis((ValueAxis)symbolaxis);
            }
        } else {
            System.out.println("xticks(): No chart created");
        }
    }

    public void yticks(double[] locations, String[] ticklabels) {
        if (this.chart != null) {
            NumberAxis xNumberAxis = (NumberAxis)this.chart.getXYPlot().getRangeAxis();
            xNumberAxis.setTickLabelsVisible(false);
        } else {
            System.out.println("yticks(): No chart created");
        }
    }

    public void connect(ChartMouseListener listener) {
    }

    public HashMap getChartPanelMap() {
        return this.chartToPanelMap;
    }

    public void drawToGraphics2D(Graphics2D g, int width, int height) {
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        int boxWidth = width / this.cols;
        int boxHeight = height / this.rows;
        int currentChartIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                this.chart = this.chartList.get(currentChartIndex);
                ++currentChartIndex;
                if (this.chart == null) continue;
                int rowsUsed = 1;
                boolean colsUsed = true;
                int chartX = boxWidth * col;
                int chartY = boxHeight * row;
                int chartwidth = boxWidth;
                int chartheight = boxHeight;
                chartwidth = boxWidth * rowsUsed;
                chartheight = boxHeight;
                this.chart.plotChanged(new PlotChangeEvent(this.chart.getPlot()));
                ChartRenderingInfo info = new ChartRenderingInfo();
                this.chart.draw(g, (Rectangle2D)new Rectangle(chartX -= (rowsUsed - 1) * boxWidth, chartY, chartwidth, chartheight), (Point2D)new Point(chartX, chartY), info);
            }
        }
    }

    public void color(Color c) {
        try {
            if (!this.isXYPlot()) {
                return;
            }
            XYPlot plot = (XYPlot)this.chart.getPlot();
            int currentDatasetIndex = plot.getDatasetCount() - 1;
            XYItemRenderer r1 = plot.getRenderer(currentDatasetIndex);
            r1.setPaint((Paint)c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void color(String s) {
        Color c = this.getColor(s);
        if (c != null) {
            this.color(c);
        }
    }

    public Color getColor(String s) {
        Color c = null;
        try {
            if (this.stringColorMap.containsKey(s)) {
                return this.stringColorMap.get(s);
            }
            if (this.colourcodes.containsKey(s)) {
                return this.colourcodes.get(s);
            }
            if (this.isDouble(s)) {
                float value = (float)Double.parseDouble(s);
                c = new Color(value, value, value);
                return c;
            }
            c = this.styleSheet.stringToColor(s);
            if (c != null) {
                return c;
            }
            System.err.println("No color matching " + s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public void color(int[] rgba) {
        try {
            int red = rgba[0];
            int green = rgba[1];
            int blue = rgba[2];
            Color c = new Color(red, green, blue);
            if (rgba.length > 3) {
                c = new Color(red, green, blue, rgba[3]);
            }
            this.color(c);
        }
        catch (Exception e) {
            System.out.println("Problem with color( " + Arrays.toString(rgba) + ")");
        }
    }

    public void color(float value) {
        try {
            if ((double)value >= 0.0 && (double)value <= 1.0) {
                Color c = new Color(value, value, value);
                this.color(c);
            } else {
                System.out.println("color(float): float must be in the range 0.0 - 1.0");
            }
        }
        catch (Exception e) {
            System.out.println("Problem with color(" + value + ")");
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public JFreeChart getChart(int row, int col) {
        int index = this.cols * (row - 1) + col - 1;
        if (row < 0 || row > this.rows || col < 0 || col > this.cols || index >= this.chartList.size() || index < 0) {
            System.out.println("Problem in getChart(" + row + ", " + col + "): index=" + index);
            System.out.println("Total rows and columns: " + this.rows + ", " + this.cols);
            return null;
        }
        return this.chartList.get(index);
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public HashMap getChartToPanelMap() {
        return this.chartToPanelMap;
    }

    public void setChartToPanelMap(HashMap chartToPanelMap) {
        this.chartToPanelMap = chartToPanelMap;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public JPanel getJpanel() {
        return this.jpanel;
    }

    public void setJpanel(JPanel jpanel) {
        this.jpanel = jpanel;
    }

    public void text(String text, double x, double y) {
        if (this.chart == null) {
            System.out.println("Current chart is null");
            return;
        }
        if (this.chart.getPlot() == null) {
            System.out.println("Current chart plot is null");
            return;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        XYTextAnnotation annotation = new XYTextAnnotation(text, x, y);
        plot.addAnnotation((XYAnnotation)annotation);
    }

    public void difference(double[] x, double[] y1, double[] y2, Color color, boolean multipleAxes) {
        if (y1 == null) {
            System.out.println("difference(x, y1, y2): y1 is null");
            return;
        }
        if (y2 == null) {
            System.out.println("difference(x, y1, y2): y2 is null");
            return;
        }
        if (y1.length != y2.length) {
            System.out.println("difference(x, y1, y2): length of y1 != y2");
            return;
        }
        if (x == null) {
            x = new double[y1.length];
            for (int i = 0; i < y1.length; ++i) {
                x[i] = i;
            }
        }
        if (this.chart == null) {
            this.createXYChart();
        }
        XYPlot plot = this.chart.getXYPlot();
        XYSeries series1 = new XYSeries((Comparable)((Object)""));
        XYSeries series2 = new XYSeries((Comparable)((Object)""));
        for (int i = 0; i < y1.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y1[i]) || Double.isNaN(y2[i])) continue;
            series1.add(x[i], y1[i]);
            series2.add(x[i], y2[i]);
        }
        XYSeriesCollection sdDataset = new XYSeriesCollection();
        sdDataset.addSeries(series1);
        sdDataset.addSeries(series2);
        int newDatasetIndex = plot.getDatasetCount();
        plot.setDataset(newDatasetIndex, (XYDataset)sdDataset);
        XYDifferenceRenderer differenceRenderer = new XYDifferenceRenderer((Paint)color, (Paint)color, false);
        plot.setRenderer(newDatasetIndex, (XYItemRenderer)differenceRenderer);
        Color transparent = new Color(0, 0, 0, 0);
        AbstractRenderer r1 = (AbstractRenderer)plot.getRenderer(newDatasetIndex);
        r1.setSeriesPaint(0, (Paint)transparent);
        r1.setSeriesPaint(1, (Paint)transparent);
    }

    protected JFreeChart createXYChart() {
        this.chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)new XYSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chartList.set(this.currentPlotNumber, this.chart);
        this.chart.setBorderPaint((Paint)DEFAULT_BG_COLOR);
        this.chart.setBackgroundPaint((Paint)DEFAULT_BG_COLOR);
        this.chart.setBorderVisible(false);
        this.chartToPanelMap.put(this.chart, null);
        return this.chart;
    }

    protected XYSeriesCollection getXYDataset() {
        XYSeriesCollection dataset = null;
        try {
            dataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
        }
        catch (Exception e) {
            dataset = new XYSeriesCollection();
            this.chart.getXYPlot().setDataset((XYDataset)dataset);
        }
        return dataset;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void hist(double[] data, int bins) {
        this.hist(data, bins, "", null);
    }

    public void hist(double[] data, int bins, String dataname) {
        this.hist(data, bins, dataname, null);
    }

    public XYDataset hist(double[] data, int bins, String dataname, Color color) {
        if (dataname == null) {
            dataname = "";
        }
        HistogramDataset dataset = new HistogramDataset();
        dataset.addSeries((Comparable)((Object)dataname), data, bins);
        if (this.chart == null) {
            this.createXYChart();
        }
        XYPlot plot = this.chart.getXYPlot();
        int currentDatasetIndex = plot.getDatasetCount();
        plot.setDataset(currentDatasetIndex, (XYDataset)dataset);
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setDrawBarOutline(false);
        plot.setRenderer(currentDatasetIndex, (XYItemRenderer)renderer);
        if (color != null) {
            plot.getRendererForDataset((XYDataset)dataset).setSeriesPaint(dataset.getSeriesCount() - 1, (Paint)color);
        }
        this.grid(false);
        return dataset;
    }

    public void grid(boolean state) {
        this.chart.getXYPlot().setDomainGridlinesVisible(state);
        this.chart.getXYPlot().setRangeGridlinesVisible(state);
    }

    public void gridx(boolean state) {
        if (!this.isXYPlot()) {
            return;
        }
        this.chart.getXYPlot().setDomainGridlinesVisible(state);
    }

    public void gridy(boolean state) {
        if (!this.isXYPlot()) {
            return;
        }
        this.chart.getXYPlot().setRangeGridlinesVisible(state);
    }

    protected Map<String, Color> getStringToColorMap() {
        HashMap<String, Color> ret = new HashMap<String, Color>();
        try {
            Class<Color> clazz = Color.class;
            Field[] filc = clazz.getDeclaredFields();
            for (int i = 0; i < filc.length; ++i) {
                Object o;
                Field f = filc[i];
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !((o = f.get(null)) instanceof Color)) continue;
                ret.put(f.getName(), (Color)o);
            }
            return ret;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void clf() {
        this.chartList.clear();
        this.chart = null;
        this.chartMouseListeners.clear();
        this.chartToPanelMap.clear();
    }

    public Dataset errorbar(double[] x, double[] y, double[] xerr, double[] yerr, Color color, boolean barsabove) {
        if (x == null) {
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        }
        XYSeries series1 = new XYSeries((Comparable)((Object)"1"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"2"));
        boolean barsVertical = true;
        if (xerr != null) {
            barsVertical = false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i]) || Double.isInfinite(x[i]) || Double.isInfinite(y[i]) || !barsVertical) continue;
            series1.add(x[i], y[i] - yerr[i]);
            series2.add(x[i], y[i] + yerr[i]);
        }
        if (this.chart == null) {
            this.createXYChart();
        }
        XYPlot plot = this.chart.getXYPlot();
        int currentDatasetIndex = plot.getDatasetCount();
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        plot.setDataset(currentDatasetIndex, (XYDataset)dataset);
        XYStatisticalLineAndShapeRenderer renderer = color != null ? new XYStatisticalLineAndShapeRenderer(color) : new XYStatisticalLineAndShapeRenderer(Color.black);
        plot.setRenderer(currentDatasetIndex, (XYItemRenderer)renderer);
        renderer.setSeriesVisibleInLegend(currentDatasetIndex, false);
        renderer.setSeriesVisibleInLegend(false);
        renderer.setSeriesVisibleInLegend(false, true);
        return dataset;
    }

    protected Color getMostRecentColor() {
        try {
            int datasetIndex = this.chart.getXYPlot().getDatasetCount() - 1;
            System.out.println("datasetIndex:" + datasetIndex);
            XYSeriesCollection dataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset(datasetIndex);
            System.out.println(this.chart.getXYPlot().getRendererForDataset((XYDataset)dataset).getClass().getName());
            return (Color)this.chart.getXYPlot().getRendererForDataset((XYDataset)dataset).getSeriesPaint(dataset.getSeriesCount() - 1);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public void setRangeSpace(double x) {
        AxisSpace space = new AxisSpace();
        space.setLeft(x);
        this.chart.getXYPlot().setFixedRangeAxisSpace(space);
    }

    public void setDomainSpace(double x) {
        AxisSpace space = new AxisSpace();
        space.setBottom(x);
        this.chart.getXYPlot().setFixedDomainAxisSpace(space);
    }

    public void savefig(String filename) {
        int calculatedWidth = (int)this.figureWidth * this.dpi;
        int calculatedHeight = (int)this.figureHeight * this.dpi;
        this.savefig(filename, calculatedWidth, calculatedHeight);
    }

    public void savefig(String filename, int width, int height) {
        try {
            String fname = filename;
            String filetype = fname.substring(fname.length() - 3);
            if (filetype.equalsIgnoreCase("png")) {
                BufferedImage b = new BufferedImage(width, height, 1);
                Graphics2D g = b.createGraphics();
                this.drawToGraphics2D(g, width, height);
                g.dispose();
                ImageIO.write((RenderedImage)b, "png", new File(fname));
            } else if (filetype.equalsIgnoreCase("jpg") || filetype.equalsIgnoreCase("jpeg")) {
                BufferedImage b = new BufferedImage(width, height, 1);
                Graphics2D g = b.createGraphics();
                this.drawToGraphics2D(g, width, height);
                g.dispose();
                ImageIO.write((RenderedImage)b, "jpg", new File(fname));
            } else {
                System.out.println(filename + ": image type not supported");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean isXYPlot() {
        if (this.chart == null) {
            System.err.println("chart is null");
            return false;
        }
        if (this.chart.getXYPlot() == null) {
            System.err.println("chart.getPlot() is null");
            return false;
        }
        return true;
    }

    public void setQuitOnWindowClose(boolean close) {
        this.closeOnExit = close;
        if (this.frame != null) {
            if (close) {
                this.frame.setDefaultCloseOperation(3);
            } else {
                this.frame.setDefaultCloseOperation(1);
            }
        }
    }

    public void setShapesVisible(boolean visible) {
        XYPlot plot = this.chart.getXYPlot();
        int currentDatasetIndex = plot.getDatasetCount() - 1;
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer(currentDatasetIndex);
        renderer.setShapesVisible(visible);
    }

    public void setBackgColor(Color color) {
        this.chart.getPlot().setBackgroundPaint((Paint)color);
    }

    public void setAntiAlias(boolean isAntiAlias) {
        this.chart.setAntiAlias(isAntiAlias);
    }

    protected void setSeriesColor(Color color) {
        XYPlot plot = this.chart.getXYPlot();
        if (plot == null) {
            System.err.println("setSeriesColor() but plot is null");
            return;
        }
        if (color != null && plot.getDatasetCount() > 0) {
            plot.getRendererForDataset(plot.getDataset(plot.getDatasetCount() - 1)).setSeriesPaint(plot.getDataset(plot.getDatasetCount() - 1).getSeriesCount() - 1, (Paint)color);
        }
    }
}

