/*
 * Decompiled with CFR 0.152.
 */
package jyplot;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.html.StyleSheet;

public class GraphicsUtil {
    static Map<String, Color> stringColorMap = GraphicsUtil.getStringToColorMap();
    static StyleSheet styleSheet = new StyleSheet();
    static Color mask = Color.blue;

    public static Color getColorFromString(String s) {
        Color c = null;
        try {
            if (stringColorMap.containsKey(s)) {
                return stringColorMap.get(s);
            }
            if (GraphicsUtil.isDouble(s)) {
                float value = (float)Double.parseDouble(s);
                c = new Color(value, value, value);
                return c;
            }
            c = styleSheet.stringToColor(s);
            if (c != null) {
                return c;
            }
            System.out.println("No color matching " + s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    private static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static Map<String, Color> getStringToColorMap() {
        HashMap<String, Color> ret = new HashMap<String, Color>();
        try {
            Class<Color> clazz = Color.class;
            Field[] filc = clazz.getDeclaredFields();
            for (int i = 0; i < filc.length; ++i) {
                Object o;
                Field f = filc[i];
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !((o = f.get(null)) instanceof Color)) continue;
                ret.put(f.getName(), (Color)o);
            }
            return ret;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

