/*
 * Decompiled with CFR 0.152.
 */
package jhplot.shapes;

import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import jhplot.HPlot;
import jhplot.gui.HelpBrowser;
import jhplot.shapes.HShape;

public class Picture
extends HShape {
    private static final long serialVersionUID = 1L;
    protected String imageFile;
    protected Image image;

    public Picture(double X1, double Y1, String imageFile) {
        super(X1, Y1, 0.0, 0.0, HShape.DFS, null);
        this.whoAm = 4;
        this.imageFile = imageFile;
        this.image = this.getImage(imageFile);
    }

    public Picture(double X1, double Y1, Image image) {
        super(X1, Y1, 0.0, 0.0, HShape.DFS, null);
        this.whoAm = 4;
        this.image = image;
    }

    public Image getPicture() {
        return this.image;
    }

    private Image getImage(String filename) {
        URL url2;
        ImageIcon icon = new ImageIcon(filename);
        if (icon == null || icon.getImageLoadStatus() != 8) {
            try {
                url2 = new URL(filename);
                icon = new ImageIcon(url2);
            }
            catch (Exception url2) {
                // empty catch block
            }
        }
        if (icon == null || icon.getImageLoadStatus() != 8) {
            url2 = HPlot.class.getResource(filename);
            if (url2 == null) {
                throw new RuntimeException("image " + filename + " not found");
            }
            icon = new ImageIcon(url2);
        }
        return icon.getImage();
    }

    public String toString() {
        String s1 = Double.toString(this.X1);
        String s2 = Double.toString(this.Y1);
        String pos = " X1=" + s1 + "  Y1" + s2;
        return "Image: " + pos;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

