/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca.tests;

import Jama.Matrix;
import java.io.IOException;
import java.io.InputStream;
import jhplot.math.pca.DataReader;
import jhplot.math.pca.PCA;
import jhplot.math.pca.covmatrixevd.CovarianceMatrixEVDCalculator;
import junit.framework.TestCase;

public abstract class TemplatePCATest
extends TestCase {
    private final double precision;
    private final CovarianceMatrixEVDCalculator evdCalc;

    public TemplatePCATest(double precision, CovarianceMatrixEVDCalculator evdCalc) {
        this.precision = precision;
        this.evdCalc = evdCalc;
    }

    protected void checkPCATransformation(String trainingDataPath, String testingDataPath, String expectedRotatedDataPath, String expectedWhitenedDataPath) throws IOException {
        this.checkPCATransformation(trainingDataPath, testingDataPath, expectedRotatedDataPath, expectedWhitenedDataPath, true);
    }

    protected void checkPCATransformation(String trainingDataPath, String testingDataPath, String expectedRotatedDataPath, String expectedWhitenedDataPath, boolean center) throws IOException {
        Matrix training = DataReader.read(this.getFile(trainingDataPath), false);
        Matrix testing = DataReader.read(this.getFile(testingDataPath), false);
        Matrix expectedRotated = DataReader.read(this.getFile(expectedRotatedDataPath), false);
        PCA pca = this.createPCA(training, center);
        Matrix actualRotated = pca.transform(testing, PCA.TransformationType.ROTATION);
        TemplatePCATest.assertTrue((boolean)TemplatePCATest.equalColumnsWithSignAccuracy(expectedRotated, actualRotated, this.precision));
        Matrix expectedWhitened = DataReader.read(this.getFile(expectedWhitenedDataPath), false);
        Matrix actualWhitened = pca.transform(testing, PCA.TransformationType.WHITENING);
        TemplatePCATest.assertTrue((boolean)TemplatePCATest.equalColumnsWithSignAccuracy(expectedWhitened, actualWhitened, this.precision));
    }

    protected void checkOutliers(String allDataFile, String outliersDataFile, String nonOutliersDataFile) throws IOException {
        Matrix pts = DataReader.read(this.getFile(allDataFile), false);
        PCA pca = this.createPCA(pts, true);
        Matrix outliers = DataReader.read(this.getFile(outliersDataFile), false);
        for (int r = 0; r < outliers.getRowDimension(); ++r) {
            Matrix vector = outliers.getMatrix(r, r, 0, outliers.getColumnDimension() - 1);
            TemplatePCATest.assertFalse((boolean)pca.belongsToGeneratedSubspace(vector));
        }
        Matrix nonOutliers = DataReader.read(this.getFile(nonOutliersDataFile), false);
        for (int r = 0; r < nonOutliers.getRowDimension(); ++r) {
            Matrix vector = nonOutliers.getMatrix(r, r, 0, nonOutliers.getColumnDimension() - 1);
            TemplatePCATest.assertTrue((boolean)pca.belongsToGeneratedSubspace(vector));
        }
    }

    protected void checkDimsReduction(String filePath, int inputDimsNo, int outputDimsNo) throws IOException {
        Matrix pts = DataReader.read(this.getFile(filePath), false);
        PCA pca = this.createPCA(pts, true);
        TemplatePCATest.assertEquals((int)inputDimsNo, (int)pca.getInputDimsNo());
        TemplatePCATest.assertEquals((int)outputDimsNo, (int)pca.getOutputDimsNo());
    }

    protected InputStream getFile(String filePath) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(filePath);
    }

    private static boolean equalColumnsWithSignAccuracy(Matrix expected, Matrix actual, double precision) {
        if (expected.getColumnDimension() != actual.getColumnDimension() || expected.getRowDimension() != actual.getRowDimension()) {
            return false;
        }
        for (int c = 0; c < expected.getColumnDimension(); ++c) {
            Matrix expectedColumn = expected.getMatrix(0, expected.getRowDimension() - 1, c, c);
            Matrix actualColumn = actual.getMatrix(0, expected.getRowDimension() - 1, c, c);
            Matrix negatedActualColumn = actualColumn.times(-1.0);
            if (TemplatePCATest.areEqual(expectedColumn, actualColumn, precision) || TemplatePCATest.areEqual(expectedColumn, negatedActualColumn, precision)) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(Matrix m0, Matrix m1, double precision) {
        if (m0.getColumnDimension() != m1.getColumnDimension() || m0.getRowDimension() != m1.getRowDimension()) {
            return false;
        }
        for (int c = 0; c < m0.getColumnDimension(); ++c) {
            for (int r = 0; r < m0.getRowDimension(); ++r) {
                if (!(Math.abs(m0.get(r, c) - m1.get(r, c)) > precision)) continue;
                return false;
            }
        }
        return true;
    }

    private PCA createPCA(Matrix pts, boolean center) {
        return new PCA(pts, this.evdCalc, center);
    }
}

