/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca.tests;

import Jama.Matrix;
import java.io.IOException;
import jhplot.math.pca.PCA;
import jhplot.math.pca.covmatrixevd.EVDBased;
import jhplot.math.pca.tests.TemplatePCATest;

public class EVDBasedPCA_Test
extends TemplatePCATest {
    public EVDBasedPCA_Test() {
        super(1.0E-8, new EVDBased());
    }

    public void testCovarianceMatrix() {
        Matrix data = new Matrix((double[][])new double[][]{{4.0, 2.0, 0.6}, {4.2, 2.1, 0.59}, {3.9, 2.0, 0.58}, {4.3, 2.1, 0.62}, {4.1, 2.2, 0.63}});
        Matrix actual = PCA.calculateCovarianceMatrix(data);
        Matrix expected = new Matrix((double[][])new double[][]{{0.025, 0.0075, 0.00175}, {0.0075, 0.007, 0.00135}, {0.00175, 0.00135, 4.3E-4}});
        EVDBasedPCA_Test.assertEquals((int)expected.getRowDimension(), (int)actual.getRowDimension());
        EVDBasedPCA_Test.assertEquals((int)expected.getColumnDimension(), (int)actual.getColumnDimension());
        for (int r = 0; r < expected.getRowDimension(); ++r) {
            for (int c = 0; c < expected.getColumnDimension(); ++c) {
                EVDBasedPCA_Test.assertEquals((double)expected.get(r, c), (double)actual.get(r, c), (double)1.0E-9);
            }
        }
    }

    public void testIris() throws IOException {
        this.checkPCATransformation("data/iris_data_set/iris.csv", "data/iris_data_set/iris.csv", "data/iris_data_set/eigen-iris_rotated.csv", "data/iris_data_set/eigen-iris_whitened.csv");
        this.checkPCATransformation("data/iris_data_set/iris.csv", "data/iris_data_set/iris-other.csv", "data/iris_data_set/eigen-other_rotated.csv", "data/iris_data_set/eigen-other_whitened.csv");
        this.checkPCATransformation("data/iris_data_set_normalized/iris-normalized.csv", "data/iris_data_set_normalized/iris-normalized.csv", "data/iris_data_set_normalized/eigen-iris_rotated.csv", "data/iris_data_set_normalized/eigen-iris_whitened.csv", false);
    }

    public void testImageSegementationClass1() throws IOException {
        this.checkPCATransformation("data/dim_reduction-image_segmentation_data/image-segmentation-class1.csv", "data/dim_reduction-image_segmentation_data/image-segmentation-class1.csv", "data/dim_reduction-image_segmentation_data/eigen_rotated.csv", "data/dim_reduction-image_segmentation_data/eigen_whitened.csv");
    }

    public void testOutliers() throws IOException {
        this.checkOutliers("data/dim_reduction-artificial_data/all.csv", "data/dim_reduction-artificial_data/all-outliers.csv", "data/dim_reduction-artificial_data/all-non_outliers.csv");
    }

    public void testDimsReduction() throws IOException {
        this.checkDimsReduction("data/dim_reduction-artificial_data/all.csv", 6, 2);
        this.checkDimsReduction("data/dim_reduction-artificial_data/data_3d.csv", 3, 1);
        this.checkDimsReduction("data/dim_reduction-artificial_data/data_2d.csv", 2, 1);
        this.checkDimsReduction("data/dim_reduction-artificial_data/no_dim_reduction.csv", 2, 2);
    }
}

