/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class LaplaceRandomVariable
extends AbstractContinuousRandomVariable {
    private double mean;
    private double scale;

    public LaplaceRandomVariable() {
        this(0.0, 1.0);
    }

    public LaplaceRandomVariable(double m, double s) {
        this(m, s, new RandomRNG());
    }

    public LaplaceRandomVariable(double m, double s, RNG source) {
        super(source);
        this.setMean(m);
        this.setScale(s);
    }

    public static double nextRandomVariable(double m, double s, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) <= 0.0 || u >= 1.0) {
        }
        double ret = u < 0.5 ? m + s * Math.log(1.0 + (2.0 * u - 1.0)) : m - s * Math.log(1.0 - (2.0 * u - 1.0));
        return ret;
    }

    private double getMean() {
        return this.mean;
    }

    private double getScale() {
        return this.scale;
    }

    @Override
    public double nextRandomVariable() {
        return LaplaceRandomVariable.nextRandomVariable(this.getMean(), this.getScale(), this.getSource());
    }

    private void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("mean must be a number.");
        }
        this.mean = m;
    }

    private void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = s;
    }
}

